/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.feature.gen.cave;

import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class WorldGenCave
extends WorldGenerator {
    protected final ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST};

    public WorldGenCave(boolean doBlockNotify) {
        super(doBlockNotify);
    }

    protected boolean isGoodStart(World world, int x, int y, int z) {
        if (this.supports(world, x, y, z)) {
            int sides = 0;
            for (ForgeDirection dir : this.directions) {
                if (!this.isValidBlock(world, x + dir.offsetX, y, z + dir.offsetZ)) {
                    return false;
                }
                if (!this.isValidBlock(world, x + dir.offsetX, y - 1, z + dir.offsetZ) || !world.isSideSolid(x + dir.offsetX, y - 1, z + dir.offsetZ, dir)) continue;
                ++sides;
            }
            return sides > 0;
        }
        return false;
    }

    protected boolean supports(World world, int x, int y, int z) {
        return this.isValidBlock(world, x, y, z) && world.func_147437_c(x, y - 1, z);
    }

    protected boolean isValidBlock(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149721_r();
    }

    protected class PlantLocation {
        private ChunkCoordinates pos;
        private int height;

        public PlantLocation(World world, ChunkCoordinates pos) {
            this.setPos(pos);
            this.setHeight(1);
            while (world.func_147437_c(pos.field_71574_a, pos.field_71572_b - this.getHeight(), pos.field_71573_c) && pos.field_71572_b - this.getHeight() > 0) {
                this.setHeight(this.getHeight() + 1);
            }
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public ChunkCoordinates getPos() {
            return this.pos;
        }

        public void setPos(ChunkCoordinates pos) {
            this.pos = pos;
        }
    }
}

