/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.events.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.plants.crops.BlockBLGenericCrop;
import thebetweenlands.world.WorldProviderBetweenlands;
import thebetweenlands.world.events.EnvironmentEventRegistry;
import thebetweenlands.world.events.TimedEnvironmentEvent;

public class EventHeavyRain
extends TimedEnvironmentEvent {
    public EventHeavyRain(EnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public String getEventName() {
        return "heavyRain";
    }

    @Override
    public int getOffTime(Random rnd) {
        return rnd.nextInt(130000) + 150000;
    }

    @Override
    public int getOnTime(Random rnd) {
        return rnd.nextInt(10000) + 8000;
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (this.isActive() && world.field_73011_w instanceof WorldProviderBetweenlands && world.field_73012_v.nextInt(20) == 0 && !world.field_72995_K && world instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)world;
            HashSet<ChunkCoordIntPair> activeChunks = new HashSet<ChunkCoordIntPair>();
            activeChunks.addAll((Collection<ChunkCoordIntPair>)world.getPersistentChunks().keySet());
            for (int i = 0; i < world.field_73010_i.size(); ++i) {
                EntityPlayer entityplayer = (EntityPlayer)world.field_73010_i.get(i);
                int cx = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
                int cz = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
                int viewDist = worldServer.func_73046_m().func_71203_ab().func_72395_o();
                for (int cxo = -viewDist; cxo <= viewDist; ++cxo) {
                    for (int czo = -viewDist; czo <= viewDist; ++czo) {
                        activeChunks.add(new ChunkCoordIntPair(cx + cxo, cz + czo));
                    }
                }
            }
            for (ChunkCoordIntPair chunkPos : activeChunks) {
                int bz;
                int cbz;
                int by;
                if (world.field_73012_v.nextInt(4) != 0) continue;
                Chunk chunk = worldServer.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
                int cbx = world.field_73012_v.nextInt(16);
                int bx = chunkPos.field_77276_a * 16 + cbx;
                if (world.func_147439_a(bx, (by = chunk.func_76626_d(cbx, cbz = world.field_73012_v.nextInt(16))) - 1, bz = chunkPos.field_77275_b * 16 + cbz) == BLBlockRegistry.puddle || !world.func_147437_c(bx, by, bz) && !(world.func_147439_a(bx, by, bz) instanceof BlockBLGenericCrop) || !BLBlockRegistry.puddle.func_149742_c(world, bx, by, bz)) continue;
                world.func_147449_b(bx, by, bz, BLBlockRegistry.puddle);
            }
        }
    }
}

