/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.events.impl;

import java.util.Random;
import net.minecraft.world.World;
import thebetweenlands.world.events.EnvironmentEventRegistry;
import thebetweenlands.world.events.TimedEnvironmentEvent;

public class EventDenseFog
extends TimedEnvironmentEvent {
    private float fade = 1.0f;
    private float lastFade = 1.0f;

    public EventDenseFog(EnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public String getEventName() {
        return "denseFog";
    }

    @Override
    public int getOffTime(Random rnd) {
        return rnd.nextInt(40000) + 21000;
    }

    @Override
    public int getOnTime(Random rnd) {
        return rnd.nextInt(22000) + 9000;
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (world.field_72995_K) {
            if (this.isActive()) {
                if (this.fade > 0.0f) {
                    this.lastFade = this.fade;
                    this.fade -= 0.002f;
                } else {
                    this.fade = 0.0f;
                    this.lastFade = 0.0f;
                }
            } else if (this.fade < 1.0f) {
                this.lastFade = this.fade;
                this.fade += 0.002f;
            } else {
                this.fade = 1.0f;
                this.lastFade = 1.0f;
            }
        }
    }

    public float getFade(float partialTicks) {
        return this.fade + (this.fade - this.lastFade) * partialTicks;
    }
}

