/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.events.impl;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.world.events.EnvironmentEventRegistry;
import thebetweenlands.world.events.TimedEnvironmentEvent;

public class EventBloodSky
extends TimedEnvironmentEvent {
    private boolean soundPlayed = true;
    private float skyTransparency = 0.0f;
    private float lastSkyTransparency = 0.0f;

    public EventBloodSky(EnvironmentEventRegistry registry) {
        super(registry);
    }

    public void setSkyTransparency(float transparency) {
        this.lastSkyTransparency = this.skyTransparency;
        this.skyTransparency = transparency;
    }

    public float getSkyTransparency(float partialTicks) {
        return this.skyTransparency + (this.skyTransparency - this.lastSkyTransparency) * partialTicks;
    }

    @Override
    public String getEventName() {
        return "bloodSky";
    }

    @Override
    public int getOffTime(Random rnd) {
        return rnd.nextInt(400000) + 500000;
    }

    @Override
    public int getOnTime(Random rnd) {
        return rnd.nextInt(18000) + 15000;
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (world.field_72995_K) {
            if (this.isActive()) {
                if (this.skyTransparency < 1.0f) {
                    this.setSkyTransparency(this.skyTransparency + 0.003f);
                }
                if (this.skyTransparency > 1.0f) {
                    this.setSkyTransparency(1.0f);
                }
            } else {
                if (this.skyTransparency > 0.0f) {
                    this.setSkyTransparency(this.skyTransparency - 0.003f);
                }
                if (this.skyTransparency < 0.0f) {
                    this.setSkyTransparency(0.0f);
                }
            }
        }
    }

    @Override
    public void setActive(boolean active, boolean markDirty) {
        super.setActive(active, markDirty);
        if (active) {
            World world = TheBetweenlands.proxy.getClientWorld();
            if (world != null && world.field_72995_K && !this.soundPlayed) {
                world.func_72980_b(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v, "thebetweenlands:bloodSkyRoar", 100.0f, 1.0f, false);
            }
            this.soundPlayed = true;
        } else {
            this.soundPlayed = false;
        }
    }
}

