/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.events.impl;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.world.World;
import thebetweenlands.world.events.EnvironmentEventRegistry;
import thebetweenlands.world.events.TimedEnvironmentEvent;

public class EventAuroras
extends TimedEnvironmentEvent {
    private short auroraType = 0;

    public EventAuroras(EnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public String getEventName() {
        return "auroras";
    }

    @Override
    public int getOffTime(Random rnd) {
        return rnd.nextInt(42000) + 28000;
    }

    @Override
    public int getOnTime(Random rnd) {
        this.auroraType = (short)rnd.nextInt(3);
        return rnd.nextInt(20000) + 8000;
    }

    @Override
    public void setActive(boolean active, boolean markDirty) {
        if (active && this.getRegistry().getActiveEvents().size() <= 1) {
            super.setActive(active, markDirty);
            return;
        }
        if (!active) {
            super.setActive(active, markDirty);
        }
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (this.getRegistry().getActiveEvents().size() > 1) {
            this.setActive(false, true);
        }
    }

    @Override
    public void saveEventData() {
        super.saveEventData();
        this.getData().func_74777_a("auroraType", this.auroraType);
    }

    @Override
    public void loadEventData() {
        super.loadEventData();
        this.auroraType = this.getData().func_74765_d("auroraType");
    }

    @Override
    public void loadEventPacket(ByteBuf buffer) {
        this.auroraType = buffer.readShort();
    }

    @Override
    public void sendEventPacket(ByteBuf buffer) {
        buffer.writeShort((int)this.auroraType);
    }

    public short getAuroraType() {
        return this.auroraType;
    }
}

