/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.events;

import java.util.Random;
import net.minecraft.world.World;
import thebetweenlands.world.events.EnvironmentEvent;
import thebetweenlands.world.events.EnvironmentEventRegistry;

public abstract class TimedEnvironmentEvent
extends EnvironmentEvent {
    private int time = 0;
    private Random rnd = null;

    public TimedEnvironmentEvent(EnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public void update(World world) {
        if (world.field_72995_K || this.getRegistry().isDisabled()) {
            return;
        }
        this.rnd = world.field_73012_v;
        --this.time;
        if (this.time <= 0) {
            this.time = this.isActive() ? this.getOffTime(this.rnd) : this.getOnTime(this.rnd);
            this.setActive(!this.isActive(), true);
        }
    }

    @Override
    public void setActive(boolean active, boolean markDirty) {
        super.setActive(active, false);
        if (this.rnd != null) {
            this.time = !this.isActive() ? this.getOffTime(this.rnd) : this.getOnTime(this.rnd);
        }
        if (markDirty) {
            this.markDirty();
        }
    }

    @Override
    public void saveEventData() {
        this.getData().func_74768_a("time", this.time);
    }

    @Override
    public void loadEventData() {
        this.time = this.getData().func_74762_e("time");
    }

    @Override
    public void setDefaults() {
        this.time = this.getOffTime(new Random());
    }

    public abstract int getOffTime(Random var1);

    public abstract int getOnTime(Random var1);
}

