/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import thebetweenlands.world.events.EnvironmentEvent;
import thebetweenlands.world.events.impl.EventAuroras;
import thebetweenlands.world.events.impl.EventBloodSky;
import thebetweenlands.world.events.impl.EventDenseFog;
import thebetweenlands.world.events.impl.EventHeavyRain;
import thebetweenlands.world.events.impl.EventSpoopy;

public class EnvironmentEventRegistry {
    public final EventDenseFog DENSE_FOG = new EventDenseFog(this);
    public final EnvironmentEvent HEAVY_RAIN = new EventHeavyRain(this);
    public final EventAuroras AURORAS = new EventAuroras(this);
    public final EventBloodSky BLOODSKY = new EventBloodSky(this);
    public final EventSpoopy SPOOPY = new EventSpoopy(this);
    private final Map<String, EnvironmentEvent> REGISTERED_EVENTS = new HashMap<String, EnvironmentEvent>();
    private boolean disabled = false;

    public void init() {
        this.register(this.DENSE_FOG);
        this.register(this.HEAVY_RAIN);
        this.register(this.AURORAS);
        this.register(this.BLOODSKY);
        this.register(this.SPOOPY);
    }

    public void register(EnvironmentEvent event) {
        this.REGISTERED_EVENTS.put(event.getEventName(), event);
    }

    public Map<String, EnvironmentEvent> getEvents() {
        return Collections.unmodifiableMap(this.REGISTERED_EVENTS);
    }

    public EnvironmentEvent forName(String eventName) {
        return this.REGISTERED_EVENTS.get(eventName);
    }

    public List<EnvironmentEvent> getActiveEvents() {
        return this.getEventsOfState(true);
    }

    public List<EnvironmentEvent> getEventsOfState(boolean isActive) {
        ArrayList<EnvironmentEvent> list = new ArrayList<EnvironmentEvent>();
        for (EnvironmentEvent event : this.REGISTERED_EVENTS.values()) {
            if (event.isActive() != isActive) continue;
            list.add(event);
        }
        return list;
    }

    public List<String> getEventNames() {
        ArrayList<String> eventNames = new ArrayList<String>();
        for (EnvironmentEvent event : this.REGISTERED_EVENTS.values()) {
            eventNames.add(event.getEventName());
        }
        return eventNames;
    }

    public List<String> getEventNamesOfState(boolean isActive) {
        ArrayList<String> eventNames = new ArrayList<String>();
        for (EnvironmentEvent event : this.REGISTERED_EVENTS.values()) {
            if (event.isActive() != isActive) continue;
            eventNames.add(event.getEventName());
        }
        return eventNames;
    }

    public String getGrammaticalActiveEventNameList() {
        StringBuilder list = new StringBuilder();
        EnvironmentEvent[] events = this.REGISTERED_EVENTS.values().toArray(new EnvironmentEvent[0]);
        for (int i = 0; i < events.length; ++i) {
            String eventName = events[i].getEventName();
            if (i > 0) {
                list.append(", ");
                if (i == events.length - 1) {
                    list.append("and ");
                }
            }
            list.append(eventName);
        }
        return list.toString();
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void enable() {
        this.disabled = false;
    }

    public void disable() {
        this.disabled = true;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }
}

