/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.spawning.spawners;

import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.world.biomes.spawning.MobSpawnHandler;
import thebetweenlands.world.storage.chunk.BetweenlandsChunkData;
import thebetweenlands.world.storage.chunk.storage.ChunkStorage;
import thebetweenlands.world.storage.chunk.storage.location.EnumLocationType;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;

public class LocationSpawnEntry
extends MobSpawnHandler.BLSpawnEntry {
    protected final EnumLocationType locationType;

    public LocationSpawnEntry(Class<? extends EntityLiving> entityType, EnumLocationType locationType) {
        super(entityType);
        this.locationType = locationType;
    }

    public LocationSpawnEntry(Class<? extends EntityLiving> entityType, short weight, EnumLocationType locationType) {
        super(entityType, weight);
        this.locationType = locationType;
    }

    @Override
    protected void update(World world, int x, int y, int z) {
        boolean inLocation = false;
        Chunk chunk = world.func_72938_d(x, z);
        if (chunk != null) {
            BetweenlandsChunkData chunkData = BetweenlandsChunkData.forChunk(world, chunk);
            for (ChunkStorage storage : chunkData.getStorage()) {
                LocationStorage location;
                if (!(storage instanceof LocationStorage) || !((LocationStorage)storage).isInside(x, y, z) || !this.locationType.equals((Object)(location = (LocationStorage)storage).getType())) continue;
                inLocation = true;
                break;
            }
        }
        if (!inLocation) {
            this.setWeight((short)0);
        } else {
            this.setWeight(this.getBaseWeight());
        }
    }
}

