/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.spawning;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import thebetweenlands.utils.IWeightProvider;
import thebetweenlands.utils.WeightedList;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.WorldProviderBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;

public class MobSpawnHandler {
    public static MobSpawnHandler INSTANCE = new MobSpawnHandler();
    private static final int CHUNK_GEN_SPAWN_RUNS = 64;
    private static final byte SPAWN_CHUNK_DISTANCE = 4;
    private static final byte SPAWN_CHUNK_RIM = 2;
    private static final int SPAWNING_ATTEMPTS_PER_CHUNK = 8;
    private static final int SPAWNING_ATTEMPTS_PER_GROUP = 32;
    private static final int MAX_SPAWNS_PER_CHUNK = 6;
    private static final int MAX_ENTITIES_PER_LOADED_AREA = ConfigHandler.maxEntitiesPerLoadedArea;
    private static final float MAX_ENTITIES_PER_CHUNK_MULTIPLIER = (float)MAX_ENTITIES_PER_LOADED_AREA / 32.0f;
    private static final int HARD_ENTITY_LIMIT = ConfigHandler.hardEntityLimit;
    private Map<ChunkCoordIntPair, Boolean> eligibleChunksForSpawning = new HashMap<ChunkCoordIntPair, Boolean>();
    private TObjectIntHashMap<Class<? extends Entity>> entityCounts = new TObjectIntHashMap();

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            WorldServer world = DimensionManager.getWorld((int)ConfigHandler.DIMENSION_ID);
            if (world == null || world.field_73010_i.isEmpty()) {
                return;
            }
            if (world.func_82736_K().func_82766_b("doMobSpawning") && world.func_72820_D() % 2L == 0L) {
                this.populateWorld((World)world);
            }
        }
    }

    @SubscribeEvent
    public void onChunkPopulate(PopulateChunkEvent.Post event) {
        World world = event.world;
        if (world == null || world.field_73011_w.field_76574_g != ConfigHandler.DIMENSION_ID) {
            return;
        }
        if (world.func_82736_K().func_82766_b("doMobSpawning")) {
            boolean spawnHostiles = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnHostiles();
            boolean spawnAnimals = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnAnimals();
            int spawnedEntities = 0;
            for (int i = 0; i < 64; ++i) {
                spawnedEntities += this.populateChunk(world, new ChunkCoordIntPair(event.chunkX, event.chunkZ), spawnHostiles, spawnAnimals, false, true, 8, 60, 32, HARD_ENTITY_LIMIT, 1.0f);
            }
        }
    }

    private void populateWorld(World world) {
        if (!(world.field_73011_w instanceof WorldProviderBetweenlands)) {
            return;
        }
        int totalWorldEntityCount = 0;
        for (Object entity : world.field_72996_f) {
            if (!(entity instanceof EntityLivingBase)) continue;
            ++totalWorldEntityCount;
        }
        if (totalWorldEntityCount >= HARD_ENTITY_LIMIT) {
            return;
        }
        this.updateSpawnerChunks(world);
        if (this.eligibleChunksForSpawning.size() == 0) {
            return;
        }
        ArrayList spawnerChunks = new ArrayList(this.eligibleChunksForSpawning.keySet().size() / 16 * 3 * 4);
        for (Map.Entry entry : this.eligibleChunksForSpawning.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            spawnerChunks.add(entry.getKey());
        }
        this.updateEntityCounts(world);
        int totalEligibleEntityCount = 0;
        for (int count : this.entityCounts.values()) {
            totalEligibleEntityCount += count;
        }
        int n = Math.min(HARD_ENTITY_LIMIT, (int)((float)spawnerChunks.size() * MAX_ENTITIES_PER_CHUNK_MULTIPLIER));
        if (totalEligibleEntityCount >= n) {
            return;
        }
        Collections.shuffle(spawnerChunks);
        boolean spawnHostiles = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnHostiles();
        boolean spawnAnimals = ((WorldProviderBetweenlands)world.field_73011_w).getCanSpawnAnimals();
        float areaMultiplier = (float)spawnerChunks.size() / 32.0f;
        for (ChunkCoordIntPair chunkPos : spawnerChunks) {
            this.populateChunk(world, chunkPos, spawnHostiles, spawnAnimals, true, false, 8, 6, 32, n, areaMultiplier);
        }
    }

    private int populateChunk(World world, ChunkCoordIntPair chunkPos, boolean spawnHostiles, boolean spawnAnimals, boolean loadChunks, boolean ignoreTimers, int attemptsPerChunk, int maxSpawnsPerChunk, int attemptsPerGroup, int entityLimit, float areaMultiplier) {
        int attempts = 0;
        int chunkSpawnedEntities = 0;
        block0: while (attempts++ < attemptsPerChunk && chunkSpawnedEntities < maxSpawnsPerChunk) {
            BLSpawnEntry spawnEntry2;
            Block centerSpawnBlock;
            ChunkPosition spawnPos = this.getRandomSpawnPosition(world, chunkPos);
            BiomeGenBase biome = world.func_72807_a(spawnPos.field_151329_a, spawnPos.field_151328_c);
            if (world.field_73012_v.nextFloat() > biome.func_76741_f() || !(biome instanceof BiomeGenBaseBetweenlands) || (centerSpawnBlock = world.func_147439_a(spawnPos.field_151329_a, spawnPos.field_151327_b, spawnPos.field_151328_c)).func_149721_r()) continue;
            int totalBaseWeight = 0;
            int totalWeight = 0;
            List<BLSpawnEntry> biomeSpawns = ((BiomeGenBaseBetweenlands)biome).getSpawnEntries();
            ArrayList<BLSpawnEntry> possibleSpawns = new ArrayList<BLSpawnEntry>();
            for (BLSpawnEntry spawnEntry2 : biomeSpawns) {
                if (spawnEntry2.isHostile() && !spawnHostiles || !spawnEntry2.isHostile() && !spawnAnimals) continue;
                totalBaseWeight += spawnEntry2.getBaseWeight();
                possibleSpawns.add(spawnEntry2);
                spawnEntry2.update(world, spawnPos.field_151329_a, spawnPos.field_151327_b, spawnPos.field_151328_c);
                totalWeight += spawnEntry2.getWeight();
            }
            if (possibleSpawns.isEmpty()) continue;
            WeightedList weightedPossibleSpawns = new WeightedList();
            weightedPossibleSpawns.addAll(possibleSpawns);
            weightedPossibleSpawns.recalculateWeight();
            spawnEntry2 = (BLSpawnEntry)weightedPossibleSpawns.getRandomItem(world.field_73012_v);
            if (spawnEntry2 == null) continue;
            int dynamicLimitBase = (int)((double)entityLimit / (double)totalBaseWeight * (double)spawnEntry2.getBaseWeight());
            int dynamicLimit = (int)((double)entityLimit / (double)totalWeight * (double)spawnEntry2.getWeight());
            int spawnEntityCount = this.entityCounts.get((Object)spawnEntry2.entityType);
            if (spawnEntityCount >= Math.max(dynamicLimit, dynamicLimitBase) || spawnEntry2.getWorldLimit() >= 0 && spawnEntityCount >= spawnEntry2.getWorldLimit()) continue;
            int desiredGroupSize = spawnEntry2.getMinGroupSize() + world.field_73012_v.nextInt(spawnEntry2.getMaxGroupSize() - spawnEntry2.getMinGroupSize() + 1);
            double groupCheckRadius = spawnEntry2.spawnCheckRadius;
            int csx = MathHelper.func_76128_c((double)(((double)spawnPos.field_151329_a - groupCheckRadius) / 16.0));
            int cex = MathHelper.func_76128_c((double)(((double)spawnPos.field_151329_a + groupCheckRadius) / 16.0));
            int csz = MathHelper.func_76128_c((double)(((double)spawnPos.field_151328_c - groupCheckRadius) / 16.0));
            int cez = MathHelper.func_76128_c((double)(((double)spawnPos.field_151328_c + groupCheckRadius) / 16.0));
            for (int cx = csx; cx <= cex; ++cx) {
                for (int cz = csz; cz <= cez; ++cz) {
                    if (!world.func_72863_F().func_73149_a(cx, cz)) continue block0;
                }
            }
            double groupSpawnRadius = spawnEntry2.groupSpawnRadius;
            Class entityType = spawnEntry2.entityType;
            boolean checkExistingGroups = spawnEntry2.shouldCheckExistingGroups();
            if (checkExistingGroups) {
                List foundGroupEntities = world.func_72872_a(entityType, AxisAlignedBB.func_72330_a((double)((double)spawnPos.field_151329_a - groupCheckRadius), (double)(spawnPos.field_151327_b - 6), (double)((double)spawnPos.field_151328_c - groupCheckRadius), (double)((double)spawnPos.field_151329_a + groupCheckRadius), (double)(spawnPos.field_151327_b + 6), (double)((double)spawnPos.field_151328_c + groupCheckRadius)));
                Iterator foundGroupEntitiesIT = foundGroupEntities.iterator();
                while (foundGroupEntitiesIT.hasNext()) {
                    Entity foundEntity = (Entity)foundGroupEntitiesIT.next();
                    if (!(foundEntity.func_70011_f((double)spawnPos.field_151329_a, foundEntity.field_70163_u, (double)spawnPos.field_151328_c) > groupCheckRadius)) continue;
                    foundGroupEntitiesIT.remove();
                }
                desiredGroupSize -= foundGroupEntities.size();
            }
            if (desiredGroupSize <= 0) continue;
            int groupSpawnedEntities = 0;
            int groupSpawnAttempts = 0;
            int maxGroupSpawnAttempts = attemptsPerGroup + desiredGroupSize * 2;
            if (!ignoreTimers) {
                if (spawnEntry2.lastSpawn == -1L) {
                    spawnEntry2.lastSpawn = world.func_82737_E();
                    continue;
                }
                int adjustedInterval = (int)((float)spawnEntry2.spawningInterval / areaMultiplier);
                if (world.func_82737_E() - spawnEntry2.lastSpawn < (long)adjustedInterval) continue;
            }
            while (groupSpawnAttempts++ < maxGroupSpawnAttempts && groupSpawnedEntities < desiredGroupSize) {
                Block surfaceBlock;
                Block spawnBlock;
                boolean inChunk;
                ChunkPosition entitySpawnPos = this.getRandomSpawnPosition(world, spawnPos, MathHelper.func_76128_c((double)groupSpawnRadius));
                boolean bl = inChunk = entitySpawnPos.field_151329_a >> 4 == chunkPos.field_77276_a && entitySpawnPos.field_151328_c >> 4 == chunkPos.field_77275_b;
                if (!loadChunks && !inChunk || world.func_72977_a((double)entitySpawnPos.field_151329_a, (double)entitySpawnPos.field_151327_b, (double)entitySpawnPos.field_151328_c, 24.0) != null || (spawnBlock = world.func_147439_a(entitySpawnPos.field_151329_a, entitySpawnPos.field_151327_b, entitySpawnPos.field_151328_c)).func_149721_r()) continue;
                int spawnSegmentY = entitySpawnPos.field_151327_b / 16;
                Chunk spawnChunk = world.func_72938_d(entitySpawnPos.field_151329_a, entitySpawnPos.field_151328_c);
                List[] entityLists = spawnChunk.field_76645_j;
                int chunkEntityCount = 0;
                boolean nextGroupAttempt = false;
                for (int l = 0; l < entityLists.length; ++l) {
                    int subChunkEntityCount = 0;
                    for (Entity entity : entityLists[l]) {
                        if (entity.getClass() != spawnEntry2.entityType) continue;
                        ++subChunkEntityCount;
                        ++chunkEntityCount;
                    }
                    if (l == spawnSegmentY && spawnEntry2.getSubChunkLimit() >= 0 && subChunkEntityCount < spawnEntry2.getSubChunkLimit()) continue;
                }
                if (spawnEntry2.getChunkLimit() >= 0 && chunkEntityCount >= spawnEntry2.getChunkLimit() || !spawnEntry2.canSpawn(world, spawnChunk, entitySpawnPos.field_151329_a, entitySpawnPos.field_151327_b, entitySpawnPos.field_151328_c, spawnBlock, surfaceBlock = spawnChunk.func_150810_a(entitySpawnPos.field_151329_a - spawnChunk.field_76635_g * 16, entitySpawnPos.field_151327_b - 1, entitySpawnPos.field_151328_c - spawnChunk.field_76647_h * 16))) continue;
                double sx = (double)entitySpawnPos.field_151329_a + 0.5;
                double sy = entitySpawnPos.field_151327_b;
                double sz = (double)entitySpawnPos.field_151328_c + 0.5;
                float yaw = world.field_73012_v.nextFloat() * 360.0f;
                EntityLiving newEntity = spawnEntry2.createEntity(world);
                if (newEntity == null) continue;
                newEntity.func_70012_b(sx, sy, sz, yaw, 0.0f);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)newEntity, (World)world, (float)((float)sx), (float)((float)sy), (float)((float)sz));
                if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !newEntity.func_70601_bi())) continue;
                ++groupSpawnedEntities;
                ++chunkSpawnedEntities;
                NBTTagCompound entityNBT = newEntity.getEntityData();
                entityNBT.func_74757_a("naturallySpawned", true);
                world.func_72838_d((Entity)newEntity);
                if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)newEntity, (World)world, (float)((float)sx), (float)((float)sy), (float)((float)sz))) {
                    newEntity.func_110161_a(null);
                }
                if (groupSpawnedEntities < ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)newEntity)) continue;
                break;
            }
            if (ignoreTimers || groupSpawnedEntities <= 0) continue;
            spawnEntry2.lastSpawn = world.func_82737_E();
        }
        return chunkSpawnedEntities;
    }

    private ChunkPosition getRandomSpawnPosition(World world, ChunkCoordIntPair chunkPos) {
        Chunk chunk = world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
        int x = chunkPos.field_77276_a * 16 + world.field_73012_v.nextInt(16);
        int z = chunkPos.field_77275_b * 16 + world.field_73012_v.nextInt(16);
        int y = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1);
        return new ChunkPosition(x, y, z);
    }

    private ChunkPosition getRandomSpawnPosition(World world, ChunkPosition centerPos, int radius) {
        return new ChunkPosition(centerPos.field_151329_a + world.field_73012_v.nextInt(radius * 2) - radius, MathHelper.func_76125_a((int)(centerPos.field_151327_b + world.field_73012_v.nextInt(4) - 2), (int)1, (int)world.func_72800_K()), centerPos.field_151328_c + world.field_73012_v.nextInt(radius * 2) - radius);
    }

    private void updateSpawnerChunks(World world) {
        this.eligibleChunksForSpawning.clear();
        for (EntityPlayer player : world.field_73010_i) {
            int pcx = player.field_70176_ah;
            int pcz = player.field_70164_aj;
            for (int cox = -4; cox <= 4; ++cox) {
                for (int coz = -4; coz <= 4; ++coz) {
                    boolean isOuterChunk;
                    int cx = pcx + cox;
                    int cz = pcz + coz;
                    ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(cx, cz);
                    boolean bl = isOuterChunk = Math.abs(cox - 4) < 2 || Math.abs(coz - 4) < 2;
                    if (isOuterChunk) {
                        if (this.eligibleChunksForSpawning.containsKey(chunkPos)) continue;
                        this.eligibleChunksForSpawning.put(chunkPos, true);
                        continue;
                    }
                    this.eligibleChunksForSpawning.put(chunkPos, false);
                }
            }
        }
    }

    private void updateEntityCounts(World world) {
        this.entityCounts.clear();
        for (Map.Entry<ChunkCoordIntPair, Boolean> eligibleChunk : this.eligibleChunksForSpawning.entrySet()) {
            List[] entityLists;
            ChunkCoordIntPair chunkPos = eligibleChunk.getKey();
            if (!world.func_72863_F().func_73149_a(chunkPos.field_77276_a, chunkPos.field_77275_b)) continue;
            Chunk chunk = world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
            for (List entityList : entityLists = chunk.field_76645_j) {
                for (Entity entity : entityList) {
                    if (!(entity instanceof EntityLivingBase)) continue;
                    this.entityCounts.adjustOrPutValue(entity.getClass(), 1, 1);
                }
            }
        }
    }

    public static class BLSpawnEntry
    implements IWeightProvider {
        private final Class<? extends EntityLiving> entityType;
        private final Constructor<? extends EntityLiving> entityCtor;
        private final short baseWeight;
        private short weight;
        private boolean hostile = false;
        private int subChunkLimit = -1;
        private int chunkLimit = -1;
        private int worldLimit = -1;
        private int minGroupSize = 1;
        private int maxGroupSize = 1;
        private double spawnCheckRadius = 16.0;
        private double groupSpawnRadius = 6.0;
        private int spawningInterval = 0;
        private long lastSpawn = -1L;

        public BLSpawnEntry(Class<? extends EntityLiving> entityType) {
            this(entityType, 100);
        }

        public BLSpawnEntry(Class<? extends EntityLiving> entityType, short weight) {
            this.entityType = entityType;
            try {
                this.entityCtor = this.entityType.getConstructor(World.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException("Can't find or access entity constructor (World) of entity: " + entityType.getName());
            }
            this.weight = weight;
            this.baseWeight = weight;
        }

        protected boolean canSpawn(World world, Chunk chunk, int x, int y, int z, Block block, Block surfaceBlock) {
            return surfaceBlock.func_149721_r();
        }

        protected void update(World world, int x, int y, int z) {
        }

        @Override
        public final short getWeight() {
            return this.weight;
        }

        protected final BLSpawnEntry setWeight(short weight) {
            this.weight = weight;
            return this;
        }

        public final BLSpawnEntry setSpawningInterval(int interval) {
            this.spawningInterval = interval;
            return this;
        }

        public final int getSpawningInterval() {
            return this.spawningInterval;
        }

        public final short getBaseWeight() {
            return this.baseWeight;
        }

        public final BLSpawnEntry setGroupSize(int min, int max) {
            if (max < min) {
                throw new RuntimeException("Maximum group size cannot be smaller than minimum group size!");
            }
            this.minGroupSize = min;
            this.maxGroupSize = max;
            return this;
        }

        public final int getMaxGroupSize() {
            return this.maxGroupSize;
        }

        public final int getMinGroupSize() {
            return this.minGroupSize;
        }

        public final int getChunkLimit() {
            return this.chunkLimit;
        }

        public final BLSpawnEntry setChunkLimit(int limit) {
            this.chunkLimit = limit;
            return this;
        }

        public final int getWorldLimit() {
            return this.worldLimit;
        }

        public final BLSpawnEntry setWorldLimit(int limit) {
            this.worldLimit = limit;
            return this;
        }

        public final int getSubChunkLimit() {
            return this.subChunkLimit;
        }

        public final BLSpawnEntry setSubChunkLimit(int limit) {
            this.subChunkLimit = limit;
            return this;
        }

        public final BLSpawnEntry setHostile(boolean hostile) {
            this.hostile = hostile;
            return this;
        }

        public final boolean isHostile() {
            return this.hostile;
        }

        public final BLSpawnEntry setSpawnCheckRadius(double radius) {
            this.spawnCheckRadius = radius;
            return this;
        }

        public final double getSpawnCheckRadius() {
            return this.spawnCheckRadius;
        }

        public final BLSpawnEntry setGroupSpawnRadius(double radius) {
            this.groupSpawnRadius = radius;
            return this;
        }

        public final double getGroupSpawnRadius() {
            return this.groupSpawnRadius;
        }

        protected boolean shouldCheckExistingGroups() {
            return true;
        }

        protected EntityLiving createEntity(World world) {
            try {
                return this.entityCtor.newInstance(world);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

