/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.biomes.decorators.data.SurfaceType;

public class WorldGenFluidPool
extends WorldGenerator {
    private Block[] blackListBlocks = new Block[]{BLBlockRegistry.betweenstoneTiles, BLBlockRegistry.betweenstoneBrickStairs, BLBlockRegistry.betweenstoneBricks, BLBlockRegistry.betweenstoneBrickSlab};
    private Block fillerFluid = BLBlockRegistry.tarFluid;
    private double size;
    private int minHeight = 6;
    private boolean destroyBlocks = false;

    public void prepare(double size) {
        this.size = size;
    }

    public boolean generatePool(World world, Random rand, int x, int y, int z, Block fluid, boolean destroyBlocks) {
        this.fillerFluid = fluid;
        this.destroyBlocks = destroyBlocks;
        return this.func_76484_a(world, rand, x, y, z);
    }

    public boolean generatePool(World world, Random rand, int x, int y, int z, Block fluid, int minHeight) {
        this.fillerFluid = fluid;
        this.minHeight = minHeight;
        return this.func_76484_a(world, rand, x, y, z);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int zz;
        int xx;
        int yy;
        x -= 8;
        z -= 8;
        while (world.func_147437_c(x, y, z) && y > this.minHeight) {
            --y;
        }
        if (y <= this.minHeight || world.func_147437_c(x, y, z) && !this.destroyBlocks) {
            return false;
        }
        y -= 4;
        for (int xx2 = x; xx2 < x + 16; ++xx2) {
            for (int zz2 = z; zz2 < z + 16; ++zz2) {
                for (yy = y; yy < y + 8; ++yy) {
                    if (!this.isBlacklistedBlock(world.func_147439_a(xx2, yy, zz2))) continue;
                    return false;
                }
            }
        }
        boolean[] placeFluid = new boolean[2048];
        int iterAmount = rand.nextInt(3) + 5;
        for (int iteration = 0; iteration < iterAmount; ++iteration) {
            double d0 = (rand.nextDouble() * 6.0 + 3.0) * this.size * (0.4 + rand.nextDouble() * 0.6);
            double d1 = (rand.nextDouble() * 4.0 + 2.0) * this.size / 2.5;
            double d2 = (rand.nextDouble() * 6.0 + 3.0) * this.size * (0.4 + rand.nextDouble() * 0.6);
            double d3 = rand.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = rand.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = rand.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (xx = 1; xx < 15; ++xx) {
                for (int zz3 = 1; zz3 < 15; ++zz3) {
                    for (int yy2 = 1; yy2 < 7; ++yy2) {
                        double d6 = ((double)xx - d3) / (d0 / 2.0);
                        double d7 = ((double)yy2 - d4) / (d1 / 2.0);
                        double d8 = ((double)zz3 - d5) / (d2 / 2.0);
                        double dist = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(dist < 1.0)) continue;
                        placeFluid[(xx * 16 + zz3) * 8 + yy2] = true;
                    }
                }
            }
        }
        for (xx = 0; xx < 16; ++xx) {
            for (zz = 0; zz < 16; ++zz) {
                for (yy = 0; yy < 8; ++yy) {
                    boolean flag;
                    boolean bl = flag = !placeFluid[(xx * 16 + zz) * 8 + yy] && (xx < 15 && placeFluid[((xx + 1) * 16 + zz) * 8 + yy] || xx > 0 && placeFluid[((xx - 1) * 16 + zz) * 8 + yy] || zz < 15 && placeFluid[(xx * 16 + zz + 1) * 8 + yy] || zz > 0 && placeFluid[(xx * 16 + zz - 1) * 8 + yy] || yy < 7 && placeFluid[(xx * 16 + zz) * 8 + yy + 1] || yy > 0 && placeFluid[(xx * 16 + zz) * 8 + yy - 1]);
                    if (!flag) continue;
                    Material material = world.func_147439_a(x + xx, y + yy, z + zz).func_149688_o();
                    if (yy >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (yy >= 4 || material.func_76220_a() || world.func_147439_a(x + xx, y + yy, z + zz) == this.fillerFluid) continue;
                    return false;
                }
            }
        }
        for (xx = 0; xx < 16; ++xx) {
            for (zz = 0; zz < 16; ++zz) {
                for (yy = 0; yy < 8; ++yy) {
                    if (!placeFluid[(xx * 16 + zz) * 8 + yy]) continue;
                    world.func_147465_d(x + xx, y + yy, z + zz, yy >= 4 ? Blocks.field_150350_a : this.fillerFluid, 0, 2);
                }
            }
        }
        return true;
    }

    private final boolean checkSurface(World world, SurfaceType surfaceType, int x, int y, int z) {
        return surfaceType.matchBlock(world.func_147439_a(x, y, z));
    }

    private boolean isBlacklistedBlock(Block block) {
        for (Block blacklistBlock : this.blackListBlocks) {
            if (!block.equals(blacklistBlock)) continue;
            return true;
        }
        return false;
    }
}

