/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.feature.base.BiomeNoiseFeature;

public class SludgePlainsNoiseFeature
extends BiomeNoiseFeature {
    private NoiseGeneratorPerlin noiseGen;
    private double[] noise = new double[256];

    @Override
    public void initializeNoiseGen(Random rng, BiomeGenBaseBetweenlands biome) {
        this.noiseGen = new NoiseGeneratorPerlin(rng, 4);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, BiomeGenBaseBetweenlands biome) {
        this.noise = this.noiseGen.func_151599_a(this.noise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.16, 0.16, 1.0);
    }

    @Override
    public void postReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
    }

    @Override
    public void preReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
        int y;
        int sliceSize = chunkBlocks.length / 256;
        int layerHeight = 80;
        int lowestBlock = 0;
        for (int yOff = 0; yOff < layerHeight; ++yOff) {
            y = layerHeight - yOff;
            Block currentBlock = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y, z, sliceSize)];
            if (currentBlock == provider.layerBlock) continue;
            lowestBlock = y;
            break;
        }
        int depth = (int)((double)(layerHeight - lowestBlock) / 6.5);
        for (y = lowestBlock; y < layerHeight - depth; ++y) {
            chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = provider.baseBlock;
        }
        double noise = this.noise[x * 16 + z] / 8.0;
        int height = (int)((double)((float)layerHeight - (float)(layerHeight - lowestBlock) / 2.5f) + noise * (double)(layerHeight - lowestBlock) + 3.0);
        for (int y2 = layerHeight - depth; y2 < height; ++y2) {
            chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y2, (int)z, (int)sliceSize)] = provider.baseBlock;
        }
    }
}

