/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.feature.base.BiomeNoiseFeature;

public class SiltNoiseFeature
extends BiomeNoiseFeature {
    private NoiseGeneratorPerlin siltNoiseGen;
    private double[] siltNoise = new double[256];

    @Override
    public void initializeNoiseGen(Random rng, BiomeGenBaseBetweenlands biome) {
        this.siltNoiseGen = new NoiseGeneratorPerlin(rng, 4);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, BiomeGenBaseBetweenlands biome) {
        this.siltNoise = this.siltNoiseGen.func_151599_a(this.siltNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.0625, 0.0625, 1.0);
    }

    @Override
    public void postReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
        int sliceSize = chunkBlocks.length / 256;
        if (this.siltNoise[x * 16 + z] / (double)1.6f + 1.5 <= 0.0) {
            int y = 80;
            Block currentBlock = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y, z, sliceSize)];
            Block blockAbove = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y + 1, z, sliceSize)];
            if (currentBlock == biome.field_76752_A && (blockAbove == null || blockAbove == Blocks.field_150350_a)) {
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = BLBlockRegistry.silt;
            }
        }
    }

    @Override
    public void preReplaceStackBlocks(int x, int y, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
    }
}

