/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.feature.base.BiomeNoiseFeature;

public class Marsh1NoiseFeature
extends BiomeNoiseFeature {
    private NoiseGeneratorPerlin islandNoiseGen;
    private double[] islandNoise = new double[256];
    private NoiseGeneratorPerlin fuzzNoiseGen;
    private double[] fuzzNoise = new double[256];

    @Override
    public void initializeNoiseGen(Random rng, BiomeGenBaseBetweenlands biome) {
        this.islandNoiseGen = new NoiseGeneratorPerlin(rng, 4);
        this.fuzzNoiseGen = new NoiseGeneratorPerlin(rng, 8);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, BiomeGenBaseBetweenlands biome) {
        this.islandNoise = this.islandNoiseGen.func_151599_a(this.islandNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.16, 0.16, 1.0);
        this.fuzzNoise = this.fuzzNoiseGen.func_151599_a(this.fuzzNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 10.5, 10.5, 1.0);
    }

    @Override
    public void postReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
    }

    @Override
    public void preReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
        int sliceSize = chunkBlocks.length / 256;
        double noise = this.islandNoise[x * 16 + z] / (double)1.4f + this.fuzzNoise[x * 16 + z] / (double)1.4f + (double)1.8f;
        int layerHeight = 80;
        if (noise <= 0.0 && chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, layerHeight, z, sliceSize)] == provider.layerBlock) {
            int y;
            int waterHeight = 2;
            int heightVariation = 5;
            int yOff = 0;
            while (yOff < layerHeight) {
                y = layerHeight - yOff;
                waterHeight = yOff++;
                Block currentBlock = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y, z, sliceSize)];
                if (currentBlock != provider.layerBlock) break;
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = provider.baseBlock;
            }
            for (yOff = waterHeight; yOff > 0; --yOff) {
                y = layerHeight - yOff;
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = provider.baseBlock;
            }
        } else {
            int lowestBlock = 0;
            for (int yOff = 0; yOff < layerHeight; ++yOff) {
                int y = layerHeight - yOff;
                Block currentBlock = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y, z, sliceSize)];
                if (currentBlock == provider.layerBlock) continue;
                lowestBlock = y;
                break;
            }
            int y = lowestBlock;
            while ((float)y < (float)layerHeight - (float)(layerHeight - lowestBlock) / 7.5f) {
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = provider.baseBlock;
                ++y;
            }
        }
    }
}

