/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.feature.base.BiomeNoiseFeature;

public class FlatLandNoiseFeature
extends BiomeNoiseFeature {
    private NoiseGeneratorPerlin landNoiseGen;
    private double[] landNoise = new double[256];
    private NoiseGeneratorPerlin riverNoiseGen;
    private double[] riverNoise = new double[256];

    @Override
    public void initializeNoiseGen(Random rng, BiomeGenBaseBetweenlands biome) {
        this.landNoiseGen = new NoiseGeneratorPerlin(rng, 4);
        this.riverNoiseGen = new NoiseGeneratorPerlin(rng, 2);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, BiomeGenBaseBetweenlands biome) {
        this.landNoise = this.landNoiseGen.func_151599_a(this.landNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.06, 0.06, 1.0);
        this.riverNoise = this.riverNoiseGen.func_151599_a(this.riverNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.032, 0.032, 1.0);
    }

    @Override
    public void postReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
    }

    @Override
    public void preReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
        int sliceSize = chunkBlocks.length / 256;
        int layerHeight = 80;
        int lowestBlock = 0;
        for (int yOff = 0; yOff < layerHeight; ++yOff) {
            int y = layerHeight - yOff;
            Block currentBlock = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y, z, sliceSize)];
            if (currentBlock == provider.layerBlock) continue;
            lowestBlock = y;
            break;
        }
        double noise = this.landNoise[x * 16 + z] / 18.0;
        double riverNoise = Math.abs(this.riverNoise[x * 16 + z]) * 4.0;
        riverNoise *= riverNoise * riverNoise * riverNoise * riverNoise;
        int terrainHeight = (int)Math.ceil(Math.abs(noise * (double)(layerHeight - lowestBlock)));
        float riverThreshold = 6.0f * (float)(terrainHeight + 2);
        double riverPercentage = 1.0 - (riverNoise *= 25.0) / (double)riverThreshold;
        if (riverNoise < (double)riverThreshold) {
            int y = lowestBlock;
            while ((double)y < (double)(layerHeight + terrainHeight) - riverPercentage * ((double)terrainHeight + ((double)riverThreshold - riverNoise) / 16.0)) {
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = provider.baseBlock;
                ++y;
            }
        } else {
            for (int y = lowestBlock; y < layerHeight + terrainHeight; ++y) {
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = provider.baseBlock;
            }
        }
    }
}

