/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.feature.base.BiomeNoiseFeature;

public class DeepWaterNoiseFeature
extends BiomeNoiseFeature {
    private NoiseGeneratorPerlin islandNoiseGen;
    private double[] islandNoise = new double[256];

    @Override
    public void initializeNoiseGen(Random rng, BiomeGenBaseBetweenlands biome) {
        this.islandNoiseGen = new NoiseGeneratorPerlin(rng, 4);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, BiomeGenBaseBetweenlands biome) {
        this.islandNoise = this.islandNoiseGen.func_151599_a(this.islandNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.05, 0.05, 1.0);
    }

    @Override
    public void postReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
    }

    @Override
    public void preReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
        int sliceSize = chunkBlocks.length / 256;
        int layerHeight = 80;
        int lowestBlock = 0;
        for (int yOff = 0; yOff < layerHeight; ++yOff) {
            int y = layerHeight - yOff;
            Block currentBlock = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y, z, sliceSize)];
            if (currentBlock == provider.layerBlock) continue;
            lowestBlock = y;
            break;
        }
        double noise = this.islandNoise[x * 16 + z] / 12.0;
        int y = lowestBlock;
        while ((double)y < (double)((float)layerHeight - (float)(layerHeight - lowestBlock) / 2.5f) + noise * (double)(layerHeight - lowestBlock) - 2.0) {
            chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = provider.baseBlock;
            ++y;
        }
    }
}

