/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.feature.base.BiomeNoiseFeature;

public class CragSpiresNoiseFeature
extends BiomeNoiseFeature {
    private NoiseGeneratorPerlin spireNoiseGen;
    private double[] spireNoise = new double[256];

    @Override
    public void initializeNoiseGen(Random rng, BiomeGenBaseBetweenlands biome) {
        this.spireNoiseGen = new NoiseGeneratorPerlin(rng, 4);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, BiomeGenBaseBetweenlands biome) {
        this.spireNoise = this.spireNoiseGen.func_151599_a(this.spireNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.16, 0.16, 1.0);
    }

    @Override
    public void postReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
    }

    @Override
    public void preReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
        block9: {
            int layerHeight;
            double noise;
            block8: {
                int sliceSize = chunkBlocks.length / 256;
                noise = this.spireNoise[x * 16 + z] / 1.5 + (double)2.4f;
                layerHeight = 80;
                if (chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, layerHeight, z, sliceSize)] != provider.layerBlock) {
                    return;
                }
                int lowestBlock = 0;
                for (int yOff = 0; yOff < layerHeight; ++yOff) {
                    int y = layerHeight - yOff;
                    Block currentBlock = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y, z, sliceSize)];
                    if (currentBlock == provider.layerBlock) continue;
                    lowestBlock = y;
                    break;
                }
                if (80 - lowestBlock < 3) {
                    return;
                }
                if (!(-noise * 12.0 >= 1.0)) break block8;
                for (int y = lowestBlock; y < layerHeight; ++y) {
                    chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = BLBlockRegistry.genericStone;
                    chunkMeta[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = 1;
                }
                int rockHeight = (int)Math.floor(-noise * 12.0);
                for (int yOff = 0; yOff < rockHeight; ++yOff) {
                    int y = layerHeight + yOff;
                    chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = BLBlockRegistry.genericStone;
                    chunkMeta[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = yOff == rockHeight - 2 ? 3 : (yOff == rockHeight - 1 ? 2 : 1);
                }
                break block9;
            }
            boolean validSpire = false;
            block3: for (int xo = -4; xo < 4; ++xo) {
                for (int zo = -4; zo < 4; ++zo) {
                    int nx = x + xo;
                    int nz = z + zo;
                    int n = nx < 0 ? 0 : (nx = nx > 15 ? 15 : nx);
                    double sNoise = this.spireNoise[nx * 16 + (nz = nz < 0 ? 0 : (nz > 15 ? 15 : nz))] / 1.5 + (double)2.4f;
                    if (!(-sNoise * 12.0 >= 1.0)) continue;
                    validSpire = true;
                    continue block3;
                }
            }
            if (!validSpire) break block9;
            int rockHeight = (int)Math.floor(-noise * 12.0);
            for (int y = lowestBlock; y < layerHeight + rockHeight; ++y) {
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = BLBlockRegistry.genericStone;
                chunkMeta[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = 1;
            }
        }
    }
}

