/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.feature.base.BiomeNoiseFeature;

public class CoarseIslandNoiseFeature
extends BiomeNoiseFeature {
    private NoiseGeneratorPerlin islandNoiseGen;
    private double[] islandNoise = new double[256];
    private NoiseGeneratorPerlin cragNoiseGen;
    private double[] cragNoise = new double[256];

    @Override
    public void initializeNoiseGen(Random rng, BiomeGenBaseBetweenlands biome) {
        this.islandNoiseGen = new NoiseGeneratorPerlin(rng, 4);
        this.cragNoiseGen = new NoiseGeneratorPerlin(rng, 5);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, BiomeGenBaseBetweenlands biome) {
        this.islandNoise = this.islandNoiseGen.func_151599_a(this.islandNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.136, 0.136, 1.0);
        this.cragNoise = this.cragNoiseGen.func_151599_a(this.cragNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.45, 0.45, 1.0);
    }

    @Override
    public void postReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
    }

    @Override
    public void preReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
        int sliceSize = chunkBlocks.length / 256;
        double noise = this.islandNoise[x * 16 + z] / (double)0.9f + (double)2.1f;
        double cragNoise = this.cragNoise[x * 16 + z] / (double)2.1f + 2.0;
        boolean isCrag = cragNoise <= 0.0;
        int layerHeight = 80;
        if (noise <= 0.0 && chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, layerHeight, z, sliceSize)] == provider.layerBlock) {
            int yOff;
            int y;
            Block currentBlock;
            int minHeight = 2;
            int heightVariation = 5;
            for (int yOff2 = 0; yOff2 < layerHeight && (currentBlock = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y = layerHeight - yOff2, z, sliceSize)]) == provider.layerBlock; ++yOff2) {
                if (isCrag) {
                    chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = BLBlockRegistry.genericStone;
                    chunkMeta[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = 1;
                    continue;
                }
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = provider.baseBlock;
            }
            int maxHeight = (int)Math.ceil(-noise / 4.0 * (double)heightVariation);
            for (yOff = 0; yOff < maxHeight; ++yOff) {
                int y2 = minHeight + layerHeight + yOff;
                if (isCrag) {
                    chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y2, (int)z, (int)sliceSize)] = BLBlockRegistry.genericStone;
                    if (yOff == maxHeight - 2) {
                        chunkMeta[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y2, (int)z, (int)sliceSize)] = 3;
                        continue;
                    }
                    if (yOff == maxHeight - 1) {
                        chunkMeta[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y2, (int)z, (int)sliceSize)] = 2;
                        continue;
                    }
                    chunkMeta[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y2, (int)z, (int)sliceSize)] = 1;
                    continue;
                }
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y2, (int)z, (int)sliceSize)] = provider.baseBlock;
            }
            for (yOff = 0; yOff < minHeight; ++yOff) {
                int y3 = layerHeight + yOff;
                if (isCrag) {
                    chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y3, (int)z, (int)sliceSize)] = BLBlockRegistry.genericStone;
                    if (yOff == minHeight - 1 && maxHeight >= 1) {
                        chunkMeta[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y3, (int)z, (int)sliceSize)] = 3;
                        continue;
                    }
                    chunkMeta[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y3, (int)z, (int)sliceSize)] = 1;
                    continue;
                }
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y3, (int)z, (int)sliceSize)] = provider.baseBlock;
            }
        } else {
            int lowestBlock = 0;
            for (int yOff = 0; yOff < layerHeight; ++yOff) {
                int y = layerHeight - yOff;
                Block currentBlock = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y, z, sliceSize)];
                if (currentBlock == provider.layerBlock) continue;
                lowestBlock = y;
                break;
            }
            int y = lowestBlock;
            while ((float)y < (float)layerHeight - (float)(layerHeight - lowestBlock) / 7.5f) {
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)y, (int)z, (int)sliceSize)] = provider.baseBlock;
                ++y;
            }
        }
    }
}

