/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.feature.base.BiomeNoiseFeature;

public class AlgaeNoiseFeature
extends BiomeNoiseFeature {
    private NoiseGeneratorPerlin algaeNoiseGen;
    private double[] algaeNoise = new double[256];

    @Override
    public void initializeNoiseGen(Random rng, BiomeGenBaseBetweenlands biome) {
        this.algaeNoiseGen = new NoiseGeneratorPerlin(rng, 4);
    }

    @Override
    public void generateNoise(int chunkX, int chunkZ, BiomeGenBaseBetweenlands biome) {
        this.algaeNoise = this.algaeNoiseGen.func_151599_a(this.algaeNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.16, 0.16, 1.0);
    }

    @Override
    public void postReplaceStackBlocks(int x, int z, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
        int sliceSize = chunkBlocks.length / 256;
        if (this.algaeNoise[x * 16 + z] / (double)1.6f + (double)1.8f <= 0.0) {
            int y = 80;
            Block currentBlock = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y, z, sliceSize)];
            Block blockAbove = chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex(x, y + 1, z, sliceSize)];
            if (currentBlock == provider.layerBlock && (blockAbove == null || blockAbove == Blocks.field_150350_a)) {
                chunkBlocks[BiomeGenBaseBetweenlands.getBlockArrayIndex((int)x, (int)(y + 1), (int)z, (int)sliceSize)] = BLBlockRegistry.algae;
            }
        }
    }

    @Override
    public void preReplaceStackBlocks(int x, int y, Block[] chunkBlocks, byte[] chunkMeta, BiomeGenBaseBetweenlands biome, ChunkProviderBetweenlands provider, BiomeGenBase[] chunksForGeneration, Random rng) {
    }
}

