/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.decorators.base;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.biomes.base.BLBiomeRegistry;
import thebetweenlands.world.biomes.base.ChunkDataAccess;
import thebetweenlands.world.biomes.decorators.data.SurfaceType;
import thebetweenlands.world.feature.gen.OreGens;

public class BiomeDecoratorBaseBetweenlands {
    private int postChunkPopulatePasses = 1;
    private int postChunkGenPasses = 1;
    protected World world;
    protected Random rand;
    protected int x;
    protected int z;
    protected int xx;
    protected int yy;
    protected int zz;
    protected int attempt;

    public final BiomeDecoratorBaseBetweenlands setPostChunkGenPasses(int passes) {
        this.postChunkGenPasses = passes;
        return this;
    }

    public final BiomeDecoratorBaseBetweenlands setPostChunkPopulatePasses(int passes) {
        this.postChunkPopulatePasses = passes;
        return this;
    }

    public final int getX() {
        return this.x;
    }

    public final int getZ() {
        return this.z;
    }

    public final Random getRNG() {
        return this.rand;
    }

    public final World getWorld() {
        return this.world;
    }

    public final void postChunkPopulate(World world, Random rand, int x, int z) {
        this.x = x;
        this.z = z;
        this.rand = rand;
        this.world = world;
        this.generateOres();
        for (int i = 0; i < this.postChunkPopulatePasses; ++i) {
            this.postChunkPopulate(i);
        }
    }

    public final void postChunkGen(World world, Random rand, int x, int z) {
        this.x = x;
        this.z = z;
        this.rand = rand;
        this.world = world;
        for (int i = 0; i < this.postChunkGenPasses; ++i) {
            this.postChunkGen(i);
        }
    }

    public final void preChunkProvide(World world, Random rand, int chunkX, int chunkZ, Block[] blocks, byte[] metadata, BiomeGenBase[] biomes) {
        this.preChunkProvide(world, rand, new ChunkDataAccess(chunkX, chunkZ, blocks, metadata, biomes));
    }

    protected void preChunkProvide(World world, Random rand, ChunkDataAccess dataAccess) {
    }

    protected void postChunkPopulate(int pass) {
    }

    protected void postChunkGen(int pass) {
    }

    protected final int offsetXZ() {
        return this.rand.nextInt(16) + 8;
    }

    protected boolean checkSurface(SurfaceType surfaceType, int x, int y, int z) {
        return surfaceType.matchBlock(this.world.func_147439_a(x, y - 1, z)) && this.world.func_147437_c(x, y, z);
    }

    protected void generateOres() {
        this.generateOre(22, OreGens.SULFUR, 0, 128);
        this.generateOre(10, OreGens.SYRMORITE, 34, 55);
        this.generateOre(10, OreGens.BONE_ORE, 34, 55);
        this.generateOre(10, OreGens.OCTINE, 34, 55);
        this.generateOre(10, OreGens.SWAMP_DIRT, 34, 55);
        this.generateOre(1, OreGens.LIMESTONE, 34, 55);
        this.generateOre(3, OreGens.VALONITE, 0, 34);
        this.generateOre(4, OreGens.SCABYST, 0, 34);
        this.generateOre(200, OreGens.LIFE_GEM, 0, 20);
        int cycles = 1 + (this.rand.nextBoolean() ? this.rand.nextInt(2) : 0);
        if (this.world.func_72807_a(this.x, this.z) == BLBiomeRegistry.sludgePlains) {
            cycles = 5 + this.rand.nextInt(3);
        }
        block5: for (int i = 0; i < cycles; ++i) {
            if (this.rand.nextInt(9 / cycles + 1) != 0) continue;
            int xx = this.x + this.rand.nextInt(16) - 8;
            int zz = this.z + this.rand.nextInt(16) - 8;
            int yy = this.world.func_72976_f(xx, zz) - 1;
            boolean hasMud = false;
            for (int yo = 0; yo < 16; ++yo) {
                int bx = yy + yo;
                if (this.world.func_147439_a(xx, yy + yo, zz) != BLBlockRegistry.swampWater || this.world.func_147439_a(xx, yy + yo - 1, zz) != BLBlockRegistry.mud) continue;
                hasMud = true;
                yy = bx - 1;
            }
            if (!hasMud) continue;
            switch (this.rand.nextInt(3)) {
                case 0: {
                    this.world.func_147449_b(xx, yy, zz, BLBlockRegistry.aquaMiddleGemOre);
                    continue block5;
                }
                case 1: {
                    this.world.func_147449_b(xx, yy, zz, BLBlockRegistry.crimsonMiddleGemOre);
                    continue block5;
                }
                case 2: {
                    this.world.func_147449_b(xx, yy, zz, BLBlockRegistry.greenMiddleGemOre);
                }
            }
        }
    }

    protected void generateOre(int tries, WorldGenerator oreGen, int minY, int maxY) {
        for (int i = 0; i < tries; ++i) {
            int xx = this.x + this.rand.nextInt(16);
            int yy = this.rand.nextInt(maxY) + this.rand.nextInt(maxY) + (minY - maxY);
            int zz = this.z + this.rand.nextInt(16);
            oreGen.func_76484_a(this.world, this.rand, xx, yy, zz);
        }
    }
}

