/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.decorators;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.plants.BlockSwampReed;
import thebetweenlands.blocks.plants.BlockWaterFlower;
import thebetweenlands.blocks.plants.roots.BlockRoot;
import thebetweenlands.blocks.terrain.BlockSwampWater;
import thebetweenlands.utils.CubicBezier;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.biomes.decorators.data.SurfaceType;
import thebetweenlands.world.biomes.feature.WorldGenFluidPool;
import thebetweenlands.world.feature.gen.cave.WorldGenCaveGrass;
import thebetweenlands.world.feature.gen.cave.WorldGenCaveMoss;
import thebetweenlands.world.feature.gen.cave.WorldGenCavePots;
import thebetweenlands.world.feature.gen.cave.WorldGenSpeleothem;
import thebetweenlands.world.feature.gen.cave.WorldGenThorns;
import thebetweenlands.world.feature.plants.WorldGenHugeMushroom;
import thebetweenlands.world.feature.plants.WorldGenMossPatch;
import thebetweenlands.world.feature.plants.WorldGenMushrooms;
import thebetweenlands.world.feature.plants.WorldGenWeedWoodBush;
import thebetweenlands.world.feature.structure.WorldGenCragrockTower;
import thebetweenlands.world.feature.structure.WorldGenIdolHeads;
import thebetweenlands.world.feature.structure.WorldGenMudStructures;
import thebetweenlands.world.feature.structure.WorldGenSmallRuins;
import thebetweenlands.world.feature.structure.WorldGenSpawnerStructure;
import thebetweenlands.world.feature.structure.WorldGenUnderGroundStructures;
import thebetweenlands.world.feature.structure.WorldGenWightFortress;
import thebetweenlands.world.feature.trees.WorldGenGiantTreeAlive;
import thebetweenlands.world.feature.trees.WorldGenGiantTreeDead;
import thebetweenlands.world.feature.trees.WorldGenRottenLogs;
import thebetweenlands.world.feature.trees.WorldGenRubberTree;
import thebetweenlands.world.feature.trees.WorldGenSapTree;
import thebetweenlands.world.feature.trees.WorldGenSmallHollowLog;
import thebetweenlands.world.feature.trees.WorldGenSmallWeedWoodTree;
import thebetweenlands.world.feature.trees.WorldGenWeedWoodTree;

public class DecorationHelper {
    private static final WorldGenGiantTreeAlive GEN_GIANT_TREE = new WorldGenGiantTreeAlive();
    private static final WorldGenerator GEN_WEEDWOOD_TREE = new WorldGenWeedWoodTree();
    private static final WorldGenerator GEN_SMAL_WEEDWOOD_TREE = new WorldGenSmallWeedWoodTree();
    private static final WorldGenerator GEN_SAP_TREE = new WorldGenSapTree();
    private static final WorldGenerator GEN_RUBBER_TREE = new WorldGenRubberTree();
    private static final WorldGenerator GEN_WEEDWOOD_BUSH = new WorldGenWeedWoodBush();
    private static final WorldGenerator GEN_BLACK_HAT_MUSHROOMS = new WorldGenMushrooms((Block)BLBlockRegistry.blackHatMushroom, 15);
    private static final WorldGenerator GEN_FLAT_HEAD_MUSHROOMS = new WorldGenMushrooms((Block)BLBlockRegistry.flatHeadMushroom, 15);
    private static final WorldGenTallGrass GEN_NETTLE = new WorldGenTallGrass(BLBlockRegistry.nettle, 1);
    private static final WorldGenTallGrass GEN_CATTAIL = new WorldGenTallGrass(BLBlockRegistry.catTail, 1);
    private static final WorldGenTallGrass GEN_SWAMP_TALL_GRASS = new WorldGenTallGrass(BLBlockRegistry.swampTallGrass, 1);
    private static final WorldGenTallGrass GEN_SWAMP_DOUBLE_TALL_GRASS = new WorldGenTallGrass(BLBlockRegistry.doubleSwampTallgrass, 1);
    private static final WorldGenTallGrass GEN_SWAMP_PLANT = new WorldGenTallGrass((Block)BLBlockRegistry.swampPlant, 1);
    private static final WorldGenTallGrass GEN_VENUS_FLY_TRAP = new WorldGenTallGrass((Block)BLBlockRegistry.venusFlyTrap, 0);
    private static final WorldGenTallGrass GEN_VOLARPAD = new WorldGenTallGrass((Block)BLBlockRegistry.volarpad, 0);
    private static final WorldGenerator GEN_MOSS_PATCH = new WorldGenMossPatch(0);
    private static final WorldGenerator GEN_LICHEN_PATCH = new WorldGenMossPatch(1);
    private static final WorldGenTallGrass GEN_ARROW_ARUM = new WorldGenTallGrass(BLBlockRegistry.arrowArum, 1);
    private static final WorldGenTallGrass GEN_BUTTON_BUSH = new WorldGenTallGrass(BLBlockRegistry.buttonBush, 1);
    private static final WorldGenTallGrass GEN_MARSH_HIBISCUS = new WorldGenTallGrass(BLBlockRegistry.marshHibiscus, 1);
    private static final WorldGenTallGrass GEN_PICKEREL_WEED = new WorldGenTallGrass(BLBlockRegistry.pickerelWeed, 1);
    private static final WorldGenTallGrass GEN_PHRAGMITES = new WorldGenTallGrass(BLBlockRegistry.phragmites, 1);
    private static final WorldGenTallGrass GEN_SOFT_RUSH = new WorldGenTallGrass(BLBlockRegistry.softRush, 1);
    private static final WorldGenTallGrass GEN_MARSH_MALLOW = new WorldGenTallGrass(BLBlockRegistry.marshMallow, 1);
    private static final WorldGenTallGrass GEN_MILKWEED = new WorldGenTallGrass(BLBlockRegistry.milkweed, 1);
    private static final WorldGenTallGrass GEN_SHOOTS = new WorldGenTallGrass(BLBlockRegistry.shoots, 1);
    private static final WorldGenTallGrass GEN_COPPER_IRIS = new WorldGenTallGrass(BLBlockRegistry.copperIris, 1);
    private static final WorldGenTallGrass GEN_BLUE_IRIS = new WorldGenTallGrass(BLBlockRegistry.blueIris, 1);
    private static final WorldGenTallGrass GEN_BLUE_EYED_GRASS = new WorldGenTallGrass(BLBlockRegistry.blueEyedGrass, 1);
    private static final WorldGenTallGrass GEN_BONESET = new WorldGenTallGrass(BLBlockRegistry.boneset, 1);
    private static final WorldGenTallGrass GEN_BOTTLE_BRUSH_GRASS = new WorldGenTallGrass(BLBlockRegistry.bottleBrushGrass, 1);
    private static final WorldGenGiantTreeDead GEN_DEAD_TREE = new WorldGenGiantTreeDead();
    private static final WorldGenHugeMushroom GEN_HUGE_MUSHROOM = new WorldGenHugeMushroom();
    private static final WorldGenFluidPool GEN_LIQUID_POOL = new WorldGenFluidPool();
    private static final WorldGenSmallHollowLog GEN_SMALL_HOLLOW_LOG = new WorldGenSmallHollowLog();
    private static final WorldGenSpeleothem GEN_SPELEOTHEM = new WorldGenSpeleothem();
    private static final WorldGenCaveGrass GEN_CAVE_GRASS = new WorldGenCaveGrass();
    private static final WorldGenThorns GEN_THORNS = new WorldGenThorns();
    private static final WorldGenCaveMoss GEN_CAVE_MOSS = new WorldGenCaveMoss();
    private static final WorldGenTallGrass GEN_SLUDGECREEP = new WorldGenTallGrass(BLBlockRegistry.sludgecreep, 1);
    private static final WorldGenTallGrass GEN_DEAD_WEEDWOOD_BUSH = new WorldGenTallGrass(BLBlockRegistry.deadWeedwoodBush, 1);
    private static final WorldGenCavePots GEN_CAVE_POTS = new WorldGenCavePots();
    private static final WorldGenSmallRuins GEN_SMALL_RUINS = new WorldGenSmallRuins();
    private static final WorldGenUnderGroundStructures GEN_UNDER_GROUND_STRUCTURES = new WorldGenUnderGroundStructures();
    private static final WorldGenMudStructures GEN_MUD_STRUCTURES = new WorldGenMudStructures();
    private static final CubicBezier SPELEOTHEM_Y_CDF = new CubicBezier(0.0f, 0.5f, 1.0f, 0.2f);
    private static final CubicBezier CAVE_MOSS_Y_CDF = new CubicBezier(0.0f, 1.0f, 0.0f, 1.0f);
    private static final CubicBezier CAVE_POTS_Y_CDF = new CubicBezier(0.0f, 1.0f, 0.0f, 1.0f);
    private static final CubicBezier THORNS_Y_CDF = new CubicBezier(1.0f, 0.5f, 1.0f, -0.25f);
    private static final CubicBezier CAVE_GRASS_Y_CDF = new CubicBezier(0.0f, 1.0f, 0.0f, 1.0f);
    private static final WorldGenSpawnerStructure GEN_DUNGEON = new WorldGenSpawnerStructure();
    private static final WorldGenIdolHeads GEN_HEADS = new WorldGenIdolHeads();
    private static final WorldGenCragrockTower GEN_CRAGROCK_TOWER = new WorldGenCragrockTower();
    private static final WorldGenWightFortress GEN_WIGHT_FORTRESS = new WorldGenWightFortress();
    private final Random rand;
    private final int x;
    private final int y;
    private final int z;
    private final World world;
    private final boolean centerOffset;
    private ChunkProviderBetweenlands provider;

    public DecorationHelper(Random rand, World world, int x, int y, int z, boolean centerOffset) {
        this.rand = rand;
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
        this.centerOffset = centerOffset;
        this.provider = (ChunkProviderBetweenlands)((WorldServer)world).field_73059_b.field_73246_d;
    }

    private final int offsetXZ() {
        return this.rand.nextInt(16) + (this.centerOffset ? 8 : 0);
    }

    private final boolean checkSurface(SurfaceType surfaceType, int x, int y, int z) {
        return surfaceType.matchBlock(this.world.func_147439_a(x, y - 1, z)) && this.world.func_147437_c(x, y, z);
    }

    private final boolean checkBelowWater(SurfaceType surfaceType, int x, int y, int z) {
        return surfaceType.matchBlock(this.world.func_147439_a(x, y - 1, z));
    }

    public void generatePhragmites(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) || !this.world.func_147437_c(x, y, z) || !this.world.func_147437_c(x, y + 1, z)) continue;
            this.world.func_147465_d(x, y, z, BLBlockRegistry.phragmites, 0, 2);
            this.world.func_147465_d(x, y + 1, z, BLBlockRegistry.phragmites, 8, 2);
        }
    }

    public void generateSludgecreep(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.DIRT, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_SLUDGECREEP.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateDeadWeedwoodBush(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.DIRT, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_DEAD_WEEDWOOD_BUSH.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateCardinalFlower(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) || !this.world.func_147437_c(x, y, z) || !this.world.func_147437_c(x, y + 1, z)) continue;
            this.world.func_147465_d(x, y, z, BLBlockRegistry.cardinalFlower, 0, 2);
            this.world.func_147465_d(x, y + 1, z, BLBlockRegistry.cardinalFlower, 8, 2);
        }
    }

    public void generateBroomsedge(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) || !this.world.func_147437_c(x, y, z) || !this.world.func_147437_c(x, y + 1, z)) continue;
            this.world.func_147465_d(x, y, z, BLBlockRegistry.broomsedge, 0, 2);
            this.world.func_147465_d(x, y + 1, z, BLBlockRegistry.broomsedge, 8, 2);
        }
    }

    public void generateTallCattail(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) || !this.world.func_147437_c(x, y, z) || !this.world.func_147437_c(x, y + 1, z)) continue;
            this.world.func_147465_d(x, y, z, BLBlockRegistry.tallCattail, 0, 2);
            this.world.func_147465_d(x, y + 1, z, BLBlockRegistry.tallCattail, 8, 2);
        }
    }

    public void generateBoneset(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_BONESET.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateBlueEyedGrass(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_BLUE_EYED_GRASS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateBottleBrushGrass(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_BOTTLE_BRUSH_GRASS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateCopperIris(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_COPPER_IRIS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateBlueIris(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_BLUE_IRIS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateArrowArum(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_ARROW_ARUM.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateShoots(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_SHOOTS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateMarshMallow(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_MARSH_MALLOW.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateButtonBush(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_BUTTON_BUSH.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateSoftRush(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_SOFT_RUSH.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateMilkweed(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_MILKWEED.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateMarshHibiscus(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_MARSH_HIBISCUS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generatePickerelWeed(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_PICKEREL_WEED.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateSwampGrass(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_SWAMP_TALL_GRASS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateSwampTallGrass(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) || !this.world.func_147437_c(x, y, z) || !this.world.func_147437_c(x, y + 1, z)) continue;
            this.world.func_147465_d(x, y, z, BLBlockRegistry.doubleSwampTallgrass, 0, 2);
            this.world.func_147465_d(x, y + 1, z, BLBlockRegistry.doubleSwampTallgrass, 8, 2);
        }
    }

    public void generateSwampPlant(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_SWAMP_PLANT.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateNettles(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.MIXED, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_NETTLE.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateCattail(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_CATTAIL.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateVenusFlyTrap(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_VENUS_FLY_TRAP.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateVolarpad(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_VOLARPAD.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateSundew(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) || !this.world.func_147437_c(x, y, z) || !this.world.func_147437_c(x, y + 1, z)) continue;
            this.world.func_147465_d(x, y, z, (Block)BLBlockRegistry.sundew, 0, 2);
            this.world.func_147465_d(x, y + 1, z, (Block)BLBlockRegistry.sundew, 8, 2);
        }
    }

    public void generatePitcherPlant(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) || !this.world.func_147437_c(x, y, z) || !this.world.func_147437_c(x, y + 1, z)) continue;
            this.world.func_147465_d(x, y, z, (Block)BLBlockRegistry.pitcherPlant, 0, 2);
            this.world.func_147465_d(x, y + 1, z, (Block)BLBlockRegistry.pitcherPlant, 8, 2);
        }
    }

    public void generateRottenLog(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int length = this.rand.nextInt(5) + 4;
            int baseRadius = this.rand.nextInt(3) + 2;
            byte direction = (byte)this.rand.nextInt(2);
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) && (!this.checkBelowWater(SurfaceType.DIRT, x, y, z) || !this.checkBelowWater(SurfaceType.WATER, x, y + 1, z))) continue;
            new WorldGenRottenLogs(length, baseRadius, direction).func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateWeedwoodBush(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_WEEDWOOD_BUSH.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateBlackHatMushrooms(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int x = this.x + this.offsetXZ();
            int y = this.y - 8 + this.rand.nextInt(16);
            int z = this.z + this.offsetXZ();
            GEN_BLACK_HAT_MUSHROOMS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateFlatHeadMushrooms(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int x = this.x + this.offsetXZ();
            int y = this.y - 8 + this.rand.nextInt(16);
            int z = this.z + this.offsetXZ();
            GEN_FLAT_HEAD_MUSHROOMS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateWisp(double probability) {
        int z;
        int y;
        int x;
        if (probability >= 1.0) {
            for (int i = 0; i < (int)probability; ++i) {
                int z2;
                int y2;
                int x2 = this.x + this.offsetXZ();
                if (!this.checkSurface(SurfaceType.WATER, x2, y2 = this.y - 8 + this.rand.nextInt(16), z2 = this.z + this.offsetXZ())) continue;
                BLBlockRegistry.wisp.generateBlock(this.world, x2, y2, z2);
            }
        } else if (this.rand.nextInt((int)(1.0 / probability)) == 0 && this.checkSurface(SurfaceType.WATER, x = this.x + this.offsetXZ(), y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) {
            BLBlockRegistry.wisp.generateBlock(this.world, x, y, z);
        }
    }

    public void generateGiantWeedwoodTree(int rate) {
        int z;
        int y;
        if (this.rand.nextInt(rate) != 0) {
            return;
        }
        int x = this.x + this.offsetXZ();
        if (GEN_GIANT_TREE.generateTree(this.world, this.rand, x, y = 76, z = this.z + this.offsetXZ())) {
            return;
        }
    }

    public void generateDeadTree(int rate) {
        int z;
        int y;
        if (this.rand.nextInt(rate) != 0) {
            return;
        }
        int x = this.x + this.offsetXZ();
        if (GEN_DEAD_TREE.generateTree(this.world, this.rand, x, y = 76, z = this.z + this.offsetXZ())) {
            return;
        }
    }

    public void generateWeedwoodTree(int attempts) {
        if (this.canShortThingsGenerateHere()) {
            for (int i = 0; i < attempts; ++i) {
                int z;
                int y;
                int x = this.x + this.offsetXZ();
                if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) && !this.checkSurface(SurfaceType.SWAMP_GRASS, x, y, z) && (!this.checkBelowWater(SurfaceType.DIRT, x, y, z) || !this.checkBelowWater(SurfaceType.WATER, x, y + 1, z))) continue;
                GEN_WEEDWOOD_TREE.func_76484_a(this.world, this.rand, x, y, z);
            }
        }
    }

    public void generateSmallWeedwoodTree(int attempts) {
        if (this.canShortThingsGenerateHere()) {
            for (int i = 0; i < attempts; ++i) {
                int z;
                int y;
                int x = this.x + this.rand.nextInt(11) + 11;
                if (!this.checkSurface(SurfaceType.DIRT, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.rand.nextInt(12) + 10) && !this.checkSurface(SurfaceType.SWAMP_GRASS, x, y, z) && (!this.checkBelowWater(SurfaceType.DIRT, x, y, z) || !this.checkBelowWater(SurfaceType.WATER, x, y + 1, z))) continue;
                GEN_SMAL_WEEDWOOD_TREE.func_76484_a(this.world, this.rand, x, y, z);
            }
        }
    }

    public void generateSapTree(int attempts) {
        if (this.canShortThingsGenerateHere()) {
            for (int i = 0; i < attempts; ++i) {
                int z;
                int y;
                int x = this.x + this.offsetXZ();
                if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
                GEN_SAP_TREE.func_76484_a(this.world, this.rand, x, y, z);
            }
        }
    }

    public void generateHugeMushroom(int attempts) {
        if (this.canShortThingsGenerateHere()) {
            for (int i = 0; i < attempts; ++i) {
                int z;
                int y;
                int x = this.x + this.offsetXZ();
                if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
                GEN_HUGE_MUSHROOM.func_76484_a(this.world, this.rand, x, y, z);
            }
        }
    }

    public void generateRubberTree(int attempts) {
        if (this.canShortThingsGenerateHere()) {
            for (int i = 0; i < attempts; ++i) {
                int z;
                int y;
                int x = this.x + this.offsetXZ();
                if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
                GEN_RUBBER_TREE.func_76484_a(this.world, this.rand, x, y, z);
            }
        }
    }

    public void generateWeepingBlue(int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.SWAMP_GRASS, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) || !this.world.func_147437_c(x, y, z) || !this.world.func_147437_c(x, y + 1, z)) continue;
            this.world.func_147465_d(x, y, z, (Block)BLBlockRegistry.weepingBlue, 0, 2);
            this.world.func_147465_d(x, y + 1, z, (Block)BLBlockRegistry.weepingBlue, 8, 2);
        }
    }

    public void generateMireCoral(double probability) {
        int z;
        int y;
        int x;
        Block cBlock;
        if (probability >= 1.0) {
            for (int i = 0; i < (int)probability; ++i) {
                int z2;
                int y2;
                int x2 = this.x + this.offsetXZ();
                Block cBlock2 = this.world.func_147439_a(x2, y2 = this.y - 8 + this.rand.nextInt(16), z2 = this.z + this.offsetXZ());
                if (cBlock2 != BLBlockRegistry.swampWater || !BLBlockRegistry.mireCoral.func_149742_c(this.world, x2, y2, z2)) continue;
                this.world.func_147465_d(x2, y2, z2, (Block)BLBlockRegistry.mireCoral, 0, 3);
            }
        } else if (this.rand.nextInt((int)(1.0 / probability)) == 0 && (cBlock = this.world.func_147439_a(x = this.x + this.offsetXZ(), y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) == BLBlockRegistry.swampWater && BLBlockRegistry.mireCoral.func_149742_c(this.world, x, y, z)) {
            this.world.func_147465_d(x, y, z, (Block)BLBlockRegistry.mireCoral, 0, 3);
        }
    }

    public void generateWaterWeedsSmall(double probability) {
        int z;
        int y;
        int x;
        Block cBlock;
        if (probability >= 1.0) {
            for (int i = 0; i < (int)probability; ++i) {
                int z2;
                int y2;
                int x2 = this.x + this.offsetXZ();
                Block cBlock2 = this.world.func_147439_a(x2, y2 = this.y - 8 + this.rand.nextInt(16), z2 = this.z + this.offsetXZ());
                if (cBlock2 != BLBlockRegistry.swampWater || !BLBlockRegistry.waterWeeds.func_149742_c(this.world, x2, y2, z2)) continue;
                this.world.func_147465_d(x2, y2, z2, (Block)BLBlockRegistry.waterWeeds, 0, 3);
            }
        } else if (this.rand.nextInt((int)(1.0 / probability)) == 0 && (cBlock = this.world.func_147439_a(x = this.x + this.offsetXZ(), y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) == BLBlockRegistry.swampWater && BLBlockRegistry.waterWeeds.func_149742_c(this.world, x, y, z)) {
            this.world.func_147465_d(x, y, z, (Block)BLBlockRegistry.waterWeeds, 0, 3);
        }
    }

    public void generateDeepWaterCoral(double probability) {
        int z;
        int y;
        int x;
        Block cBlock;
        if (probability >= 1.0) {
            for (int i = 0; i < (int)probability; ++i) {
                int z2;
                int y2;
                int x2 = this.x + this.offsetXZ();
                Block cBlock2 = this.world.func_147439_a(x2, y2 = this.y - 8 + this.rand.nextInt(16), z2 = this.z + this.offsetXZ());
                if (cBlock2 != BLBlockRegistry.swampWater || !BLBlockRegistry.deepWaterCoral.func_149742_c(this.world, x2, y2, z2)) continue;
                this.world.func_147465_d(x2, y2, z2, (Block)BLBlockRegistry.deepWaterCoral, 0, 3);
            }
        } else if (this.rand.nextInt((int)(1.0 / probability)) == 0 && (cBlock = this.world.func_147439_a(x = this.x + this.offsetXZ(), y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) == BLBlockRegistry.swampWater && BLBlockRegistry.deepWaterCoral.func_149742_c(this.world, x, y, z)) {
            this.world.func_147465_d(x, y, z, (Block)BLBlockRegistry.deepWaterCoral, 0, 3);
        }
    }

    public void generateFlowerPatch(double probability) {
        int z;
        int y;
        int x;
        Block cBlock;
        if (probability >= 1.0) {
            for (int i = 0; i < (int)probability; ++i) {
                int z2;
                int y2;
                int x2 = this.x + this.offsetXZ();
                Block cBlock2 = this.world.func_147439_a(x2, (y2 = this.y - 8 + this.rand.nextInt(16)) + 1, z2 = this.z + this.offsetXZ());
                if (cBlock2 != BLBlockRegistry.swampWater || !BLBlockRegistry.waterFlowerStalk.func_149742_c(this.world, x2, y2, z2)) continue;
                BlockWaterFlower.generateFlowerPatch(this.world, x2, y2, z2, 35, 10);
            }
        } else if (this.rand.nextInt((int)(1.0 / probability)) == 0 && (cBlock = this.world.func_147439_a(x = this.x + this.offsetXZ(), y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) == BLBlockRegistry.swampWater && BLBlockRegistry.waterFlowerStalk.func_149742_c(this.world, x, y, z)) {
            BlockWaterFlower.generateFlowerPatch(this.world, x, y, z, 35, 10);
        }
    }

    public void generateWaterRoots(double probability) {
        if (probability >= 1.0) {
            for (int i = 0; i < (int)probability; ++i) {
                int x = this.x + this.offsetXZ();
                int y = this.y - 8 + this.rand.nextInt(16);
                int z = this.z + this.offsetXZ();
                Block block = this.world.func_147439_a(x, y, z);
                Block blockAbove = this.world.func_147439_a(x, y + 1, z);
                Block blockAbove2 = this.world.func_147439_a(x, y + 2, z);
                if (block != BLBlockRegistry.mud || blockAbove != BLBlockRegistry.swampWater || blockAbove2 != BLBlockRegistry.swampWater) continue;
                if (this.world.field_73012_v.nextInt(3) == 0) {
                    BlockRoot.generateWaterRootPatch(this.world, x, y + 1, z, 60, 15);
                    continue;
                }
                BlockRoot.generateRoot(this.world, x, y + 1, z, 80 - y + this.world.field_73012_v.nextInt(8) + 1);
            }
        } else if (this.rand.nextInt((int)(1.0 / probability)) == 0) {
            int x = this.x + this.offsetXZ();
            int y = this.y - 8 + this.rand.nextInt(16);
            int z = this.z + this.offsetXZ();
            Block block = this.world.func_147439_a(x, y, z);
            Block blockAbove = this.world.func_147439_a(x, y + 1, z);
            Block blockAbove2 = this.world.func_147439_a(x, y + 2, z);
            if (block == BLBlockRegistry.mud && blockAbove == BLBlockRegistry.swampWater && blockAbove2 == BLBlockRegistry.swampWater) {
                if (this.world.field_73012_v.nextInt(3) == 0) {
                    BlockRoot.generateWaterRootPatch(this.world, x, y + 1, z, 60, 15);
                } else {
                    BlockRoot.generateRoot(this.world, x, y + 1, z, 80 - y + this.world.field_73012_v.nextInt(8) + 1);
                }
            }
        }
    }

    public void generateRoots(double probability, int patchProbability) {
        if (probability >= 1.0) {
            for (int i = 0; i < (int)probability; ++i) {
                boolean hasSpace;
                int x = this.x + this.offsetXZ();
                int y = this.y - 8 + this.rand.nextInt(16);
                int z = this.z + this.offsetXZ();
                Block cBlock = this.world.func_147439_a(x, y, z);
                Block blockAbove = this.world.func_147439_a(x, y + 1, z);
                Block blockAbove2 = this.world.func_147439_a(x, y + 2, z);
                boolean bl = hasSpace = blockAbove == Blocks.field_150350_a && blockAbove2 == Blocks.field_150350_a;
                if (cBlock != BLBlockRegistry.swampGrass && cBlock != BLBlockRegistry.deadGrass && cBlock != BLBlockRegistry.mud || !hasSpace) continue;
                if (this.world.field_73012_v.nextInt(patchProbability) == 0) {
                    BlockRoot.generateRootPatch(this.world, x, y + 1, z, 60, 15);
                    continue;
                }
                BlockRoot.generateRoot(this.world, x, y + 1, z, 80 - y + this.world.field_73012_v.nextInt(8) + 1);
            }
        } else if (this.rand.nextInt((int)(1.0 / probability)) == 0) {
            boolean hasSpace;
            int x = this.x + this.offsetXZ();
            int y = this.y - 8 + this.rand.nextInt(16);
            int z = this.z + this.offsetXZ();
            Block cBlock = this.world.func_147439_a(x, y, z);
            Block blockAbove = this.world.func_147439_a(x, y + 1, z);
            Block blockAbove2 = this.world.func_147439_a(x, y + 2, z);
            boolean bl = hasSpace = blockAbove == Blocks.field_150350_a && blockAbove2 == Blocks.field_150350_a;
            if ((cBlock == BLBlockRegistry.swampGrass || cBlock == BLBlockRegistry.deadGrass || cBlock == BLBlockRegistry.mud) && hasSpace) {
                if (this.world.field_73012_v.nextInt(patchProbability) == 0) {
                    BlockRoot.generateRootPatch(this.world, x, y + 1, z, 60, 15);
                } else {
                    BlockRoot.generateRoot(this.world, x, y + 1, z, 80 - y + this.world.field_73012_v.nextInt(8) + 1);
                }
            }
        }
    }

    public void generateReeds(double probability) {
        if (probability >= 1.0) {
            for (int i = 0; i < (int)probability; ++i) {
                int x = this.x + this.offsetXZ();
                int y = this.y - 8 + this.rand.nextInt(16);
                int z = this.z + this.offsetXZ();
                Block block = this.world.func_147439_a(x, y, z);
                Block blockAbove = this.world.func_147439_a(x, y + 1, z);
                Block blockAbove2 = this.world.func_147439_a(x, y + 2, z);
                if (block == BLBlockRegistry.mud && blockAbove == BLBlockRegistry.swampWater && blockAbove2 == Blocks.field_150350_a) {
                    BlockSwampReed.generateReedPatch(this.world, x, y + 1, z, 40, 10);
                    continue;
                }
                if (!block.func_149662_c() || blockAbove != Blocks.field_150350_a || blockAbove2 != Blocks.field_150350_a || !BLBlockRegistry.swampReed.func_149742_c(this.world, x, y + 1, z)) continue;
                BlockSwampReed.generateReedPatch(this.world, x, y + 1, z, 40, 10);
            }
        } else if (this.rand.nextInt((int)(1.0 / probability)) == 0) {
            int x = this.x + this.offsetXZ();
            int y = this.y - 8 + this.rand.nextInt(16);
            int z = this.z + this.offsetXZ();
            Block block = this.world.func_147439_a(x, y, z);
            Block blockAbove = this.world.func_147439_a(x, y + 1, z);
            Block blockAbove2 = this.world.func_147439_a(x, y + 2, z);
            if (block == BLBlockRegistry.mud && blockAbove == BLBlockRegistry.swampWater && blockAbove2 == Blocks.field_150350_a) {
                BlockSwampReed.generateReedPatch(this.world, x, y + 1, z, 40, 10);
            } else if (block.func_149662_c() && blockAbove == Blocks.field_150350_a && blockAbove2 == Blocks.field_150350_a && BLBlockRegistry.swampReed.func_149742_c(this.world, x, y + 1, z)) {
                BlockSwampReed.generateReedPatch(this.world, x, y + 1, z, 40, 10);
            }
        }
    }

    public void generateWaterWeeds(int attempts, int radius, int density) {
        for (int i = 0; i < attempts; ++i) {
            int x = this.x + this.offsetXZ();
            int y = this.y - 8 + this.rand.nextInt(16);
            int z = this.z + this.offsetXZ();
            Block block = this.world.func_147439_a(x, y, z);
            Block blockAbove = this.world.func_147439_a(x, y + 1, z);
            if (block != BLBlockRegistry.mud || blockAbove != BLBlockRegistry.swampWater) continue;
            for (int i2 = 0; i2 < density; ++i2) {
                int bz;
                int by;
                int bx = x + this.world.field_73012_v.nextInt(radius) - radius / 2;
                if (!(Math.sqrt((bx - x) * (bx - x) + ((by = y + this.world.field_73012_v.nextInt(radius) - radius / 2) - y) * (by - y) + ((bz = z + this.world.field_73012_v.nextInt(radius) - radius / 2) - z) * (bz - z)) <= (double)radius)) continue;
                block = this.world.func_147439_a(bx, by, bz);
                blockAbove = this.world.func_147439_a(bx, by + 1, bz);
                if (block != BLBlockRegistry.mud || blockAbove != BLBlockRegistry.swampWater) continue;
                for (int yo = 1; yo < this.rand.nextInt(80 - by + 1); ++yo) {
                    this.world.func_147449_b(bx, by + yo, bz, (Block)BLBlockRegistry.swampKelp);
                }
            }
        }
    }

    public void generateOneDeep(int attempts, int radius, int density, BlockSwampWater uwBlock) {
        for (int i = 0; i < attempts; ++i) {
            int x = this.x + this.offsetXZ();
            int y = this.y - 8 + this.rand.nextInt(16);
            int z = this.z + this.offsetXZ();
            Block block = this.world.func_147439_a(x, y, z);
            Block blockAbove = this.world.func_147439_a(x, y + 1, z);
            Block blockAbove2 = this.world.func_147439_a(x, y + 2, z);
            if (block != BLBlockRegistry.mud || blockAbove != BLBlockRegistry.swampWater || blockAbove2 != Blocks.field_150350_a) continue;
            for (int i2 = 0; i2 < density; ++i2) {
                int bz;
                int by;
                int bx = x + this.world.field_73012_v.nextInt(radius) - radius / 2;
                if (!(Math.sqrt((bx - x) * (bx - x) + ((by = y + this.world.field_73012_v.nextInt(radius) - radius / 2) - y) * (by - y) + ((bz = z + this.world.field_73012_v.nextInt(radius) - radius / 2) - z) * (bz - z)) <= (double)radius)) continue;
                block = this.world.func_147439_a(bx, by, bz);
                blockAbove = this.world.func_147439_a(bx, by + 1, bz);
                blockAbove2 = this.world.func_147439_a(bx, by + 2, bz);
                if (block != BLBlockRegistry.mud || blockAbove != BLBlockRegistry.swampWater || blockAbove2 != Blocks.field_150350_a) continue;
                this.world.func_147449_b(x, y + 1, z, (Block)uwBlock);
            }
        }
    }

    public void generateMossPatch(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int zz;
            int yy;
            int xx = this.x + this.offsetXZ();
            if (!this.world.func_147437_c(xx, yy = 30 + this.rand.nextInt(80), zz = this.z + this.offsetXZ())) continue;
            GEN_MOSS_PATCH.func_76484_a(this.world, this.rand, xx, yy, zz);
        }
    }

    public void generateLichenPatch(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int zz;
            int yy;
            int xx = this.x + this.offsetXZ();
            if (!this.world.func_147437_c(xx, yy = 30 + this.rand.nextInt(80), zz = this.z + this.offsetXZ())) continue;
            GEN_LICHEN_PATCH.func_76484_a(this.world, this.rand, xx, yy, zz);
        }
    }

    public void generateTarPool(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int zz;
            int yy;
            int xx = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.MIXED, xx, yy = 6 + this.rand.nextInt(80), zz = this.z + this.offsetXZ())) continue;
            GEN_LIQUID_POOL.prepare((this.rand.nextDouble() + 0.7) * 1.5);
            GEN_LIQUID_POOL.generatePool(this.world, this.rand, xx, yy, zz, BLBlockRegistry.tarFluid, false);
        }
    }

    public void generateStagnantWaterPool(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int zz;
            int yy;
            int xx = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.UNDERGROUND, xx, yy = 6 + this.rand.nextInt(40), zz = this.z + this.offsetXZ())) continue;
            GEN_LIQUID_POOL.prepare((this.rand.nextDouble() + 0.7) * 1.5);
            GEN_LIQUID_POOL.generatePool(this.world, this.rand, xx, yy, zz, BLBlockRegistry.stagnantWaterFluid, true);
        }
    }

    public void generateSmallRuins(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int x = this.x + 16;
            int y = this.y - 8 + this.rand.nextInt(16);
            int z = this.z + 16;
            GEN_SMALL_RUINS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateUnderGroundStructures(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int x = this.x + this.offsetXZ();
            int y = 20 + this.rand.nextInt(16);
            int z = this.z + this.offsetXZ();
            GEN_UNDER_GROUND_STRUCTURES.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateMudStructures(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int x = this.x + this.offsetXZ();
            int y = this.y - 8 + this.rand.nextInt(16);
            int z = this.z + this.offsetXZ();
            GEN_MUD_STRUCTURES.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateDungeon(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int x = this.x + this.offsetXZ();
            int y = this.y - 8 + this.rand.nextInt(16);
            int z = this.z + this.offsetXZ();
            GEN_DUNGEON.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateHeads(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.MIXED, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ()) || !this.checkSurface(SurfaceType.MIXED, x - 2, y, z - 2) || !this.checkSurface(SurfaceType.MIXED, x + 2, y, z - 2) || !this.checkSurface(SurfaceType.MIXED, x - 2, y, z + 2) || !this.checkSurface(SurfaceType.MIXED, x + 2, y, z + 2)) continue;
            GEN_HEADS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateSmallHollowLog(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int z;
            int y;
            int x = this.x + this.offsetXZ();
            if (!this.checkSurface(SurfaceType.MIXED, x, y = this.y - 8 + this.rand.nextInt(16), z = this.z + this.offsetXZ())) continue;
            GEN_SMALL_HOLLOW_LOG.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateCragrockTower(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int x = this.x + this.offsetXZ() - 3;
            int y = 86;
            int z = this.z + this.offsetXZ() - 3;
            GEN_CRAGROCK_TOWER.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateWightFortress(int attempt) {
        for (int i = 0; i < attempt; ++i) {
            int x = this.x;
            int y = 81;
            int z = this.z;
            if (!this.checkSurface(SurfaceType.MIXED, x, y, z) || !this.checkSurface(SurfaceType.MIXED, x + 32, y, z + 32) || !this.checkSurface(SurfaceType.MIXED, x + 16, y, z + 16) || !this.checkSurface(SurfaceType.MIXED, x + 32, y, z) || !this.checkSurface(SurfaceType.MIXED, x, y, z + 32)) continue;
            GEN_WIGHT_FORTRESS.func_76484_a(this.world, this.rand, x, y, z);
            break;
        }
    }

    public void populateCave() {
        this.generateSpeleothems(60);
        this.generateCavePots(this.rand.nextInt(3) == 0 ? 2 : 1);
        this.generateThorns(200);
        this.generateCaveMoss(100);
        this.generateCaveGrass(120);
    }

    public void generateCaveGrass(int attempts) {
        while (attempts-- > 0) {
            int x = this.x + this.offsetXZ();
            float v = CAVE_GRASS_Y_CDF.eval(this.rand.nextFloat());
            int y = (int)(v * 14.0f + 20.0f + 0.5f);
            int z = this.z + this.offsetXZ();
            GEN_CAVE_GRASS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateSpeleothems(int attempts) {
        attempts += this.getSpeleothemAttemptAdditive();
        while (attempts-- > 0) {
            int x = this.x + this.offsetXZ();
            float v = SPELEOTHEM_Y_CDF.eval(this.rand.nextFloat());
            int y = (int)(v * 60.0f + 20.0f + 0.5f);
            int z = this.z + this.offsetXZ();
            GEN_SPELEOTHEM.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateThorns(int attempts) {
        while (attempts-- > 0) {
            int x = this.x + this.offsetXZ();
            float v = THORNS_Y_CDF.eval(this.rand.nextFloat());
            int y = (int)(v * 60.0f + 20.0f + 0.5f);
            int z = this.z + this.offsetXZ();
            GEN_THORNS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateCaveMoss(int attempts) {
        while (attempts-- > 0) {
            int x = this.x + this.offsetXZ();
            float v = CAVE_MOSS_Y_CDF.eval(this.rand.nextFloat());
            int y = (int)(v * 60.0f + 20.0f + 0.5f);
            int z = this.z + this.offsetXZ();
            GEN_CAVE_MOSS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    public void generateCavePots(int attempts) {
        while (attempts-- > 0) {
            int x = this.x + this.offsetXZ();
            float v = CAVE_POTS_Y_CDF.eval(this.rand.nextFloat());
            int y = (int)(v * 50.0f + 20.0f + 0.5f);
            int z = this.z + this.offsetXZ();
            GEN_CAVE_POTS.func_76484_a(this.world, this.rand, x, y, z);
        }
    }

    private boolean canShortThingsGenerateHere() {
        return this.provider.evalTreeNoise((double)this.x * 0.01, (double)this.z * 0.01) > -0.25;
    }

    private int getSpeleothemAttemptAdditive() {
        return (int)((this.provider.evalSpeleothemDensityNoise((double)this.x * 0.03, (double)this.z * 0.03) * 0.5 + 0.5) * 20.0);
    }
}

