/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.decorators;

import net.minecraft.block.Block;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.world.biomes.decorators.DecorationHelper;
import thebetweenlands.world.biomes.decorators.base.BiomeDecoratorBaseBetweenlands;

public class BiomeDecoratorSwampLands
extends BiomeDecoratorBaseBetweenlands {
    public BiomeDecoratorSwampLands() {
        this.setPostChunkGenPasses(2);
    }

    @Override
    public void postChunkGen(int pass) {
        if (pass == 0) {
            DecorationHelper helper = new DecorationHelper(this.rand, this.world, this.x, this.world.func_72976_f(this.x, this.z), this.z, false);
            helper.generateTarPool(60);
            helper.populateCave();
            helper.generateGiantWeedwoodTree(30);
            helper.generateDeadTree(10);
            helper.generateRottenLog(2);
            helper.generateWeedwoodTree(80);
            helper.generateWeedwoodBush(45);
            helper.generateRubberTree(70);
            helper.generateSapTree(70);
            helper.generateReeds(600.0);
            helper.generateSwampPlant(75);
            helper.generateVenusFlyTrap(10);
            helper.generatePitcherPlant(20);
            helper.generateFlatHeadMushrooms(15);
            helper.generateBlackHatMushrooms(15);
            helper.generateVolarpad(2);
            helper.generateCattail(5);
            helper.generateNettles(8);
            helper.generateMossPatch(20);
            helper.generateStagnantWaterPool(5);
            helper.generateUnderGroundStructures(100);
        } else {
            for (int xo = -16; xo < 32; ++xo) {
                block1: for (int zo = -16; zo < 32; ++zo) {
                    int px = this.x + xo;
                    int pz = this.z + zo;
                    int py = this.world.func_72976_f(px, pz) - 1;
                    Block surfaceBlock = this.world.func_147439_a(px, py, pz);
                    if (surfaceBlock != BLBlockRegistry.rubberTreeLeaves && surfaceBlock != BLBlockRegistry.weedwoodLeaves && surfaceBlock != BLBlockRegistry.sapTreeLeaves) continue;
                    int yo = 0;
                    boolean hasLeaves = true;
                    for (int i = 0; i < 128 && py - ++yo > 70; ++i) {
                        boolean isBlockLeaves;
                        Block cBlock = this.world.func_147439_a(px, py - yo, pz);
                        boolean bl = isBlockLeaves = cBlock == BLBlockRegistry.rubberTreeLeaves || cBlock == BLBlockRegistry.weedwoodLeaves || cBlock == BLBlockRegistry.sapTreeLeaves;
                        if (isBlockLeaves) {
                            hasLeaves = true;
                        }
                        if (hasLeaves && (cBlock == BLBlockRegistry.deadGrass || cBlock == BLBlockRegistry.swampGrass || cBlock == BLBlockRegistry.swampDirt || cBlock == BLBlockRegistry.mud || cBlock == BLBlockRegistry.weedwoodLog) && this.world.func_147437_c(px, py - yo + 1, pz) && this.world.field_73012_v.nextInt(3) == 0) {
                            this.world.func_147449_b(px, py - yo + 1, pz, BLBlockRegistry.fallenLeaves);
                            continue block1;
                        }
                        if (isBlockLeaves || !cBlock.func_149662_c()) continue;
                        hasLeaves = false;
                    }
                }
            }
        }
    }
}

