/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.base;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.mobs.EntityFirefly;
import thebetweenlands.entities.mobs.EntityPeatMummy;
import thebetweenlands.entities.mobs.EntityPyrad;
import thebetweenlands.entities.mobs.EntitySwampHag;
import thebetweenlands.utils.IWeightProvider;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.biomes.base.BLBiomeRegistry;
import thebetweenlands.world.biomes.decorators.base.BiomeDecoratorBaseBetweenlands;
import thebetweenlands.world.biomes.feature.base.BiomeNoiseFeature;
import thebetweenlands.world.biomes.spawning.MobSpawnHandler;
import thebetweenlands.world.biomes.spawning.spawners.EventSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.LocationSpawnEntry;
import thebetweenlands.world.storage.chunk.storage.location.EnumLocationType;

public abstract class BiomeGenBaseBetweenlands
extends BiomeGenBase
implements IWeightProvider {
    protected final BiomeDecoratorBaseBetweenlands decorator;
    protected int grassColor;
    protected int foliageColor;
    protected int[] fogColorRGB = new int[]{255, 255, 255};
    protected Block bottomBlock = Blocks.field_150357_h;
    protected Block underLayerTopBlock;
    protected Block baseBlock;
    protected int bottomBlockHeight = 0;
    protected int bottomBlockFuzz = 5;
    protected boolean hasBaseBlockPatches = true;
    protected byte topBlockMeta = 0;
    protected byte fillerBlockMeta = 0;
    protected byte baseBlockMeta = 0;
    protected byte topBlockUnderLayerMeta = 0;
    protected byte bottomBlockMeta = 0;
    protected byte fillerBlockHeight = (byte)2;
    protected byte underLayerBlockHeight = (byte)2;
    protected boolean isNoiseGenInitialized = false;
    protected List<BiomeNoiseFeature> featureList = new ArrayList<BiomeNoiseFeature>();
    protected List<MobSpawnHandler.BLSpawnEntry> blSpawnEntries = new ArrayList<MobSpawnHandler.BLSpawnEntry>();
    private short biomeWeight;
    protected Block[] currentChunkBlocks;
    protected byte[] currentChunkMeta;
    protected ChunkProviderBetweenlands currentProvider;
    protected BiomeGenBase[] currentBiomesForGeneration;
    private NoiseGeneratorPerlin baseBlockLayerVariationNoiseGen;
    private double[] baseBlockLayerVariationNoise = new double[256];

    public BiomeGenBaseBetweenlands(int biomeID, BiomeDecoratorBaseBetweenlands decorator) {
        super(biomeID);
        this.decorator = decorator;
        this.field_76753_B = BLBlockRegistry.swampDirt;
        this.field_76752_A = BLBlockRegistry.swampGrass;
        this.baseBlock = BLBlockRegistry.betweenstone;
        this.underLayerTopBlock = Blocks.field_150346_d;
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.func_76732_a(2.0f, 0.0f);
        this.blSpawnEntries.add(new EventSpawnEntry(EntityFirefly.class, 150, "bloodSky").setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new EventSpawnEntry(EntitySwampHag.class, 175, "bloodSky").setHostile(true));
        this.blSpawnEntries.add(new EventSpawnEntry(EntityPeatMummy.class, 65, "bloodSky").setHostile(true).setSpawnCheckRadius(20.0));
        this.blSpawnEntries.add(new LocationSpawnEntry(EntityPyrad.class, 120, EnumLocationType.GIANT_TREE).setHostile(true).setSpawnCheckRadius(26.0).setSpawningInterval(500));
    }

    public List<MobSpawnHandler.BLSpawnEntry> getSpawnEntries() {
        return this.blSpawnEntries;
    }

    public final BiomeGenBaseBetweenlands addFeature(BiomeNoiseFeature feature) {
        this.featureList.add(feature);
        return this;
    }

    public final BiomeGenBaseBetweenlands setFillerBlockHeight(byte fillerBlockHeight) {
        this.fillerBlockHeight = fillerBlockHeight;
        return this;
    }

    public final BiomeGenBaseBetweenlands setUnderLayerBlockHeight(byte underLayerBlockHeight) {
        this.underLayerBlockHeight = underLayerBlockHeight;
        return this;
    }

    public final BiomeGenBaseBetweenlands setBlocks(Block baseBlock, Block fillerBlock, Block topBlock, Block underLayerTopBlock, Block bottomBlock) {
        this.baseBlock = baseBlock;
        this.field_76753_B = fillerBlock;
        this.field_76752_A = topBlock;
        this.underLayerTopBlock = underLayerTopBlock;
        this.bottomBlock = bottomBlock;
        return this;
    }

    public final BiomeGenBaseBetweenlands setBlockMeta(byte topBlockMeta, byte fillerBlockMeta, byte baseBlockMeta, byte topBlockUnderLayerMeta, byte bottomBlockMeta) {
        this.topBlockMeta = topBlockMeta;
        this.baseBlockMeta = baseBlockMeta;
        this.fillerBlockMeta = fillerBlockMeta;
        this.topBlockUnderLayerMeta = topBlockUnderLayerMeta;
        this.bottomBlockMeta = bottomBlockMeta;
        return this;
    }

    public final BiomeGenBaseBetweenlands setBaseBlockPatches(boolean enabled) {
        this.hasBaseBlockPatches = enabled;
        return this;
    }

    public final BiomeGenBaseBetweenlands setBottomBlockHeight(int height, int fuzz) {
        this.bottomBlockHeight = height;
        this.bottomBlockFuzz = fuzz;
        return this;
    }

    public final BiomeGenBaseBetweenlands setHeightAndVariation(int height, int variation) {
        this.field_76749_E = (float)variation / 128.0f;
        this.field_76748_D = ((float)height / 128.0f + this.field_76749_E) * 4.0f - 2.0f;
        return this;
    }

    public final BiomeGenBaseBetweenlands setColors(int grassColor, int foliageColor) {
        this.grassColor = grassColor;
        this.foliageColor = foliageColor;
        return this;
    }

    public final BiomeGenBaseBetweenlands setFogColor(byte red, byte green, byte blue) {
        this.fogColorRGB[0] = red;
        this.fogColorRGB[1] = green;
        this.fogColorRGB[2] = blue;
        return this;
    }

    public void postChunkPopulate(World world, Random rand, int x, int z) {
        this.decorator.postChunkPopulate(world, rand, x, z);
    }

    public void postChunkGen(World world, Random rand, int x, int z) {
        this.decorator.postChunkGen(world, rand, x, z);
    }

    public final void preChunkProvide(World world, Random rand, int chunkX, int chunkZ, Block[] blocks, byte[] metadata, BiomeGenBase[] biomes) {
        this.decorator.preChunkProvide(world, rand, chunkX, chunkZ, blocks, metadata, biomes);
    }

    @SideOnly(value=Side.CLIENT)
    public final int func_150558_b(int x, int y, int z) {
        return this.grassColor;
    }

    @SideOnly(value=Side.CLIENT)
    public final int func_150571_c(int x, int y, int z) {
        return this.foliageColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int[] getFogRGB() {
        return this.fogColorRGB;
    }

    @SideOnly(value=Side.CLIENT)
    public float getFogStart(float farPlaneDistance) {
        return 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getFogEnd(float farPlaneDistance) {
        return farPlaneDistance / 1.25f;
    }

    public final boolean isNoiseGenInitialized() {
        return this.isNoiseGenInitialized;
    }

    public final void initializeNoiseGen(Random rng) {
        if (this.baseBlockLayerVariationNoiseGen == null) {
            this.baseBlockLayerVariationNoiseGen = new NoiseGeneratorPerlin(rng, 4);
        }
        this.isNoiseGenInitialized = true;
        for (BiomeNoiseFeature feature : this.featureList) {
            feature.initializeNoiseGen(rng, this);
        }
        this.initializeNoiseGenBiome(rng);
    }

    protected void initializeNoiseGenBiome(Random rng) {
    }

    public final void generateNoise(int chunkX, int chunkZ) {
        this.baseBlockLayerVariationNoise = this.baseBlockLayerVariationNoiseGen.func_151599_a(this.baseBlockLayerVariationNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, 0.16, 0.16, 1.0);
        for (BiomeNoiseFeature feature : this.featureList) {
            feature.generateNoise(chunkX, chunkZ, this);
        }
        this.generateNoiseBiome(chunkX, chunkZ);
    }

    protected void generateNoiseBiome(int chunkX, int chunkZ) {
    }

    public Block getBaseBlock(int y) {
        return y > 34 ? this.baseBlock : BLBlockRegistry.pitstone;
    }

    public byte getBaseBlockMeta(int y) {
        return y > 34 ? this.baseBlockMeta : (byte)0;
    }

    public final Block getUnderLayerBlock() {
        return this.underLayerTopBlock;
    }

    public final void replaceStackBlocks(int blockX, int blockZ, int inChunkX, int inChunkZ, double baseBlockNoise, Random rng, Block[] chunkBlocks, byte[] blockMeta, ChunkProviderBetweenlands chunkProvider, BiomeGenBase[] biomesForGeneration, World world) {
        this.currentChunkBlocks = chunkBlocks;
        this.currentChunkMeta = blockMeta;
        this.currentProvider = chunkProvider;
        this.currentBiomesForGeneration = biomesForGeneration;
        for (BiomeNoiseFeature feature : this.featureList) {
            feature.currentBiomesForGeneration = biomesForGeneration;
            feature.currentProvider = chunkProvider;
            feature.currentRNG = rng;
            feature.setChunkAndWorld((blockX - (blockX & 0xF)) / 16, (blockZ - (blockZ & 0xF)) / 16, world);
            feature.preReplaceStackBlocks(inChunkX, inChunkZ, this.currentChunkBlocks, this.currentChunkMeta, this, chunkProvider, biomesForGeneration, rng);
        }
        if (!this.preReplaceStackBlocks(blockX, blockZ, inChunkX, inChunkZ)) {
            return;
        }
        int sliceSize = chunkBlocks.length / 256;
        int baseBlockNoiseRN = (int)(baseBlockNoise / 3.0 + 3.0 + rng.nextDouble() * 0.25);
        byte blocksBelow = -1;
        int blocksBelowLayer = -1;
        for (int y = 255; y >= 0; --y) {
            int cIndex = BiomeGenBaseBetweenlands.getBlockArrayIndex(inChunkX, y, inChunkZ, sliceSize);
            if (y <= this.bottomBlockHeight + rng.nextInt(this.bottomBlockFuzz)) {
                chunkBlocks[cIndex] = this.bottomBlock;
                blockMeta[cIndex] = this.bottomBlockMeta;
                continue;
            }
            Block currentBlock = chunkBlocks[cIndex];
            if (currentBlock == null || currentBlock.func_149688_o() == Material.field_151579_a || currentBlock == chunkProvider.layerBlock) {
                blocksBelow = -1;
                continue;
            }
            ++blocksBelow;
            if (currentBlock != chunkProvider.baseBlock) continue;
            int baseBlockVariationLayer = (int)Math.abs(this.baseBlockLayerVariationNoise[inChunkX * 16 + inChunkZ] * (double)0.7f);
            int layerBlockY = y - baseBlockVariationLayer;
            if (layerBlockY < 0) {
                layerBlockY = 0;
            }
            if (this.hasBaseBlockPatches && baseBlockNoiseRN <= 0) {
                chunkBlocks[cIndex] = this.getBaseBlock(layerBlockY);
                blockMeta[cIndex] = this.getBaseBlockMeta(layerBlockY);
                return;
            }
            int aboveIndex = BiomeGenBaseBetweenlands.getBlockArrayIndex(inChunkX, y + 1, inChunkZ, sliceSize);
            Block blockAbove = chunkBlocks[aboveIndex];
            if (blocksBelowLayer >= 0) {
                ++blocksBelowLayer;
            }
            if (currentBlock == chunkProvider.baseBlock && blockAbove == chunkProvider.layerBlock) {
                ++blocksBelowLayer;
            }
            if (blocksBelowLayer <= this.underLayerBlockHeight && blocksBelowLayer >= 0) {
                chunkBlocks[cIndex] = this.underLayerTopBlock;
                blockMeta[cIndex] = this.topBlockUnderLayerMeta;
                continue;
            }
            if (blocksBelow == 0 && currentBlock == chunkProvider.baseBlock) {
                chunkBlocks[cIndex] = this.field_76752_A;
                blockMeta[cIndex] = this.topBlockMeta;
                continue;
            }
            if (blocksBelow > 0 && blocksBelow <= this.fillerBlockHeight && currentBlock == chunkProvider.baseBlock) {
                chunkBlocks[cIndex] = this.field_76753_B;
                blockMeta[cIndex] = this.fillerBlockMeta;
                continue;
            }
            if (currentBlock != chunkProvider.baseBlock) continue;
            chunkBlocks[cIndex] = this.getBaseBlock(layerBlockY);
            blockMeta[cIndex] = this.getBaseBlockMeta(layerBlockY);
        }
        for (BiomeNoiseFeature feature : this.featureList) {
            feature.postReplaceStackBlocks(inChunkX, inChunkZ, this.currentChunkBlocks, this.currentChunkMeta, this, chunkProvider, biomesForGeneration, rng);
        }
        this.postReplaceStackBlocks(blockX, blockZ, inChunkX, inChunkZ);
    }

    protected boolean preReplaceStackBlocks(int blockX, int blockZ, int inChunkX, int inChunkZ) {
        return true;
    }

    protected void postReplaceStackBlocks(int blockX, int blockZ, int inChunkX, int inChunkZ) {
    }

    public static int getBlockArrayIndex(int x, int y, int z, int sliceSize) {
        return (z * 16 + x) * sliceSize + y;
    }

    protected final BiomeGenBaseBetweenlands setWeight(int weight) {
        if (this.biomeWeight != 0) {
            throw new RuntimeException("Cannot set biome weight twice!");
        }
        this.biomeWeight = (short)weight;
        if (this.getClass().getGenericSuperclass() == BiomeGenBaseBetweenlands.class) {
            BLBiomeRegistry.biomeList.add(this);
        }
        return this;
    }

    @Override
    public final short getWeight() {
        return this.biomeWeight;
    }

    public void addDefaultFlowers() {
        this.addFlower(BLBlockRegistry.boneset, 0, 10);
        this.addFlower(BLBlockRegistry.marshMallow, 0, 10);
        this.addFlower(BLBlockRegistry.nettle, 0, 10);
        this.addFlower(BLBlockRegistry.nettleFlowered, 0, 10);
        this.addFlower(BLBlockRegistry.buttonBush, 0, 10);
        this.addFlower(BLBlockRegistry.milkweed, 0, 10);
        this.addFlower(BLBlockRegistry.copperIris, 0, 10);
        this.addFlower(BLBlockRegistry.blueIris, 0, 10);
        this.addFlower((Block)BLBlockRegistry.waterFlower, 0, 10);
        this.addFlower(BLBlockRegistry.marshHibiscus, 0, 10);
        this.addFlower(BLBlockRegistry.pickerelWeed, 0, 10);
    }
}

