/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes.base;

import thebetweenlands.utils.WeightedList;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.biomes.BiomeCoarseIslands;
import thebetweenlands.world.biomes.BiomeDeepWaters;
import thebetweenlands.world.biomes.BiomeMarsh;
import thebetweenlands.world.biomes.BiomePatchyIslands;
import thebetweenlands.world.biomes.BiomeSludgePlains;
import thebetweenlands.world.biomes.BiomeSwampLands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.feature.Marsh1NoiseFeature;
import thebetweenlands.world.biomes.feature.Marsh2NoiseFeature;

public class BLBiomeRegistry {
    public static WeightedList<BiomeGenBaseBetweenlands> biomeList = new WeightedList();
    public static BiomeGenBaseBetweenlands swampLands;
    public static BiomeGenBaseBetweenlands coarseIslands;
    public static BiomeGenBaseBetweenlands deepWater;
    public static BiomeGenBaseBetweenlands patchyIslands;
    public static BiomeGenBaseBetweenlands marsh1;
    public static BiomeGenBaseBetweenlands marsh2;
    public static BiomeGenBaseBetweenlands sludgePlains;

    public static void init() {
        for (int id : new int[]{ConfigHandler.BIOME_ID_SWAMPLANDS, ConfigHandler.BIOME_ID_COARSE_ISLANDS, ConfigHandler.BIOME_ID_DEEP_WATER, ConfigHandler.BIOME_ID_PATCHY_ISLANDS, ConfigHandler.BIOME_ID_MARSH1, ConfigHandler.BIOME_ID_MARSH2, ConfigHandler.BIOME_ID_SLUDGE_PLAINS}) {
            if (id < 128 || !ConfigHandler.BIOME_ID_LIMIT) continue;
            throw new RuntimeException("Betweenlands biome IDs cannot be higher than 127!");
        }
        swampLands = new BiomeSwampLands(ConfigHandler.BIOME_ID_SWAMPLANDS);
        coarseIslands = new BiomeCoarseIslands(ConfigHandler.BIOME_ID_COARSE_ISLANDS);
        deepWater = new BiomeDeepWaters(ConfigHandler.BIOME_ID_DEEP_WATER);
        patchyIslands = new BiomePatchyIslands(ConfigHandler.BIOME_ID_PATCHY_ISLANDS);
        marsh1 = new BiomeMarsh(ConfigHandler.BIOME_ID_MARSH1, "marsh1", new Marsh1NoiseFeature());
        marsh2 = new BiomeMarsh(ConfigHandler.BIOME_ID_MARSH2, "marsh2", new Marsh2NoiseFeature());
        sludgePlains = new BiomeSludgePlains(ConfigHandler.BIOME_ID_SLUDGE_PLAINS);
        swampLands.func_150566_k();
        coarseIslands.func_150566_k();
        deepWater.func_150566_k();
        patchyIslands.func_150566_k();
        marsh1.func_150566_k();
        marsh2.func_150566_k();
        sludgePlains.func_150566_k();
    }
}

