/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes;

import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.mobs.EntityAngler;
import thebetweenlands.entities.mobs.EntityBlindCaveFish;
import thebetweenlands.entities.mobs.EntityBloodSnail;
import thebetweenlands.entities.mobs.EntityChiromaw;
import thebetweenlands.entities.mobs.EntityFirefly;
import thebetweenlands.entities.mobs.EntityFrog;
import thebetweenlands.entities.mobs.EntityGecko;
import thebetweenlands.entities.mobs.EntityGiantToad;
import thebetweenlands.entities.mobs.EntityLeech;
import thebetweenlands.entities.mobs.EntityMireSnail;
import thebetweenlands.entities.mobs.EntitySporeling;
import thebetweenlands.entities.mobs.EntitySwampHag;
import thebetweenlands.entities.mobs.EntityTarBeast;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.decorators.BiomeDecoratorSwampLands;
import thebetweenlands.world.biomes.decorators.base.BiomeDecoratorBaseBetweenlands;
import thebetweenlands.world.biomes.feature.AlgaeNoiseFeature;
import thebetweenlands.world.biomes.feature.FlatLandNoiseFeature;
import thebetweenlands.world.biomes.feature.PatchNoiseFeature;
import thebetweenlands.world.biomes.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.TarSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.TreeSpawnEntry;

public class BiomeSwampLands
extends BiomeGenBaseBetweenlands {
    public BiomeSwampLands(int biomeID) {
        this(biomeID, new BiomeDecoratorSwampLands());
    }

    public BiomeSwampLands(int biomeID, BiomeDecoratorBaseBetweenlands decorator) {
        super(biomeID, decorator);
        this.setFogColor((byte)10, (byte)30, (byte)12);
        this.setColors(3231025, 3231025);
        this.setWeight(25);
        this.setHeightAndVariation(70, 0);
        this.func_76735_a("swamplands");
        this.setBlocks(BLBlockRegistry.betweenstone, BLBlockRegistry.swampDirt, BLBlockRegistry.deadGrass, BLBlockRegistry.mud, BLBlockRegistry.betweenlandsBedrock);
        this.setFillerBlockHeight((byte)1);
        this.addFeature(new FlatLandNoiseFeature()).addFeature(new PatchNoiseFeature(0.1796875, 0.1796875, BLBlockRegistry.swampGrass)).addFeature(new PatchNoiseFeature(0.74, 0.74, BLBlockRegistry.swampDirt)).addFeature(new PatchNoiseFeature(0.65, 0.65, BLBlockRegistry.mud, 0.7407407407407407, 1.72)).addFeature(new AlgaeNoiseFeature());
        this.field_76759_H = 1589792;
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityFirefly.class, 20).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityGecko.class, 40).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(600));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityMireSnail.class, 60).setGroupSize(1, 5).setSpawnCheckRadius(32.0).setSpawningInterval(800));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityFrog.class, 26).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(100));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityBlindCaveFish.class, 30).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new TreeSpawnEntry(EntitySporeling.class, 120).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityGiantToad.class, 12).setSpawnCheckRadius(64.0).setSpawningInterval(800));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityGiantToad.class, 8).setSpawnCheckRadius(64.0).setSpawningInterval(800));
        this.blSpawnEntries.add(new TarSpawnEntry(EntityTarBeast.class, 80).setHostile(true));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityLeech.class, 35).setHostile(true));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityAngler.class, 40).setHostile(true));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityAngler.class, 35).setHostile(true).setGroupSize(1, 3));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntitySwampHag.class, 80).setHostile(true));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntitySwampHag.class, 140).setHostile(true).setSpawnCheckRadius(6.0).setGroupSize(1, 3));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityWight.class, 12).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityWight.class, 18).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityBloodSnail.class, 25).setHostile(true));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityChiromaw.class, 12).setHostile(true).setSpawnCheckRadius(30.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityChiromaw.class, 40).setHostile(true).setSpawnCheckRadius(20.0).setGroupSize(1, 3));
        BiomeDictionary.registerBiomeType((BiomeGenBase)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER});
    }
}

