/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes;

import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.mobs.EntityAngler;
import thebetweenlands.entities.mobs.EntityBlindCaveFish;
import thebetweenlands.entities.mobs.EntityBloodSnail;
import thebetweenlands.entities.mobs.EntityChiromaw;
import thebetweenlands.entities.mobs.EntityDragonFly;
import thebetweenlands.entities.mobs.EntityFirefly;
import thebetweenlands.entities.mobs.EntityFrog;
import thebetweenlands.entities.mobs.EntityGecko;
import thebetweenlands.entities.mobs.EntityLeech;
import thebetweenlands.entities.mobs.EntityLurker;
import thebetweenlands.entities.mobs.EntityMireSnail;
import thebetweenlands.entities.mobs.EntitySiltCrab;
import thebetweenlands.entities.mobs.EntitySporeling;
import thebetweenlands.entities.mobs.EntitySwampHag;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.decorators.BiomeDecoratorPatchyIslands;
import thebetweenlands.world.biomes.decorators.base.BiomeDecoratorBaseBetweenlands;
import thebetweenlands.world.biomes.feature.AlgaeNoiseFeature;
import thebetweenlands.world.biomes.feature.PatchyIslandNoiseFeature;
import thebetweenlands.world.biomes.feature.SiltNoiseFeature;
import thebetweenlands.world.biomes.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.TreeSpawnEntry;

public class BiomePatchyIslands
extends BiomeGenBaseBetweenlands {
    public BiomePatchyIslands(int biomeID) {
        this(biomeID, new BiomeDecoratorPatchyIslands());
    }

    public BiomePatchyIslands(int biomeID, BiomeDecoratorBaseBetweenlands decorator) {
        super(biomeID, decorator);
        this.setFogColor((byte)10, (byte)30, (byte)12);
        this.setColors(3231025, 3231025);
        this.setWeight(20);
        this.setHeightAndVariation(80, 3);
        this.func_76735_a("patchyIslands");
        this.setBlocks(BLBlockRegistry.betweenstone, BLBlockRegistry.swampDirt, BLBlockRegistry.swampGrass, BLBlockRegistry.mud, BLBlockRegistry.betweenlandsBedrock);
        this.setFillerBlockHeight((byte)1);
        this.addFeature(new PatchyIslandNoiseFeature()).addFeature(new SiltNoiseFeature()).addFeature(new AlgaeNoiseFeature());
        this.field_76759_H = 1589792;
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityDragonFly.class, 35).setGroupSize(1, 2).setSpawnCheckRadius(32.0).setSpawningInterval(400));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityFirefly.class, 20).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityMireSnail.class, 60).setGroupSize(1, 5).setSpawnCheckRadius(32.0).setSpawningInterval(800));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityFrog.class, 32).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(100));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityBlindCaveFish.class, 30).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityGecko.class, 40).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(600));
        this.blSpawnEntries.add(new TreeSpawnEntry(EntitySporeling.class, 80).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityLurker.class, 35).setHostile(true).setSpawnCheckRadius(16.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityAngler.class, 45).setHostile(true).setGroupSize(1, 3));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityAngler.class, 35).setHostile(true).setGroupSize(1, 3));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntitySwampHag.class, 50).setHostile(true));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntitySwampHag.class, 140).setHostile(true).setSpawnCheckRadius(6.0).setGroupSize(1, 3));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityWight.class, 12).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityWight.class, 18).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntitySiltCrab.class, 50).setHostile(true).setGroupSize(2, 8));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityBloodSnail.class, 30).setHostile(true));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityLeech.class, 35).setHostile(true));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityChiromaw.class, 12).setHostile(true).setSpawnCheckRadius(30.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityChiromaw.class, 40).setHostile(true).setSpawnCheckRadius(20.0).setGroupSize(1, 3));
        BiomeDictionary.registerBiomeType((BiomeGenBase)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER});
    }
}

