/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.mobs.EntityAngler;
import thebetweenlands.entities.mobs.EntityBlindCaveFish;
import thebetweenlands.entities.mobs.EntityChiromaw;
import thebetweenlands.entities.mobs.EntityFirefly;
import thebetweenlands.entities.mobs.EntityGasCloud;
import thebetweenlands.entities.mobs.EntityPeatMummy;
import thebetweenlands.entities.mobs.EntitySporeling;
import thebetweenlands.entities.mobs.EntitySwampHag;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.utils.FogGenerator;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.decorators.BiomeDecoratorMarsh;
import thebetweenlands.world.biomes.decorators.base.BiomeDecoratorBaseBetweenlands;
import thebetweenlands.world.biomes.feature.PatchNoiseFeature;
import thebetweenlands.world.biomes.feature.base.BiomeNoiseFeature;
import thebetweenlands.world.biomes.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.TreeSpawnEntry;

public class BiomeMarsh
extends BiomeGenBaseBetweenlands {
    private int[] recalculatedFogColor = new int[]{255, 255, 255};

    public BiomeMarsh(int biomeID, String name, BiomeNoiseFeature feature) {
        this(biomeID, new BiomeDecoratorMarsh(), feature, name);
    }

    public BiomeMarsh(int biomeID, BiomeDecoratorBaseBetweenlands decorator, BiomeNoiseFeature feature, String name) {
        super(biomeID, decorator);
        this.setFogColor((byte)10, (byte)30, (byte)12);
        this.setColors(3231025, 3231025);
        this.setWeight(10);
        this.setHeightAndVariation(70, 0);
        this.func_76735_a(name);
        this.setBlocks(BLBlockRegistry.betweenstone, BLBlockRegistry.swampDirt, BLBlockRegistry.swampGrass, BLBlockRegistry.mud, BLBlockRegistry.betweenlandsBedrock);
        this.setFillerBlockHeight((byte)1);
        this.addFeature(feature).addFeature(new PatchNoiseFeature(0.109375, 0.109375, BLBlockRegistry.peat)).addFeature(new PatchNoiseFeature(0.390625, 0.390625, BLBlockRegistry.peat)).addFeature(new PatchNoiseFeature(0.171875, 0.171875, BLBlockRegistry.mud)).addFeature(new PatchNoiseFeature(0.265625, 0.265625, BLBlockRegistry.mud));
        this.field_76759_H = 4742680;
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityFirefly.class, 20).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new TreeSpawnEntry(EntitySporeling.class, 80).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityBlindCaveFish.class, 30).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityWight.class, 4).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityWight.class, 14).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityPeatMummy.class, 12).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityChiromaw.class, 12).setHostile(true).setSpawnCheckRadius(30.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityChiromaw.class, 54).setHostile(true).setSpawnCheckRadius(20.0).setGroupSize(1, 3));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntitySwampHag.class, 140).setHostile(true).setSpawnCheckRadius(6.0).setGroupSize(1, 3));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityAngler.class, 35).setHostile(true).setGroupSize(1, 3));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityGasCloud.class, 8).setHostile(true).setSpawnCheckRadius(40.0).setGroupSize(1, 3));
        BiomeDictionary.registerBiomeType((BiomeGenBase)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getFogStart(float farPlaneDistance) {
        EntityLivingBase viewEntity = Minecraft.func_71410_x().field_71451_h;
        if (viewEntity.field_70163_u <= 70.0) {
            return super.getFogStart(farPlaneDistance);
        }
        float noise = FogGenerator.INSTANCE.getFogRange(viewEntity.field_70165_t, viewEntity.field_70161_v, farPlaneDistance, Minecraft.func_71410_x().field_71441_e.func_72905_C())[0];
        int[] targetFogColor = (int[])this.fogColorRGB.clone();
        float m = (50.0f - noise) / 5.0f;
        if (m < 0.0f) {
            m = 0.0f;
        } else if (m > 150.0f) {
            m = 150.0f;
        }
        for (int i = 0; i < 3; ++i) {
            int diff = 255 - targetFogColor[i];
            targetFogColor[i] = (byte)((double)targetFogColor[i] + (double)diff / 255.0 * (double)m);
        }
        this.recalculatedFogColor = targetFogColor;
        return noise;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getFogEnd(float farPlaneDistance) {
        EntityLivingBase viewEntity = Minecraft.func_71410_x().field_71451_h;
        if (viewEntity.field_70163_u <= 70.0) {
            return super.getFogEnd(farPlaneDistance);
        }
        return FogGenerator.INSTANCE.getFogRange(viewEntity.field_70165_t, viewEntity.field_70161_v, farPlaneDistance, Minecraft.func_71410_x().field_71441_e.func_72905_C())[1];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int[] getFogRGB() {
        EntityLivingBase viewEntity = Minecraft.func_71410_x().field_71451_h;
        if (viewEntity.field_70163_u <= 70.0) {
            return super.getFogRGB();
        }
        return this.recalculatedFogColor;
    }
}

