/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes;

import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.mobs.EntityAngler;
import thebetweenlands.entities.mobs.EntityBlindCaveFish;
import thebetweenlands.entities.mobs.EntityChiromaw;
import thebetweenlands.entities.mobs.EntityFirefly;
import thebetweenlands.entities.mobs.EntityLurker;
import thebetweenlands.entities.mobs.EntitySporeling;
import thebetweenlands.entities.mobs.EntitySwampHag;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.decorators.BiomeDecoratorDeepWaters;
import thebetweenlands.world.biomes.decorators.base.BiomeDecoratorBaseBetweenlands;
import thebetweenlands.world.biomes.feature.AlgaeNoiseFeature;
import thebetweenlands.world.biomes.feature.CragSpiresNoiseFeature;
import thebetweenlands.world.biomes.feature.DeepWaterNoiseFeature;
import thebetweenlands.world.biomes.feature.SiltNoiseFeature;
import thebetweenlands.world.biomes.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.TreeSpawnEntry;

public class BiomeDeepWaters
extends BiomeGenBaseBetweenlands {
    public BiomeDeepWaters(int biomeID) {
        this(biomeID, new BiomeDecoratorDeepWaters());
    }

    public BiomeDeepWaters(int biomeID, BiomeDecoratorBaseBetweenlands decorator) {
        super(biomeID, decorator);
        this.setFogColor((byte)10, (byte)30, (byte)12);
        this.setColors(3231025, 3231025);
        this.setWeight(15);
        this.setHeightAndVariation(60, 10);
        this.func_76735_a("deepWaters");
        this.setBlocks(BLBlockRegistry.betweenstone, BLBlockRegistry.swampDirt, BLBlockRegistry.swampGrass, BLBlockRegistry.mud, BLBlockRegistry.betweenlandsBedrock);
        this.setFillerBlockHeight((byte)5);
        this.field_76759_H = 1784132;
        this.addFeature(new DeepWaterNoiseFeature()).addFeature(new SiltNoiseFeature()).addFeature(new AlgaeNoiseFeature()).addFeature(new CragSpiresNoiseFeature());
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityFirefly.class, 10).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new TreeSpawnEntry(EntitySporeling.class, 80).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityBlindCaveFish.class, 30).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityLurker.class, 35).setHostile(true).setSpawnCheckRadius(16.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityAngler.class, 45).setHostile(true).setGroupSize(1, 3));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityAngler.class, 35).setHostile(true).setGroupSize(1, 3));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntitySwampHag.class, 140).setHostile(true).setSpawnCheckRadius(6.0).setGroupSize(1, 3));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityWight.class, 18).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityChiromaw.class, 30).setHostile(true).setSpawnCheckRadius(20.0).setGroupSize(1, 3));
        BiomeDictionary.registerBiomeType((BiomeGenBase)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WATER});
    }
}

