/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world.biomes;

import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.entities.mobs.EntityAngler;
import thebetweenlands.entities.mobs.EntityBlindCaveFish;
import thebetweenlands.entities.mobs.EntityChiromaw;
import thebetweenlands.entities.mobs.EntityDragonFly;
import thebetweenlands.entities.mobs.EntityFirefly;
import thebetweenlands.entities.mobs.EntityFrog;
import thebetweenlands.entities.mobs.EntityGecko;
import thebetweenlands.entities.mobs.EntityLurker;
import thebetweenlands.entities.mobs.EntitySporeling;
import thebetweenlands.entities.mobs.EntitySwampHag;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.biomes.decorators.BiomeDecoratorCoarseIslands;
import thebetweenlands.world.biomes.decorators.base.BiomeDecoratorBaseBetweenlands;
import thebetweenlands.world.biomes.feature.AlgaeNoiseFeature;
import thebetweenlands.world.biomes.feature.CoarseIslandNoiseFeature;
import thebetweenlands.world.biomes.feature.SiltNoiseFeature;
import thebetweenlands.world.biomes.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.world.biomes.spawning.spawners.TreeSpawnEntry;

public class BiomeCoarseIslands
extends BiomeGenBaseBetweenlands {
    public BiomeCoarseIslands(int biomeID) {
        this(biomeID, new BiomeDecoratorCoarseIslands());
    }

    public BiomeCoarseIslands(int biomeID, BiomeDecoratorBaseBetweenlands decorator) {
        super(biomeID, decorator);
        this.setFogColor((byte)10, (byte)30, (byte)12);
        this.setColors(3231025, 3231025);
        this.setWeight(15);
        this.setHeightAndVariation(70, 0);
        this.func_76735_a("coarseIslands");
        this.setBlocks(BLBlockRegistry.betweenstone, BLBlockRegistry.swampDirt, BLBlockRegistry.swampGrass, BLBlockRegistry.mud, BLBlockRegistry.betweenlandsBedrock);
        this.setFillerBlockHeight((byte)1);
        this.addFeature(new CoarseIslandNoiseFeature()).addFeature(new SiltNoiseFeature()).addFeature(new AlgaeNoiseFeature());
        this.field_76759_H = 1784132;
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityDragonFly.class, 36).setGroupSize(1, 2).setSpawnCheckRadius(32.0).setSpawningInterval(400));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityFirefly.class, 25).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityGecko.class, 52).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(600));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityFrog.class, 30).setCanSpawnOnWater(true).setGroupSize(1, 3).setSpawnCheckRadius(32.0).setSpawningInterval(100));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityBlindCaveFish.class, 30).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new TreeSpawnEntry(EntitySporeling.class, 80).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityLurker.class, 32).setHostile(true).setSpawnCheckRadius(16.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityAngler.class, 42).setHostile(true).setGroupSize(1, 3));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityAngler.class, 35).setHostile(true).setGroupSize(1, 3));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntitySwampHag.class, 50).setHostile(true));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntitySwampHag.class, 140).setHostile(true).setSpawnCheckRadius(6.0).setGroupSize(1, 3));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityWight.class, 12).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityWight.class, 18).setHostile(true).setSpawnCheckRadius(64.0));
        this.blSpawnEntries.add(new SurfaceSpawnEntry(EntityChiromaw.class, 12).setHostile(true).setSpawnCheckRadius(30.0));
        this.blSpawnEntries.add(new CaveSpawnEntry(EntityChiromaw.class, 40).setHostile(true).setSpawnCheckRadius(20.0).setGroupSize(1, 3));
        BiomeDictionary.registerBiomeType((BiomeGenBase)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER});
    }
}

