/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.sky.BLSkyRenderer;
import thebetweenlands.event.render.FogHandler;
import thebetweenlands.lib.ModInfo;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.ChunkProviderBetweenlands;
import thebetweenlands.world.WorldChunkManagerBetweenlands;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.events.EnvironmentEventRegistry;
import thebetweenlands.world.storage.chunk.storage.location.LocationAmbience;
import thebetweenlands.world.storage.chunk.storage.location.LocationStorage;
import thebetweenlands.world.storage.world.BetweenlandsWorldData;

public class WorldProviderBetweenlands
extends WorldProvider {
    public static final int LAYER_HEIGHT = 80;
    public static final int CAVE_WATER_HEIGHT = 20;
    public static final int PITSTONE_HEIGHT = 34;
    public static final int CAVE_START = 70;
    @SideOnly(value=Side.CLIENT)
    private double[] currentFogColor;
    @SideOnly(value=Side.CLIENT)
    private double[] lastFogColor;
    private boolean allowHostiles;
    private boolean allowAnimals;
    public float[] originalLightBrightnessTable = new float[16];
    private BetweenlandsWorldData worldData;

    public WorldProviderBetweenlands() {
        this.field_76576_e = true;
    }

    public boolean func_76567_e() {
        return true;
    }

    public boolean func_76566_a(int x, int z) {
        return true;
    }

    public float func_76563_a(long worldTime, float partialTickTime) {
        return 0.35f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float partialTicks) {
        return 0.2f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float celestialAngle, float partialTickTime) {
        if (this.currentFogColor == null || this.lastFogColor == null) {
            this.initFogColors((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
        double r = this.currentFogColor[0] + (this.currentFogColor[0] - this.lastFogColor[0]) * (double)partialTickTime;
        double g = this.currentFogColor[1] + (this.currentFogColor[1] - this.lastFogColor[1]) * (double)partialTickTime;
        double b = this.currentFogColor[2] + (this.currentFogColor[2] - this.lastFogColor[2]) * (double)partialTickTime;
        return Vec3.func_72443_a((double)(r / 255.0), (double)(g / 255.0), (double)(b / 255.0));
    }

    protected void func_76556_a() {
        float minBrightness = (float)((double)1.0E-7f * Math.pow(ConfigHandler.DIMENSION_BRIGHTNESS, 3.2f) + (double)0.002f);
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)(i * i) / 225.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 6.0f + 1.0f) * (1.0f - minBrightness) + minBrightness;
        }
        System.arraycopy(this.field_76573_f, 0, this.originalLightBrightnessTable, 0, 16);
    }

    public void func_76572_b() {
        this.field_76578_c = new WorldChunkManagerBetweenlands(this.field_76579_a);
        this.field_76574_g = ModInfo.DIMENSION_ID;
    }

    public IChunkProvider func_76555_c() {
        return new ChunkProviderBetweenlands(this.field_76579_a, this.field_76579_a.func_72905_C(), BLBlockRegistry.betweenstone, BLBlockRegistry.swampWater, 80);
    }

    public boolean func_76569_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return true;
    }

    public void setAllowedSpawnTypes(boolean allowHostiles, boolean allowAnimals) {
        this.allowHostiles = allowHostiles;
        this.allowAnimals = allowAnimals;
        super.setAllowedSpawnTypes(allowHostiles, allowAnimals);
    }

    public boolean getCanSpawnHostiles() {
        return this.allowHostiles;
    }

    public boolean getCanSpawnAnimals() {
        return this.allowAnimals;
    }

    public String func_80007_l() {
        return "Betweenlands";
    }

    public ChunkCoordinates getRandomizedSpawnPoint() {
        ChunkCoordinates chunkcoordinates = new ChunkCoordinates(this.field_76579_a.func_72861_E());
        boolean isAdventure = this.field_76579_a.func_72912_H().func_76077_q() == WorldSettings.GameType.ADVENTURE;
        int spawnFuzz = 100;
        int spawnFuzzHalf = spawnFuzz / 2;
        if (!isAdventure) {
            chunkcoordinates.field_71574_a += this.field_76579_a.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf;
            chunkcoordinates.field_71573_c += this.field_76579_a.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf;
            chunkcoordinates.field_71572_b = this.field_76579_a.func_72825_h(chunkcoordinates.field_71574_a, chunkcoordinates.field_71573_c);
        }
        return chunkcoordinates;
    }

    public BetweenlandsWorldData getWorldData() {
        if (this.worldData == null) {
            this.worldData = BetweenlandsWorldData.forWorld(this.field_76579_a);
        }
        return this.worldData;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }

    public void updateWeather() {
        EnvironmentEventRegistry eeRegistry = this.getWorldData().getEnvironmentEventRegistry();
        this.field_76579_a.func_72912_H().func_76084_b(eeRegistry.HEAVY_RAIN.isActive());
        this.field_76579_a.func_72912_H().func_76069_a(false);
        this.field_76579_a.field_73003_n = this.field_76579_a.field_73004_o;
        if (!this.field_76579_a.field_72995_K) {
            float rainingStrength = this.field_76579_a.field_73004_o;
            if (eeRegistry.HEAVY_RAIN.isActive()) {
                if (rainingStrength < 0.5f) {
                    rainingStrength += 0.0125f;
                }
                if (rainingStrength > 0.5f) {
                    rainingStrength = 0.5f;
                }
            } else {
                if (rainingStrength > 0.0f) {
                    rainingStrength -= 0.0125f;
                }
                if (rainingStrength < 0.0f) {
                    rainingStrength = 0.0f;
                }
            }
            this.field_76579_a.field_73004_o = rainingStrength;
        } else {
            this.updateFogColors();
        }
    }

    private int[] getTargetFogColor(EntityPlayer player) {
        BiomeGenBase biome = this.field_76579_a.func_72807_a((int)player.field_70165_t, (int)player.field_70161_v);
        int[] targetFogColor = biome instanceof BiomeGenBaseBetweenlands ? (int[])((BiomeGenBaseBetweenlands)biome).getFogRGB().clone() : new int[]{255, 255, 255};
        if (!ShaderHelper.INSTANCE.isWorldShaderActive()) {
            if (WorldProviderBetweenlands.getProvider((World)this.field_76579_a).getEnvironmentEventRegistry().BLOODSKY.isActive()) {
                targetFogColor = new int[]{188, 45, 20};
            } else if (WorldProviderBetweenlands.getProvider((World)this.field_76579_a).getEnvironmentEventRegistry().SPOOPY.isActive()) {
                targetFogColor = new int[]{102, 56, 20};
            }
        }
        return targetFogColor;
    }

    private void initFogColors(EntityPlayer player) {
        int i;
        int[] targetFogColor = this.getTargetFogColor(player);
        if (this.currentFogColor == null) {
            this.currentFogColor = new double[3];
            for (i = 0; i < 3; ++i) {
                this.currentFogColor[i] = targetFogColor[i];
            }
        }
        if (this.lastFogColor == null) {
            this.lastFogColor = new double[3];
        } else {
            for (i = 0; i < 3; ++i) {
                this.lastFogColor[i] = this.currentFogColor[i];
            }
        }
    }

    private void updateFogColors() {
        int diff;
        int i;
        LocationAmbience ambience;
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (player == null) {
            return;
        }
        this.initFogColors(player);
        int[] targetFogColor = this.getTargetFogColor(player);
        int transitionStart = 70;
        int transitionEnd = 55;
        float m = 0.0f;
        if (FogHandler.INSTANCE.hasDenseFog()) {
            float y = (float)player.field_70163_u;
            if (y < 70.0f) {
                if (55.0f < y) {
                    m = (y - 55.0f) / 15.0f * 80.0f;
                }
            } else {
                m = 80.0f;
            }
        }
        if ((ambience = LocationStorage.getAmbience((Entity)player)) != null && ambience.hasFogBrightness()) {
            m = ambience.getFogBrightness();
        }
        if (!ShaderHelper.INSTANCE.isWorldShaderActive() && (WorldProviderBetweenlands.getProvider((World)this.field_76579_a).getEnvironmentEventRegistry().BLOODSKY.isActive() || WorldProviderBetweenlands.getProvider((World)this.field_76579_a).getEnvironmentEventRegistry().SPOOPY.isActive())) {
            m = 0.0f;
        }
        if (ambience != null && ambience.hasFogColor()) {
            for (i = 0; i < 3; ++i) {
                diff = 255 - ambience.getFogColor()[i];
                targetFogColor[i] = (int)((double)ambience.getFogColor()[i] + (double)diff / 255.0 * (double)m);
            }
        } else {
            for (i = 0; i < 3; ++i) {
                diff = 255 - targetFogColor[i];
                targetFogColor[i] = (int)((double)targetFogColor[i] + (double)diff / 255.0 * (double)m);
            }
        }
        for (int a = 0; a < 3; ++a) {
            if (this.currentFogColor[a] == (double)targetFogColor[a]) continue;
            if (this.currentFogColor[a] < (double)targetFogColor[a]) {
                int n = a;
                this.currentFogColor[n] = this.currentFogColor[n] + 0.2;
                if (!(this.currentFogColor[a] > (double)targetFogColor[a])) continue;
                this.currentFogColor[a] = targetFogColor[a];
                continue;
            }
            if (!(this.currentFogColor[a] > (double)targetFogColor[a])) continue;
            int n = a;
            this.currentFogColor[n] = this.currentFogColor[n] - 0.2;
            if (!(this.currentFogColor[a] < (double)targetFogColor[a])) continue;
            this.currentFogColor[a] = targetFogColor[a];
        }
    }

    public void calculateInitialWeather() {
        EnvironmentEventRegistry eeRegistry = this.getWorldData().getEnvironmentEventRegistry();
        this.field_76579_a.func_72912_H().func_76084_b(eeRegistry.HEAVY_RAIN.isActive());
        this.field_76579_a.func_72912_H().func_76069_a(false);
        super.calculateInitialWeather();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return BLSkyRenderer.INSTANCE;
    }

    public EnvironmentEventRegistry getEnvironmentEventRegistry() {
        return this.getWorldData().getEnvironmentEventRegistry();
    }

    public static final WorldProviderBetweenlands getProvider(World world) {
        if (world != null && world.field_73011_w instanceof WorldProviderBetweenlands) {
            return (WorldProviderBetweenlands)world.field_73011_w;
        }
        return null;
    }
}

