/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.world;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import thebetweenlands.world.biomes.WorldGenRedirect;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;
import thebetweenlands.world.feature.structure.WorldGenTarPoolDungeons;
import thebetweenlands.world.gen.MapGenCavesBetweenlands;

public class ChunkProviderBetweenlands
implements IChunkProvider {
    private World worldObj;
    private Random rand;
    private NoiseGeneratorOctaves baseNoiseOctave;
    private NoiseGeneratorOctaves noiseOctave1;
    private NoiseGeneratorOctaves noiseOctave2;
    private NoiseGeneratorOctaves noiseOctave3;
    private NoiseGeneratorPerlin baseBlockPatchNoiseGen;
    private double[] baseBlockPatchNoise = new double[256];
    private double[] noiseXZ;
    double[] noise1;
    double[] noise2;
    double[] clampNoise;
    double[] baseNoise;
    private float[] parabolicField;
    private BiomeGenBase[] biomesForGeneration;
    public final Block baseBlock;
    public final Block layerBlock;
    private final int layerHeight;
    private MapGenBase caveGenerator;
    private NoiseGeneratorSimplex treeNoise;
    private NoiseGeneratorSimplex speleothemDensityNoise;
    private WorldGenRedirect biomeDecorator = new WorldGenRedirect();
    private List<BiomeGenBaseBetweenlands> biomeGenList = new ArrayList<BiomeGenBaseBetweenlands>();

    public ChunkProviderBetweenlands(World world, long seed, Block baseBlock, Block layerBlock, int layerHeight) {
        this.worldObj = world;
        this.baseBlock = baseBlock;
        this.layerBlock = layerBlock;
        this.layerHeight = layerHeight;
        this.initializeNoiseGen(seed);
        this.caveGenerator = new MapGenCavesBetweenlands(seed);
    }

    public void func_82695_e(int x, int z) {
    }

    public List func_73155_a(EnumCreatureType creatureType, int x, int y, int z) {
        BiomeGenBase biome = this.worldObj.func_72807_a(x, z);
        return biome == null ? null : biome.func_76747_a(creatureType);
    }

    public String func_73148_d() {
        return "";
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public boolean func_73151_a(boolean mode, IProgressUpdate progressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public int func_73152_e() {
        return 0;
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }

    public ChunkPosition func_147416_a(World world, String structureIdentifier, int x, int y, int z) {
        return null;
    }

    public Chunk func_73154_d(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        Block[] chunkBlocks = new Block[65536];
        byte[] blockMeta = new byte[65536];
        this.generateBaseTerrain(x, z, chunkBlocks);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, this.rand, chunkBlocks, blockMeta, this.biomesForGeneration);
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, x, z, chunkBlocks);
        ArrayList<BiomeGenBaseBetweenlands> uniqueBiomes = new ArrayList<BiomeGenBaseBetweenlands>();
        for (BiomeGenBase biome : this.biomesForGeneration) {
            if (uniqueBiomes.contains(biome) || !(biome instanceof BiomeGenBaseBetweenlands)) continue;
            uniqueBiomes.add((BiomeGenBaseBetweenlands)biome);
        }
        for (BiomeGenBaseBetweenlands biome : uniqueBiomes) {
            this.rand.setSeed(this.worldObj.func_72905_C());
            this.rand.setSeed((long)x * (this.rand.nextLong() / 2L * 2L + 1L) + (long)z * (this.rand.nextLong() / 2L * 2L + 1L) ^ this.worldObj.func_72905_C());
            biome.preChunkProvide(this.worldObj, this.rand, x, z, chunkBlocks, blockMeta, this.biomesForGeneration);
        }
        Chunk chunk = new Chunk(this.worldObj, chunkBlocks, blockMeta, x, z);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int k = 0; k < chunkBiomes.length; ++k) {
            chunkBiomes[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public void func_73153_a(IChunkProvider cp, int x, int z) {
        BlockFalling.field_149832_M = true;
        int blockX = x * 16;
        int blockZ = z * 16;
        this.rand.setSeed(this.worldObj.func_72905_C());
        this.rand.setSeed((long)x * (this.rand.nextLong() / 2L * 2L + 1L) + (long)z * (this.rand.nextLong() / 2L * 2L + 1L) ^ this.worldObj.func_72905_C());
        BiomeGenBase biome = this.worldObj.func_72807_a(blockX + 16, blockZ + 16);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(cp, this.worldObj, this.rand, x, z, false));
        if (biome instanceof BiomeGenBaseBetweenlands) {
            BiomeGenBaseBetweenlands bgbb = (BiomeGenBaseBetweenlands)biome;
            bgbb.postChunkPopulate(this.worldObj, this.rand, blockX, blockZ);
        } else {
            biome.func_76728_a(this.worldObj, this.rand, blockX, blockZ);
        }
        for (int attempt = 0; attempt < 3; ++attempt) {
            new WorldGenTarPoolDungeons().func_76484_a(this.worldObj, this.rand, blockX + this.rand.nextInt(16) + 8, this.rand.nextInt(70) + 10, blockZ + this.rand.nextInt(16) + 8);
        }
        BlockFalling.field_149832_M = false;
        if (TerrainGen.populate((IChunkProvider)cp, (World)this.worldObj, (Random)this.rand, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biome, (int)(blockX + 8), (int)(blockZ + 8), (int)16, (int)16, (Random)this.rand);
        }
        this.biomeDecorator.generate(this.rand, x, z, this.worldObj, cp, this.worldObj.func_72863_F());
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(cp, this.worldObj, this.rand, x, z, false));
    }

    private void initializeNoiseGen(long seed) {
        this.rand = new Random(seed);
        this.baseNoiseOctave = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseOctave1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseOctave2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseOctave3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.baseBlockPatchNoiseGen = new NoiseGeneratorPerlin(this.rand, 4);
        this.noiseXZ = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
        this.treeNoise = new NoiseGeneratorSimplex(this.rand);
        this.speleothemDensityNoise = new NoiseGeneratorSimplex(this.rand);
    }

    private void generateNoiseXZStack(double[] noiseArray, int x, int z, int cx, int cz) {
        this.generateNoiseXZStackOld(noiseArray, x, z, cx, cz);
    }

    @Deprecated
    private void generateNoiseXZStackOld(double[] noiseArray, int x, int z, int cx, int cz) {
        double noiseScale = 1200.0;
        double yNoiseScale = 684.412 / noiseScale;
        this.baseNoise = this.baseNoiseOctave.func_76305_a(this.baseNoise, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.noise1 = this.noiseOctave1.func_76304_a(this.noise1, x, 0, z, 5, 33, 5, noiseScale, yNoiseScale, noiseScale);
        this.noise2 = this.noiseOctave2.func_76304_a(this.noise2, x, 0, z, 5, 33, 5, noiseScale, yNoiseScale, noiseScale);
        this.clampNoise = this.noiseOctave3.func_76304_a(this.clampNoise, x, 0, z, 5, 33, 5, noiseScale / 80.0, yNoiseScale / 160.0, noiseScale / 80.0);
        int noiseIndex = 0;
        int baseNoiseIndex = 0;
        for (int bxo = 0; bxo < 5; ++bxo) {
            for (int bzo = 0; bzo < 5; ++bzo) {
                float averageHeightVariation = 0.0f;
                float averageRootHeight = 0.0f;
                float averageHeightGradient = 0.0f;
                BiomeGenBase currentBiome = this.biomesForGeneration[bxo + 2 + (bzo + 2) * 10];
                float currentBiomeRootHeight = currentBiome.field_76748_D;
                for (int sbbxo = -2; sbbxo <= 2; ++sbbxo) {
                    for (int sbbzo = -2; sbbzo <= 2; ++sbbzo) {
                        BiomeGenBase surroundingBiome = this.biomesForGeneration[bxo + sbbxo + 2 + (bzo + sbbzo + 2) * 10];
                        float surroundingBiomeRootHeight = surroundingBiome.field_76748_D;
                        float surroundingBiomeHeightVariation = surroundingBiome.field_76749_E;
                        float heightGradient = this.parabolicField[sbbxo + 2 + (sbbzo + 2) * 5] / (surroundingBiomeRootHeight + 2.0f);
                        if (surroundingBiomeRootHeight > currentBiomeRootHeight) {
                            heightGradient /= 2.0f;
                        }
                        averageHeightVariation += surroundingBiomeHeightVariation * heightGradient;
                        averageRootHeight += surroundingBiomeRootHeight * heightGradient;
                        averageHeightGradient += heightGradient;
                    }
                }
                averageHeightVariation /= averageHeightGradient;
                averageRootHeight /= averageHeightGradient;
                averageHeightVariation = averageHeightVariation * 0.9f + 0.1f;
                averageRootHeight = (averageRootHeight * 4.0f - 1.0f) / 8.0f;
                double fineBaseNoise = this.baseNoise[baseNoiseIndex] / 8000.0;
                if (fineBaseNoise < 0.0) {
                    fineBaseNoise = -fineBaseNoise * 0.3;
                }
                if ((fineBaseNoise = fineBaseNoise * 3.0 - 2.0) < 0.0) {
                    if ((fineBaseNoise /= 2.0) < -1.0) {
                        fineBaseNoise = -1.0;
                    }
                    fineBaseNoise /= 1.4;
                    fineBaseNoise /= 2.0;
                } else {
                    if (fineBaseNoise > 1.0) {
                        fineBaseNoise = 1.0;
                    }
                    fineBaseNoise /= 8.0;
                }
                ++baseNoiseIndex;
                double cAvgRootHeight = averageRootHeight;
                double cAvgHeightVariation = averageHeightVariation;
                cAvgRootHeight += fineBaseNoise * 0.2;
                cAvgRootHeight = cAvgRootHeight * 8.5 / 8.0;
                cAvgRootHeight = 8.5 + cAvgRootHeight * 4.0;
                for (int byo = 0; byo < 33; ++byo) {
                    double heightLimiterNoise = ((double)byo - cAvgRootHeight) * 12.0 * 128.0 / 256.0 / cAvgHeightVariation;
                    if (heightLimiterNoise < 0.0) {
                        heightLimiterNoise *= 4.0;
                    }
                    double octaveNoise1 = this.noise1[noiseIndex] / 512.0;
                    double octaveNoise2 = this.noise2[noiseIndex] / 512.0;
                    double octaveNoise3 = (this.clampNoise[noiseIndex] / 10.0 + 1.0) / 2.0;
                    double finalNoise = MathHelper.func_151238_b((double)octaveNoise1, (double)octaveNoise2, (double)octaveNoise3) - heightLimiterNoise;
                    if (byo > 29) {
                        double d11 = (float)(byo - 29) / 3.0f;
                        finalNoise = finalNoise * (1.0 - d11) + -10.0 * d11;
                    }
                    noiseArray[noiseIndex] = finalNoise;
                    ++noiseIndex;
                }
            }
        }
    }

    private void generateBaseTerrain(int x, int z, Block[] chunkBlocks) {
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
        this.biomeGenList.clear();
        this.generateNoiseXZStack(this.noiseXZ, x * 4, z * 4, x, z);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double noiseVariationFactor = 0.125;
                    double mainNoise1 = this.noiseXZ[k1 + k2];
                    double mainNoise2 = this.noiseXZ[l1 + k2];
                    double mainNoise3 = this.noiseXZ[i2 + k2];
                    double mainNoise4 = this.noiseXZ[j2 + k2];
                    double fineNoise1 = (this.noiseXZ[k1 + k2 + 1] - mainNoise1) * noiseVariationFactor;
                    double fineNoise2 = (this.noiseXZ[l1 + k2 + 1] - mainNoise2) * noiseVariationFactor;
                    double fineNoise3 = (this.noiseXZ[i2 + k2 + 1] - mainNoise3) * noiseVariationFactor;
                    double fineNoise4 = (this.noiseXZ[j2 + k2 + 1] - mainNoise4) * noiseVariationFactor;
                    for (int subOctaveIT = 0; subOctaveIT < 8; ++subOctaveIT) {
                        double subNoiseVariationFactor = 0.25;
                        double mainSubNoise1 = mainNoise1;
                        double mainSubNoise2 = mainNoise2;
                        double fineSubNoise1 = (mainNoise3 - mainNoise1) * subNoiseVariationFactor;
                        double fineSubNoise2 = (mainNoise4 - mainNoise2) * subNoiseVariationFactor;
                        for (int subSubOctaveIT = 0; subSubOctaveIT < 4; ++subSubOctaveIT) {
                            int cHeight = subSubOctaveIT + k * 4 << 12 | j1 * 4 << 8 | k2 * 8 + subOctaveIT;
                            int maxHeight = 256;
                            cHeight -= maxHeight;
                            double subSubNoiseVariationFactor = 0.25;
                            double fineSubSubNoise = (mainSubNoise2 - mainSubNoise1) * subSubNoiseVariationFactor;
                            double mainSubSubNoise = mainSubNoise1 - fineSubSubNoise;
                            for (int fillWidth = 0; fillWidth < 4; ++fillWidth) {
                                double d;
                                mainSubSubNoise += fineSubSubNoise;
                                chunkBlocks[cHeight += maxHeight] = d > 0.0 ? this.baseBlock : (k2 * 8 + subOctaveIT <= this.layerHeight ? this.layerBlock : null);
                            }
                            mainSubNoise1 += fineSubNoise1;
                            mainSubNoise2 += fineSubNoise2;
                        }
                        mainNoise1 += fineNoise1;
                        mainNoise2 += fineNoise2;
                        mainNoise3 += fineNoise3;
                        mainNoise4 += fineNoise4;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, Random rng, Block[] chunkBlocks, byte[] blockMeta, BiomeGenBase[] biomesForGeneration) {
        double baseBlockNoiseVariationFactor = 0.03125;
        this.baseBlockPatchNoise = this.baseBlockPatchNoiseGen.func_151599_a(this.baseBlockPatchNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, baseBlockNoiseVariationFactor * 2.0, baseBlockNoiseVariationFactor * 2.0, 1.0);
        this.biomeGenList.clear();
        for (int bx = 0; bx < 16; ++bx) {
            for (int bz = 0; bz < 16; ++bz) {
                BiomeGenBase biome = biomesForGeneration[bz + bx * 16];
                if (!(biome instanceof BiomeGenBaseBetweenlands)) {
                    biome.func_150573_a(this.worldObj, this.rand, chunkBlocks, blockMeta, chunkX * 16 + bx, chunkZ * 16 + bz, this.baseBlockPatchNoise[bz + bx * 16]);
                    continue;
                }
                BiomeGenBaseBetweenlands bgbb = (BiomeGenBaseBetweenlands)biome;
                if (!this.biomeGenList.contains(bgbb)) {
                    this.biomeGenList.add(bgbb);
                    if (!bgbb.isNoiseGenInitialized()) {
                        bgbb.initializeNoiseGen(new Random(this.worldObj.func_72905_C()));
                    }
                    bgbb.generateNoise(chunkX, chunkZ);
                }
                bgbb.replaceStackBlocks(chunkX * 16 + bx, chunkZ * 16 + bz, bx, bz, this.baseBlockPatchNoise[bz + bx * 16], rng, chunkBlocks, blockMeta, this, biomesForGeneration, this.worldObj);
            }
        }
    }

    public double evalTreeNoise(double x, double z) {
        return this.treeNoise.func_151605_a(x, z);
    }

    public double evalSpeleothemDensityNoise(double x, double z) {
        return this.speleothemDensityNoise.func_151605_a(x, z);
    }
}

