/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils.vectormath;

import thebetweenlands.utils.mc.Vec3i;
import thebetweenlands.utils.vectormath.Tuple3f;

public class Vector3f
extends Tuple3f {
    public Vector3f() {
    }

    public Vector3f(Vec3i vec) {
        super(vec.getX(), vec.getY(), vec.getZ());
    }

    public Vector3f(float x, float y, float z) {
        super(x, y, z);
    }

    public Vector3f(float[] xyz) {
        super(xyz[0], xyz[1], xyz[2]);
    }

    public Vector3f(Tuple3f t1) {
        super(t1);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3f normalize() {
        float length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    public void add(Vector3f other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
    }

    public float dot(Vector3f other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public String toString() {
        return "Vector3f [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

