/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils.pool;

import java.util.ArrayList;
import java.util.List;
import thebetweenlands.utils.pool.InstanceProvider;

public class Pool<T> {
    private InstanceProvider<T> instanceProvider;
    private int size;
    private List<T> instances;

    public Pool(InstanceProvider<T> instanceProvider, int size) {
        this.instanceProvider = instanceProvider;
        this.size = size;
        this.instances = new ArrayList<T>();
    }

    public T getInstance() {
        if (this.instances.isEmpty()) {
            return this.instanceProvider.newInstance();
        }
        return this.instances.remove(0);
    }

    public void freeInstance(T instance) {
        if (this.instances.size() < this.size) {
            this.instances.add(instance);
        }
    }
}

