/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils;

import java.util.ArrayList;
import java.util.Random;
import thebetweenlands.utils.IWeightProvider;

public class WeightedList<T extends IWeightProvider>
extends ArrayList<T> {
    private static final long serialVersionUID = 9036828805904893875L;
    private int totalWeight = 0;

    @Override
    public boolean add(T obj) {
        boolean b = super.add(obj);
        this.recalculateWeight();
        return b;
    }

    @Override
    public T remove(int index) {
        IWeightProvider is = (IWeightProvider)super.remove(index);
        this.recalculateWeight();
        return (T)is;
    }

    @Override
    public boolean remove(Object o) {
        boolean b = super.remove(o);
        this.recalculateWeight();
        return b;
    }

    public void recalculateWeight() {
        this.totalWeight = 0;
        for (IWeightProvider obj : this) {
            this.totalWeight += obj.getWeight();
        }
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    public T getRandomItem(Random rand) {
        if (this.totalWeight == 0) {
            return null;
        }
        int i = rand.nextInt(this.totalWeight);
        for (IWeightProvider obj : this) {
            if ((i -= obj.getWeight()) >= 0) continue;
            return (T)obj;
        }
        return null;
    }

    public T getRandomItem(int weight) {
        if (this.totalWeight == 0) {
            return null;
        }
        for (IWeightProvider obj : this) {
            if ((weight -= obj.getWeight()) >= 0) continue;
            return (T)obj;
        }
        return null;
    }
}

