/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public class ObjectUtils {
    public static String toString(Object o) {
        try {
            Class<?> clazz = o.getClass();
            ArrayList<Field> allFields = new ArrayList<Field>();
            Class<?> currentClass = clazz;
            do {
                for (Field field : currentClass.getDeclaredFields()) {
                    if ((field.getModifiers() & 8) != 0) continue;
                    field.setAccessible(true);
                    allFields.add(field);
                }
            } while ((currentClass = currentClass.getSuperclass()) != null);
            if (allFields.size() == 0) {
                return o.toString();
            }
            StringBuilder stringBuilder = new StringBuilder(clazz.getSimpleName());
            stringBuilder.append('[');
            Collections.sort(allFields, new Comparator<Field>(){

                @Override
                public int compare(Field a, Field b) {
                    return a.getName().compareTo(b.getName());
                }
            });
            int fieldCount = allFields.size();
            for (int i = 0; i < fieldCount; ++i) {
                String valueString;
                Field field;
                field = (Field)allFields.get(i);
                Object value = field.get(o);
                if (value == null) {
                    valueString = "null";
                } else {
                    Class<?> valueClass = value.getClass();
                    Method[] declaredMethods = valueClass.getDeclaredMethods();
                    boolean allGood = true;
                    for (Method method : declaredMethods) {
                        if (!method.getName().equals("toString") || (method.getModifiers() & 0x400) == 0) continue;
                        allGood = false;
                        break;
                    }
                    valueString = allGood ? (valueClass.isArray() ? ObjectUtils.arrayToString(value) : value.toString()) : "<abstract>";
                }
                stringBuilder.append(field.getName());
                stringBuilder.append('=');
                stringBuilder.append(valueString);
                if (i >= fieldCount - 1) continue;
                stringBuilder.append(", ");
            }
            return stringBuilder.append(']').toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return o.toString();
        }
    }

    public static String arrayToString(Object object) {
        Class<?> componentType = object.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            if (Boolean.TYPE.isAssignableFrom(componentType)) {
                return Arrays.toString((boolean[])object);
            }
            if (Byte.TYPE.isAssignableFrom(componentType)) {
                return Arrays.toString((byte[])object);
            }
            if (Character.TYPE.isAssignableFrom(componentType)) {
                return Arrays.toString((char[])object);
            }
            if (Double.TYPE.isAssignableFrom(componentType)) {
                return Arrays.toString((double[])object);
            }
            if (Float.TYPE.isAssignableFrom(componentType)) {
                return Arrays.toString((float[])object);
            }
            if (Integer.TYPE.isAssignableFrom(componentType)) {
                return Arrays.toString((int[])object);
            }
            if (Long.TYPE.isAssignableFrom(componentType)) {
                return Arrays.toString((long[])object);
            }
            if (Short.TYPE.isAssignableFrom(componentType)) {
                return Arrays.toString((short[])object);
            }
        }
        return object.toString();
    }
}

