/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemRenderHelper {
    private static final ResourceLocation GLINT_PNG = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected static RenderItem itemRender = new RenderItem();
    protected static RenderBlocks renderBlocksRi = new RenderBlocks();

    public static void drawItemStack(ItemStack stack, int x, int y, String text, boolean withColor) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        ItemRenderHelper.itemRender.field_77024_a = withColor;
        itemRender.func_82406_b(font, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
        itemRender.func_94148_a(font, Minecraft.func_71410_x().func_110434_K(), stack, x, y, text);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.func_74518_a();
    }

    public static void renderItem(ItemStack item, int renderPass) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.0625);
        if (!(item.func_77973_b() instanceof ItemBlock)) {
            GL11.glRotatef((float)-335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        RenderManager.field_78727_a.field_78721_f.renderItem((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, item, renderPass, IItemRenderer.ItemRenderType.ENTITY);
        GL11.glPopMatrix();
    }

    public static void renderItemInGui(Minecraft mc, ItemStack stack, int x, int y) {
        if (stack != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            ItemRenderHelper.itemRender.field_77023_b = 200.0f;
            itemRender.func_77015_a(null, mc.func_110434_K(), stack, x, y);
            ItemRenderHelper.itemRender.field_77023_b = 0.0f;
        }
    }

    public static void renderIconIn3D(IIcon icon, boolean isBlock, boolean hasAlpha, int color) {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        if (isBlock) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Minecraft.func_71410_x().field_71446_o.func_130087_a(0));
            if (hasAlpha) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            }
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glPushMatrix();
            Tessellator tessellator = Tessellator.field_78398_a;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            Blocks.field_150348_b.func_149683_g();
            renderBlocksRi.func_147775_a(Blocks.field_150348_b);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            renderBlocksRi.func_147768_a(Blocks.field_150348_b, 0.0, 0.0, 0.0, icon);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            renderBlocksRi.func_147806_b(Blocks.field_150348_b, 0.0, 0.0, 0.0, icon);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            renderBlocksRi.func_147761_c(Blocks.field_150348_b, 0.0, 0.0, 0.0, icon);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            renderBlocksRi.func_147734_d(Blocks.field_150348_b, 0.0, 0.0, 0.0, icon);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderBlocksRi.func_147798_e(Blocks.field_150348_b, 0.0, 0.0, 0.0, icon);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            renderBlocksRi.func_147764_f(Blocks.field_150348_b, 0.0, 0.0, 0.0, icon);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            if (hasAlpha) {
                GL11.glDisable((int)3042);
            }
        } else {
            if (hasAlpha) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            }
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            ItemRenderHelper.renderItemIn3D(icon, false, 1);
            if (hasAlpha) {
                GL11.glDisable((int)3042);
            }
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        TextureUtil.func_147945_b();
    }

    public static void renderItemIn3D(ItemStack stack) {
        if (stack.func_77973_b() != null) {
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            if (stack.func_94608_d() == 0 && stack.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)stack.func_77973_b()).func_149645_b())) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(Minecraft.func_71410_x().field_71446_o.func_130087_a(stack.func_94608_d()));
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                float blockScale = 0.5f;
                int renderType = block.func_149645_b();
                if (renderType == 1 || renderType == 19 || renderType == 12 || renderType == 2) {
                    blockScale = 1.0f;
                }
                if (block.func_149701_w() > 0) {
                    GL11.glAlphaFunc((int)516, (float)0.1f);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                }
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
                GL11.glScalef((float)blockScale, (float)blockScale, (float)blockScale);
                GL11.glPushMatrix();
                renderBlocksRi.func_147800_a(block, stack.func_77960_j(), 1.0f);
                GL11.glPopMatrix();
                if (block.func_149701_w() > 0) {
                    GL11.glDisable((int)3042);
                }
            } else if (stack.func_77973_b().func_77623_v()) {
                for (int j = 0; j < stack.func_77973_b().getRenderPasses(stack.func_77960_j()); ++j) {
                    IIcon icon = stack.func_77973_b().getIcon(stack, j);
                    int color = stack.func_77973_b().func_82790_a(stack, j);
                    float red = (float)(color >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color & 0xFF) / 255.0f;
                    GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
                    ItemRenderHelper.renderItemIn3D(icon, stack.hasEffect(j), 1);
                }
            } else {
                IIcon icon = stack.func_77973_b().getIcon(stack, 0);
                if (stack.func_77973_b() instanceof ItemCloth) {
                    GL11.glAlphaFunc((int)516, (float)0.1f);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                }
                int color = stack.func_77973_b().func_82790_a(stack, 0);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
                ItemRenderHelper.renderItemIn3D(icon, stack.hasEffect(0), stack.func_94608_d());
                if (stack.func_77973_b() instanceof ItemCloth) {
                    GL11.glDisable((int)3042);
                }
            }
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
            TextureUtil.func_147945_b();
        }
    }

    private static void renderItemIn3D(IIcon icon, boolean withEffect, int spriteIndex) {
        GL11.glPushMatrix();
        if (icon == null) {
            GL11.glPopMatrix();
            return;
        }
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        Tessellator tessellator = Tessellator.field_78398_a;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Minecraft.func_71410_x().field_71446_o.func_130087_a(spriteIndex));
        GL11.glEnable((int)32826);
        ItemRenderHelper.renderItemIn2D(tessellator, maxU, minV, minU, maxV, icon.func_94211_a(), icon.func_94216_b(), 0.0625f, false);
        if (withEffect) {
            float baseClr = 0.76f;
            float glintScale = 0.125f;
            float glintTransX = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GLINT_PNG);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            GL11.glColor4f((float)(0.5f * baseClr), (float)(0.25f * baseClr), (float)(0.8f * baseClr), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glScalef((float)glintScale, (float)glintScale, (float)glintScale);
            GL11.glTranslatef((float)glintTransX, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderHelper.renderItemIn2D(tessellator, 0.0f, 0.0f, 1.0f, 1.0f, 256, 256, 0.0625f, false);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)glintScale, (float)glintScale, (float)glintScale);
            glintTransX = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-glintTransX), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderHelper.renderItemIn2D(tessellator, 0.0f, 0.0f, 1.0f, 1.0f, 256, 256, 0.0625f, false);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    @Deprecated
    public static void renderItem(ItemStack stack, int layer, boolean isGlowing) {
        if (stack == null) {
            return;
        }
        ItemRenderHelper.renderIcon(ItemRenderHelper.getItemIcon(stack, layer), stack.func_94608_d(), stack.hasEffect(layer), isGlowing);
    }

    public static void renderIcon(IIcon icon, int spriteIndex, boolean hasEffect, boolean isGlowing) {
        GL11.glPushMatrix();
        if (icon == null) {
            GL11.glPopMatrix();
            return;
        }
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        float transX = 0.0f;
        float transY = 0.3f;
        float scale = 1.5f;
        Tessellator tessellator = Tessellator.field_78398_a;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Minecraft.func_71410_x().field_71446_o.func_130087_a(spriteIndex));
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)(-transX), (float)(-transY), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
        ItemRenderHelper.renderItemIn2D(tessellator, maxU, minV, minU, maxV, icon.func_94211_a(), icon.func_94216_b(), 0.0625f, isGlowing);
        if (hasEffect) {
            float baseClr = 0.76f;
            float glintScale = 0.125f;
            float glintTransX = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GLINT_PNG);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            GL11.glColor4f((float)(0.5f * baseClr), (float)(0.25f * baseClr), (float)(0.8f * baseClr), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glScalef((float)glintScale, (float)glintScale, (float)glintScale);
            GL11.glTranslatef((float)glintTransX, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderHelper.renderItemIn2D(tessellator, 0.0f, 0.0f, 1.0f, 1.0f, 256, 256, 0.0625f, false);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)glintScale, (float)glintScale, (float)glintScale);
            glintTransX = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-glintTransX), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderHelper.renderItemIn2D(tessellator, 0.0f, 0.0f, 1.0f, 1.0f, 256, 256, 0.0625f, false);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    private static void renderItemIn2D(Tessellator tess, float minU, float minV, float maxU, float maxV, int scaleX, int scaleY, float negZLevel, boolean isGlowing) {
        if (isGlowing) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)16384);
            GL11.glDisable((int)16385);
            GL11.glDisable((int)2903);
            float prevLGTX = OpenGlHelper.lastBrightnessX;
            float prevLGTY = OpenGlHelper.lastBrightnessY;
            int bright = 240;
            int brightX = bright % 65536;
            int brightY = bright / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)brightX / 1.0f), (float)((float)brightY / 1.0f));
            ItemRenderer.func_78439_a((Tessellator)tess, (float)minU, (float)minV, (float)maxU, (float)maxV, (int)scaleX, (int)scaleY, (float)negZLevel);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)prevLGTX, (float)prevLGTY);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)16384);
            GL11.glEnable((int)16385);
            GL11.glEnable((int)2903);
        } else {
            ItemRenderer.func_78439_a((Tessellator)tess, (float)minU, (float)minV, (float)maxU, (float)maxV, (int)scaleX, (int)scaleY, (float)negZLevel);
        }
    }

    @Deprecated
    public static void renderGlint(int par1, int minU, int minV, int maxU, int maxV, double zLevel) {
        for (int j1 = 0; j1 < 2; ++j1) {
            if (j1 == 0) {
                GL11.glBlendFunc((int)768, (int)1);
            }
            if (j1 == 1) {
                GL11.glBlendFunc((int)768, (int)1);
            }
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            float f5 = 3000.0f + (float)j1 * 1873.0f;
            float f2 = (float)Minecraft.func_71386_F() % f5 / f5 * 256.0f;
            float f3 = 0.0f;
            Tessellator tessellator = Tessellator.field_78398_a;
            float f4 = 4.0f;
            if (j1 == 1) {
                f4 = -1.0f;
            }
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)minU, (double)(minV + maxV), zLevel, (double)((f2 + (float)maxV * f4) * f), (double)((f3 + (float)maxV) * f1));
            tessellator.func_78374_a((double)(minU + maxU), (double)(minV + maxV), zLevel, (double)((f2 + (float)maxU + (float)maxV * f4) * f), (double)((f3 + (float)maxV) * f1));
            tessellator.func_78374_a((double)(minU + maxU), (double)minV, zLevel, (double)((f2 + (float)maxU) * f), (double)((f3 + 0.0f) * f1));
            tessellator.func_78374_a((double)minU, (double)minV, zLevel, (double)((f2 + 0.0f) * f), (double)((f3 + 0.0f) * f1));
            tessellator.func_78381_a();
        }
    }

    public static IIcon getItemIcon(ItemStack stack, int layer) {
        return stack.func_77973_b().func_77623_v() ? stack.func_77973_b().getIcon(stack, layer) : stack.func_77954_c();
    }
}

