/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils;

import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class GuiUtil {
    public static float[] getRGBFromHex(int hex) {
        float[] temp = new float[]{(float)(hex >> 16 & 0xFF) / 255.0f, (float)(hex >> 8 & 0xFF) / 255.0f, (float)(hex & 0xFF) / 255.0f, (float)(hex >> 24 & 0xFF) / 255.0f};
        return temp;
    }

    public static void drawLine(float xPos1, float yPos1, float xPos2, float yPos2, int colour) {
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)GuiUtil.getRGBFromHex(colour)[0], (float)GuiUtil.getRGBFromHex(colour)[1], (float)GuiUtil.getRGBFromHex(colour)[2], (float)GuiUtil.getRGBFromHex(colour)[3]);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)xPos1, (double)yPos1);
        GL11.glVertex2d((double)xPos2, (double)yPos2);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
    }

    public static void drawRect(float xPos1, float yPos1, float xPos2, float yPos2, int colour) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glEnable((int)3042);
        GL11.glPushMatrix();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)GuiUtil.getRGBFromHex(colour)[0], (float)GuiUtil.getRGBFromHex(colour)[1], (float)GuiUtil.getRGBFromHex(colour)[2], (float)GuiUtil.getRGBFromHex(colour)[3]);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)xPos1, (double)yPos1);
        GL11.glVertex2d((double)xPos1, (double)yPos2);
        GL11.glVertex2d((double)xPos2, (double)yPos2);
        GL11.glVertex2d((double)xPos2, (double)yPos1);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
        GL11.glEnable((int)3553);
    }

    public static void drawPartialCircle(int x, int y, double radius, int startAngle, int endAngle) {
        GL11.glDisable((int)3553);
        GL11.glBegin((int)8);
        endAngle -= 90;
        for (int angle = startAngle -= 90; angle <= endAngle; ++angle) {
            float rad = (float)(Math.PI * (double)angle / 180.0);
            float x2 = (float)((double)x + radius * Math.cos(rad));
            float y2 = (float)((double)y + radius * Math.sin(rad));
            GL11.glVertex3f((float)x2, (float)y2, (float)0.0f);
            GL11.glVertex3f((float)x, (float)y, (float)0.0f);
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public static void drawCircle(int x, int y, double radius) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glEnable((int)3042);
        GL11.glBegin((int)6);
        for (int i = 0; i <= 360; ++i) {
            double sin = Math.sin((double)i * Math.PI / 180.0) * radius;
            double cos = Math.cos((double)i * Math.PI / 180.0) * radius;
            GL11.glVertex2d((double)((double)x + sin), (double)((double)y + cos));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public static void drawCircleOutline(int x, int y, double radius) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glEnable((int)3042);
        float rotation = (float)Math.PI / 180;
        float moveX = (float)Math.cos(rotation);
        float moveY = (float)Math.sin(rotation);
        float xOffset = (float)radius;
        float yOffset = 0.0f;
        GL11.glBegin((int)2);
        for (int i = 0; i < 360; ++i) {
            GL11.glVertex2f((float)((float)x + xOffset), (float)((float)y + yOffset));
            float prevXOffset = xOffset;
            xOffset = moveX * xOffset - moveY * yOffset;
            yOffset = moveY * prevXOffset + moveX * yOffset;
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public static void drawCircleOutline(int x, int y, double radius, int corners) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)2848);
        GL11.glEnable((int)3042);
        float rotation = (float)(Math.PI * 2 / (double)corners);
        float moveX = (float)Math.cos(rotation);
        float moveY = (float)Math.sin(rotation);
        float xOffset = (float)radius;
        float yOffset = 0.0f;
        GL11.glBegin((int)2);
        for (int i = 0; i < corners; ++i) {
            GL11.glVertex2f((float)((float)x + xOffset), (float)((float)y + yOffset));
            float prevXOffset = xOffset;
            xOffset = moveX * xOffset - moveY * yOffset;
            yOffset = moveY * prevXOffset + moveX * yOffset;
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    private static final String pad(String s) {
        return s.length() == 1 ? "0" + s : s;
    }

    public static int toHexInt(Color col) {
        try {
            String as = GuiUtil.pad(Integer.toHexString(col.getAlpha()));
            String rs = GuiUtil.pad(Integer.toHexString(col.getRed()));
            String gs = GuiUtil.pad(Integer.toHexString(col.getGreen()));
            String bs = GuiUtil.pad(Integer.toHexString(col.getBlue()));
            String hexString = "0x" + as + rs + gs + bs;
            return Long.decode(hexString).intValue();
        }
        catch (Exception ex) {
            return -1;
        }
    }
}

