/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils;

import java.util.Random;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class FogGenerator {
    public static final FogGenerator INSTANCE = new FogGenerator();
    private int lastCX;
    private int lastCZ;
    private NoiseGeneratorPerlin fogNoiseGen;
    private double[] fogChunkNoise = new double[256];

    public float[] getFogRange(double x, double z, float farPlane, long seed) {
        int cx = (int)((x - (double)((int)Math.floor(x) & 0xF)) / 16.0) - 1;
        int cz = (int)((z - (double)((int)Math.floor(z) & 0xF)) / 16.0);
        if (this.fogNoiseGen == null) {
            Random rnd = new Random();
            rnd.setSeed(seed);
            this.fogNoiseGen = new NoiseGeneratorPerlin(rnd, 4);
        }
        if (this.fogChunkNoise == null || this.lastCX != cx || this.lastCZ != cz) {
            this.lastCX = cx;
            this.lastCZ = cz;
            this.fogChunkNoise = this.fogNoiseGen.func_151599_a(this.fogChunkNoise, (double)(cx * 16), (double)(cz * 16), 16, 16, 0.003, 0.003, 0.003);
        }
        int ix = (int)Math.floor(x) & 0xF;
        int iz = (int)Math.floor(z) & 0xF;
        double fogDist = Math.pow(Math.abs(this.fogChunkNoise[iz * 16 + ix] * 2.5), 2.0) * 60.0;
        if (fogDist > (double)(farPlane - 60.0f)) {
            fogDist = farPlane - 60.0f;
        } else if (fogDist < 1.0) {
            fogDist = 1.0;
        }
        return new float[]{(float)fogDist, (float)fogDist + 60.0f};
    }
}

