/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class DyeOreDictHelper {
    private static final String[] DYE_NAMES = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    private static List<ItemStack>[] dyeItemStacks;
    private static List<ItemStack> allDyeItemStacks;

    private DyeOreDictHelper() {
    }

    public static boolean isDye(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() == Items.field_151100_aR) {
                return true;
            }
            DyeOreDictHelper.initDyeItemStacks();
            for (ItemStack dye : allDyeItemStacks) {
                if (!OreDictionary.itemMatches((ItemStack)dye, (ItemStack)itemStack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getDyeMetadata(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() == Items.field_151100_aR) {
                return itemStack.func_77960_j();
            }
            DyeOreDictHelper.initDyeItemStacks();
            for (int i = 0; i < DYE_NAMES.length; ++i) {
                List<ItemStack> dyes = dyeItemStacks[i];
                for (ItemStack dye : dyes) {
                    if (!OreDictionary.itemMatches((ItemStack)dye, (ItemStack)itemStack, (boolean)false)) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private static void initDyeItemStacks() {
        if (dyeItemStacks == null) {
            dyeItemStacks = new List[DYE_NAMES.length];
            allDyeItemStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < DYE_NAMES.length; ++i) {
                DyeOreDictHelper.dyeItemStacks[i] = OreDictionary.getOres((String)DYE_NAMES[i]);
                allDyeItemStacks.addAll(dyeItemStacks[i]);
            }
        }
    }
}

