/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thebetweenlands.decay.DecayManager;
import thebetweenlands.world.BLGamerules;
import thebetweenlands.world.WorldProviderBetweenlands;

public final class CorrodibleItemHelper {
    public static final int MAX_CORROSION = 255;
    public static final String TOOLTIP_PART = "/255)";
    public static final int CORROSION_STAGE_COUNT = 6;

    private CorrodibleItemHelper() {
    }

    public static int getCoating(ItemStack itemStack) {
        NBTTagCompound tagCompound;
        if (itemStack.func_77942_o() && (tagCompound = itemStack.func_77978_p()).func_150297_b("CorrosionCoating", 3)) {
            return tagCompound.func_74762_e("CorrosionCoating");
        }
        return 0;
    }

    public static int getCorrosion(ItemStack itemStack) {
        NBTTagCompound tagCompound;
        if (itemStack.func_77942_o() && (tagCompound = itemStack.func_77978_p()).func_150297_b("Corrosion", 3)) {
            return tagCompound.func_74762_e("Corrosion");
        }
        return 0;
    }

    public static void setCoating(ItemStack itemStack, int coating) {
        itemStack.func_77983_a("CorrosionCoating", (NBTBase)new NBTTagInt(coating));
    }

    public static void setCorrosion(ItemStack itemStack, int corrosion) {
        itemStack.func_77983_a("Corrosion", (NBTBase)new NBTTagInt(corrosion));
    }

    public static float getModifier(ItemStack itemStack) {
        return -0.7f * ((float)CorrodibleItemHelper.getCorrosion(itemStack) / 255.0f) + 1.0f;
    }

    public static float getDigSpeed(float normalDigSpeed, ItemStack itemStack, Block block, int meta) {
        return normalDigSpeed * CorrodibleItemHelper.getModifier(itemStack);
    }

    public static Multimap getAttributeModifiers(ItemStack stack, UUID uuid, float damageVsEntity) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuid, "Tool modifier", (double)(damageVsEntity * CorrodibleItemHelper.getModifier(stack)), 0));
        return multimap;
    }

    public static void onUpdate(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        int corrosion;
        if (world.field_72995_K || !BLGamerules.getGameRuleBooleanValue("blCorrosion")) {
            return;
        }
        if (world.field_73011_w instanceof WorldProviderBetweenlands && (corrosion = CorrodibleItemHelper.getCorrosion(itemStack)) < 255) {
            float probability;
            float f = probability = holder.func_70090_H() ? 0.0014f : 7.0E-4f;
            if (holder instanceof EntityPlayer) {
                probability *= (((EntityPlayer)holder).func_71039_bw() || ((EntityPlayer)holder).field_82175_bq) && isHeldItem ? 2.8f : 1.0f;
                float playerCorruption = (float)DecayManager.getCorruptionLevel((EntityPlayer)holder) / 10.0f;
                probability = (float)((double)probability * (1.0 - Math.pow(playerCorruption, 2.0) * (double)0.9f));
            }
            if (world.field_73012_v.nextFloat() < probability) {
                int coating = CorrodibleItemHelper.getCoating(itemStack);
                if (coating > 0) {
                    CorrodibleItemHelper.setCoating(itemStack, coating - 1);
                } else {
                    CorrodibleItemHelper.setCorrosion(itemStack, corrosion + 1);
                }
            }
        }
    }

    public static void addInformation(ItemStack itemStack, EntityPlayer player, List lines, boolean advancedItemTooltips) {
        int corrosion = CorrodibleItemHelper.getCorrosion(itemStack);
        int coating = CorrodibleItemHelper.getCoating(itemStack);
        StringBuilder corrosionInfo = new StringBuilder("corrosion.");
        corrosionInfo.append(CorrodibleItemHelper.getCorrosionStage(corrosion));
        corrosionInfo.replace(0, corrosionInfo.length(), StatCollector.func_74838_a((String)corrosionInfo.toString()));
        if (advancedItemTooltips) {
            corrosionInfo.append(" (");
            corrosionInfo.append(corrosion);
            corrosionInfo.append(TOOLTIP_PART);
        }
        lines.add(corrosionInfo.toString());
        if (coating > 0) {
            lines.add(StatCollector.func_74838_a((String)"tooltip.coated"));
        }
    }

    public static int getCorrosionStage(ItemStack itemStack) {
        return CorrodibleItemHelper.getCorrosionStage(CorrodibleItemHelper.getCorrosion(itemStack));
    }

    public static int getCorrosionStage(int corrosion) {
        return (10 * corrosion + 630) / 635;
    }
}

