/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils;

import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.utils.TextureAtlasHelper;

public class ConnectedTexture {
    private final TextureAtlasHelper atlas;

    public ConnectedTexture(int texWidth, int texHeight, int segmentWidth, int segmentHeight, int horizontalPadding, int verticalPadding) {
        this.atlas = new TextureAtlasHelper(texWidth, texHeight, segmentWidth, segmentHeight, horizontalPadding, verticalPadding);
    }

    public ConnectedTexture(int texSize, int segmentSize, int padding) {
        this(texSize, texSize, segmentSize, segmentSize, padding, padding);
    }

    public ConnectedTexture(TextureAtlasHelper atlas) {
        this.atlas = atlas;
    }

    public float[][] getUVs(int segment, int quadrant) {
        float[][] ret = new float[2][2];
        float[][] segmentUVs = this.atlas.getUVs(segment);
        float segmentMinU = segmentUVs[0][0];
        float segmentMinV = segmentUVs[0][1];
        float segmentMaxU = segmentUVs[1][0];
        float segmentMaxV = segmentUVs[1][1];
        float segmentDiffU = segmentMaxU - segmentMinU;
        float segmentDiffV = segmentMaxV - segmentMinV;
        int quadrantX = quadrant % 2;
        int quadrantY = quadrant / 2;
        float quadrantRelU = (float)quadrantX / 2.0f;
        float quadrantRelV = (float)quadrantY / 2.0f;
        ret[0][0] = segmentMinU + segmentDiffU * quadrantRelU;
        ret[0][1] = segmentMinV + segmentDiffV * quadrantRelV;
        ret[1][0] = segmentMinU + segmentDiffU * (quadrantRelU + 0.5f);
        ret[1][1] = segmentMinV + segmentDiffV * (quadrantRelV + 0.5f);
        return ret;
    }

    public static int getIndex(int x, int y, int width) {
        return x % width + y * width;
    }

    public float[][][] getFaceUVs(boolean[] connectionArray) {
        float[][][] ret = new float[4][2][2];
        int tls = 0;
        int trs = 0;
        int bls = 0;
        int brs = 0;
        for (int xo = 0; xo <= 2; ++xo) {
            for (int zo = 0; zo <= 2; ++zo) {
                boolean currentNeighbourState = connectionArray[ConnectedTexture.getIndex(xo, zo, 3)];
                if (xo != 1 && zo == 1 || xo == 1 && zo != 1) {
                    if (!currentNeighbourState) continue;
                    if (xo == 0) {
                        if (!connectionArray[ConnectedTexture.getIndex(1, 2, 3)]) {
                            bls = 1;
                        }
                        if (connectionArray[ConnectedTexture.getIndex(1, 0, 3)]) continue;
                        tls = 1;
                        continue;
                    }
                    if (xo == 2) {
                        if (!connectionArray[ConnectedTexture.getIndex(1, 2, 3)]) {
                            brs = 1;
                        }
                        if (connectionArray[ConnectedTexture.getIndex(1, 0, 3)]) continue;
                        trs = 1;
                        continue;
                    }
                    if (zo == 0) {
                        if (!connectionArray[ConnectedTexture.getIndex(0, 1, 3)]) {
                            tls = 2;
                        }
                        if (connectionArray[ConnectedTexture.getIndex(2, 1, 3)]) continue;
                        trs = 2;
                        continue;
                    }
                    if (zo != 2) continue;
                    if (!connectionArray[ConnectedTexture.getIndex(0, 1, 3)]) {
                        bls = 2;
                    }
                    if (connectionArray[ConnectedTexture.getIndex(2, 1, 3)]) continue;
                    brs = 2;
                    continue;
                }
                if (xo == 1 || zo == 1 || !connectionArray[ConnectedTexture.getIndex(xo, 1, 3)] || !connectionArray[ConnectedTexture.getIndex(1, zo, 3)]) continue;
                int segment = currentNeighbourState ? 3 : 4;
                if (xo == 2 && zo == 0) {
                    trs = segment;
                    continue;
                }
                if (xo == 2 && zo == 2) {
                    brs = segment;
                    continue;
                }
                if (xo == 0 && zo == 2) {
                    bls = segment;
                    continue;
                }
                tls = segment;
            }
        }
        ret[0] = this.getUVs(tls, 0);
        ret[1] = this.getUVs(trs, 1);
        ret[2] = this.getUVs(bls, 2);
        ret[3] = this.getUVs(brs, 3);
        return ret;
    }

    public static boolean[] getConnectionArray(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection dir, boolean ignoreMeta) {
        Block centerBlock = blockAccess.func_147439_a(x, y, z);
        int centerBlockMeta = blockAccess.func_72805_g(x, y, z);
        boolean xp = true;
        boolean yp = true;
        boolean xr = false;
        boolean yr = false;
        boolean zr = false;
        boolean[] connectionArray = new boolean[9];
        switch (dir) {
            case DOWN: {
                xp = false;
            }
            case UP: {
                xr = true;
                zr = true;
                break;
            }
            case NORTH: {
                yp = false;
            }
            case SOUTH: {
                xr = true;
                yr = true;
                break;
            }
            case EAST: {
                xp = false;
            }
            case WEST: {
                zr = true;
                yr = true;
                break;
            }
            default: {
                return connectionArray;
            }
        }
        for (int xo = xr ? -1 : 0; xo <= (xr ? 1 : 0); ++xo) {
            for (int yo = yr ? -1 : 0; yo <= (yr ? 1 : 0); ++yo) {
                for (int zo = zr ? -1 : 0; zo <= (zr ? 1 : 0); ++zo) {
                    int mx = (xr ? xo : yo) + 1;
                    int my = (zr ? zo : (xr ? yo : zo)) + 1;
                    int blockIndex = ConnectedTexture.getIndex(xp ? mx : 2 - mx, yp ? my : 2 - my, 3);
                    connectionArray[blockIndex] = blockAccess.func_147439_a(x + xo, y + yo, z + zo) == centerBlock && (ignoreMeta || blockAccess.func_72805_g(x + xo, y + yo, z + zo) == centerBlockMeta);
                }
            }
        }
        return connectionArray;
    }

    public float[][][] getFaceUVs(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection dir, boolean ignoreMeta) {
        return this.getFaceUVs(ConnectedTexture.getConnectionArray(blockAccess, x, y, z, dir, ignoreMeta));
    }
}

