/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.utils;

import net.minecraft.util.MathHelper;

public final class CatenaryUtils {
    public static final int SEG_LENGTH = 3;
    public static final float HALF_PI = 1.5707964f;
    private static final int MAX_ITER = 100;
    private static final float MIN_GRAD = 1.0E-10f;
    private static final float MIN_VAL = 1.0E-8f;
    private static final float STEP_DEC = 0.5f;
    private static final float MIN_STEP = 1.0E-9f;
    private static final float MIN_HORIZ = 0.001f;

    static float[][] catenary(float[] a, float[] b, float arcLength, int n) {
        return CatenaryUtils.catenary(a, b, arcLength, n, 1.0f);
    }

    private static float[][] catenary(float[] a, float[] b, float arcLength, int n, float sag) {
        if (a[0] > b[0]) {
            float[] a_copy = new float[]{a[0], a[1]};
            a = new float[]{b[0], b[1]};
            b = a_copy;
        }
        float d = b[0] - a[0];
        float h = b[1] - a[1];
        if (MathHelper.func_76135_e((float)d) < 0.001f) {
            float[] y;
            float[] x = new float[n];
            for (int i = 0; i < x.length; ++i) {
                x[i] = (a[0] + b[0]) / 2.0f;
            }
            if (arcLength < MathHelper.func_76135_e((float)h)) {
                y = CatenaryUtils.linspace(a[1], b[1], n);
            } else {
                sag = (arcLength - MathHelper.func_76135_e((float)h)) / 2.0f;
                int nSag = MathHelper.func_76123_f((float)((float)n * sag / arcLength));
                float yMax = Math.max(a[1], b[1]);
                float yMin = Math.min(a[1], b[1]);
                y = CatenaryUtils.concat(CatenaryUtils.linspace(yMax, yMin - sag, n - nSag), CatenaryUtils.linspace(yMin - sag, yMin, nSag));
            }
            return new float[][]{x, y};
        }
        float[] x = CatenaryUtils.linspace(a[0], b[0], n);
        if (arcLength <= MathHelper.func_76129_c((float)(d * d + h * h))) {
            float[] y = CatenaryUtils.linspace(a[1], b[1], n);
            return new float[][]{x, y};
        }
        for (int iter = 0; iter < 100; ++iter) {
            float val = CatenaryUtils.g(sag, d, arcLength, h);
            float grad = CatenaryUtils.dg(sag, d);
            if (MathHelper.func_76135_e((float)val) < 1.0E-8f || MathHelper.func_76135_e((float)grad) < 1.0E-10f) break;
            float search = -CatenaryUtils.g(sag, d, arcLength, h) / CatenaryUtils.dg(sag, d);
            float alpha = 1.0f;
            float sagNew = sag + alpha * search;
            while ((sagNew < 0.0f || MathHelper.func_76135_e((float)CatenaryUtils.g(sagNew, d, arcLength, h)) > MathHelper.func_76135_e((float)val)) && !((alpha = 0.5f * alpha) < 1.0E-9f)) {
                sagNew = sag + alpha * search;
            }
            sag = sagNew;
        }
        float xLeft = 0.5f * ((float)Math.log((arcLength + h) / (arcLength - h)) / sag - d);
        float xMin = a[0] - xLeft;
        float bias = a[1] - (float)Math.cosh(xLeft * sag) / sag;
        float[] y = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = (float)Math.cosh((x[i] - xMin) * sag) / sag + bias;
        }
        return new float[][]{x, y};
    }

    private static float[] concat(float[] a, float[] b) {
        int aLength = a.length;
        int bLength = b.length;
        float[] concat = new float[aLength + bLength];
        System.arraycopy(a, 0, concat, 0, aLength);
        System.arraycopy(b, 0, concat, aLength, bLength);
        return concat;
    }

    private static float dg(float s, float d) {
        return 2.0f * (float)Math.cosh(s * d / 2.0f) * d / (2.0f * s) - 2.0f * (float)Math.sinh(s * d / 2.0f) / (s * s);
    }

    private static float g(float s, float d, float arcLength, float h) {
        return 2.0f * (float)Math.sinh(s * d / 2.0f) / s - MathHelper.func_76129_c((float)(arcLength * arcLength - h * h));
    }

    private static float[] linspace(float base, float limit, int n) {
        float[] elements = new float[n];
        float scaler = n > 1 ? (limit - base) / (float)(n - 1) : 0.0f;
        for (int i = 0; i < n; ++i) {
            elements[i] = base + scaler * (float)i;
        }
        return elements;
    }

    private CatenaryUtils() {
    }
}

