/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.tileentities.spawner;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import thebetweenlands.client.particle.BLParticle;

public abstract class MobSpawnerBaseLogicBL {
    public int spawnDelay = 20;
    private String entityTypeName = "Pig";
    public double entityRotation;
    public double lastEntityRotation;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    private Entity cachedEntity;
    private int maxNearbyEntities = 6;
    private int activatingRangeFromPlayer = 16;
    private int spawnRange = 4;
    private double checkRange = 8.0;
    private boolean hasParticles = true;

    public String getEntityNameToSpawn() {
        return this.entityTypeName;
    }

    public MobSpawnerBaseLogicBL setHasParticles(boolean hasParticles) {
        this.hasParticles = hasParticles;
        return this;
    }

    public boolean hasParticles() {
        return this.hasParticles;
    }

    public MobSpawnerBaseLogicBL setMaxEntities(int maxEntities) {
        this.maxNearbyEntities = maxEntities;
        return this;
    }

    public int getMaxEntities() {
        return this.maxNearbyEntities;
    }

    public MobSpawnerBaseLogicBL setDelay(int minDelay, int maxDelay) {
        this.minSpawnDelay = minDelay;
        this.maxSpawnDelay = maxDelay;
        return this;
    }

    public int getMinDelay() {
        return this.minSpawnDelay;
    }

    public int getMaxDelay() {
        return this.maxSpawnDelay;
    }

    public MobSpawnerBaseLogicBL setEntityName(String name) {
        this.entityTypeName = name;
        return this;
    }

    public MobSpawnerBaseLogicBL setSpawnRange(int range) {
        this.spawnRange = range;
        return this;
    }

    public int getSpawnRange() {
        return this.spawnRange;
    }

    public MobSpawnerBaseLogicBL setCheckRange(double range) {
        this.checkRange = range;
        return this;
    }

    public double getCheckRange() {
        return this.checkRange;
    }

    public boolean isActivated() {
        return this.getSpawnerWorld().func_72977_a((double)this.getSpawnerX() + 0.5, (double)this.getSpawnerY() + 0.5, (double)this.getSpawnerZ() + 0.5, (double)this.activatingRangeFromPlayer) != null;
    }

    public void updateSpawner() {
        if (this.isActivated()) {
            if (this.getSpawnerWorld().field_72995_K) {
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                }
                if (this.hasParticles()) {
                    double rx = this.getSpawnerWorld().field_73012_v.nextFloat();
                    double ry = this.getSpawnerWorld().field_73012_v.nextFloat();
                    double rz = this.getSpawnerWorld().field_73012_v.nextFloat();
                    double len = Math.sqrt(rx * rx + ry * ry + rz * rz);
                    BLParticle.PORTAL.spawn(this.getSpawnerWorld(), (double)this.getSpawnerX() + rx, (double)this.getSpawnerY() + ry, (double)this.getSpawnerZ() + rz, (rx - 0.5) / len * 0.05, (ry - 0.5) / len * 0.05, (rz - 0.5) / len * 0.05, 0.0f, new Object[0]);
                }
                this.lastEntityRotation = this.entityRotation;
                this.entityRotation = (this.entityRotation + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
            } else {
                if (this.spawnDelay == -1) {
                    this.resetTimer();
                }
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                    return;
                }
                boolean entitySpawned = false;
                for (int i = 0; i < this.spawnCount; ++i) {
                    Entity entity = EntityList.func_75620_a((String)this.getEntityNameToSpawn(), (World)this.getSpawnerWorld());
                    if (entity == null) {
                        return;
                    }
                    List entitiesInReach = this.getSpawnerWorld().func_72872_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)this.getSpawnerX(), (double)this.getSpawnerY(), (double)this.getSpawnerZ(), (double)(this.getSpawnerX() + 1), (double)(this.getSpawnerY() + 1), (double)(this.getSpawnerZ() + 1)).func_72314_b(this.checkRange, this.checkRange, this.checkRange));
                    int nearbyEntities = 0;
                    for (Entity e : entitiesInReach) {
                        if (!(e.func_70011_f((double)this.getSpawnerX() + 0.5, (double)this.getSpawnerY() + 0.5, (double)this.getSpawnerZ() + 0.5) <= this.checkRange)) continue;
                        ++nearbyEntities;
                    }
                    if (nearbyEntities >= this.maxNearbyEntities) {
                        this.resetTimer();
                        return;
                    }
                    double rx = (double)this.getSpawnerX() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                    double ry = this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextInt(3) - 1;
                    double rz = (double)this.getSpawnerZ() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                    EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                    entity.func_70012_b(rx, ry, rz, this.getSpawnerWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entityliving != null && entityliving.func_70601_bi()) {
                        this.spawnEntity(entity);
                        entitySpawned = true;
                        continue;
                    }
                    if (entityliving != null) continue;
                    entitySpawned = true;
                }
                if (entitySpawned) {
                    this.resetTimer();
                }
            }
        }
    }

    public Entity spawnEntity(Entity entity) {
        ((EntityLiving)entity).func_110161_a((IEntityLivingData)null);
        this.getSpawnerWorld().func_72838_d(entity);
        return entity;
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
        }
        this.sendBlockEvent(1);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.entityTypeName = nbt.func_74779_i("EntityId");
        this.spawnDelay = nbt.func_74765_d("Delay");
        if (nbt.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = nbt.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = nbt.func_74765_d("MaxSpawnDelay");
            this.spawnCount = nbt.func_74765_d("SpawnCount");
        }
        if (nbt.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.func_74765_d("MaxNearbyEntities");
            this.activatingRangeFromPlayer = nbt.func_74765_d("RequiredPlayerRange");
        }
        if (nbt.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = nbt.func_74765_d("SpawnRange");
        }
        if (nbt.func_150297_b("CheckRange", 99)) {
            this.checkRange = nbt.func_74769_h("CheckRange");
        }
        if (nbt.func_74764_b("HasParticles")) {
            this.hasParticles = nbt.func_74767_n("HasParticles");
        }
        if (this.getSpawnerWorld() != null && this.getSpawnerWorld().field_72995_K) {
            this.cachedEntity = null;
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("EntityId", this.getEntityNameToSpawn());
        nbt.func_74777_a("Delay", (short)this.spawnDelay);
        nbt.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        nbt.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        nbt.func_74777_a("SpawnCount", (short)this.spawnCount);
        nbt.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        nbt.func_74777_a("RequiredPlayerRange", (short)this.activatingRangeFromPlayer);
        nbt.func_74777_a("SpawnRange", (short)this.spawnRange);
        nbt.func_74780_a("CheckRange", this.checkRange);
        nbt.func_74757_a("HasParticles", this.hasParticles);
    }

    public boolean setDelayToMin(int event) {
        if (event == 1 && this.getSpawnerWorld().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getCachedEntity() {
        if (this.cachedEntity != null && !EntityList.func_75621_b((Entity)this.cachedEntity).equals(this.getEntityNameToSpawn())) {
            this.cachedEntity = null;
        }
        if (this.cachedEntity == null) {
            Entity entity;
            this.cachedEntity = entity = EntityList.func_75620_a((String)this.getEntityNameToSpawn(), (World)null);
        }
        return this.cachedEntity;
    }

    public abstract void sendBlockEvent(int var1);

    public abstract World getSpawnerWorld();

    public abstract int getSpawnerX();

    public abstract int getSpawnerY();

    public abstract int getSpawnerZ();
}

