/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.tileentities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.IMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import thebetweenlands.entities.mobs.EntityWight;
import thebetweenlands.entities.mobs.boss.IBossBL;

public class TileEntityRepeller
extends TileEntity {
    private static final float MAX_FUEL = 10.0f;
    private static final float MAX_RADIUS = 18.0f;
    private static final int DEPLOY_TIME = 80;
    private boolean hasShimmerstone = false;
    private float fuel = 0.0f;
    private boolean prevRunning = false;
    private boolean running = false;
    private float lastRadius = 0.0f;
    private float radius = 0.0f;
    private int deployTicks = 0;
    private int radiusState = 0;
    public int renderTicks = 0;

    public void setRadiusState(int state) {
        if (this.running && state % 4 != this.radiusState) {
            this.deployTicks = 0;
        }
        this.radiusState = state % 4;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void cycleRadiusState() {
        this.radiusState = (this.radiusState + 1) % 4;
        if (this.running) {
            this.deployTicks = 0;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void addShimmerstone() {
        this.hasShimmerstone = true;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean hasShimmerstone() {
        return this.hasShimmerstone;
    }

    public void removeShimmerstone() {
        this.hasShimmerstone = false;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public float addFuel(float amount) {
        float canAdd = 10.0f - this.fuel;
        if (canAdd > 0.0f) {
            float added = Math.min(canAdd, amount);
            this.fuel += added;
            return added;
        }
        return 0.0f;
    }

    public float getFuel() {
        return this.fuel;
    }

    public void emptyFuel() {
        this.fuel = 0.0f;
    }

    public boolean isRunning() {
        return this.running || this.radius > 0.0f;
    }

    public float getRadius(float partialTicks) {
        return this.lastRadius + (this.radius - this.lastRadius) * partialTicks;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.fuel > 0.0f && this.fuel <= 0.0f) {
                this.fuel = 0.0f;
            }
            if (this.fuel > 0.0f && this.hasShimmerstone) {
                if (!this.running) {
                    this.running = true;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if ((this.fuel <= 0.0f || !this.hasShimmerstone) && this.running) {
                this.running = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.fuel <= 0.0f) {
                this.fuel = 0.0f;
            } else {
                float fuelCost = 4.0E-6f * (float)(this.radiusState + 1);
                int meta = this.func_145832_p();
                double centerX = (float)this.field_145851_c + 0.5f;
                double centerY = (float)this.field_145848_d + 1.15f;
                double centerZ = (float)this.field_145849_e + 0.5f;
                AxisAlignedBB affectedBB = AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - this.radius - 5.0f), (double)((float)this.field_145848_d - this.radius - 5.0f), (double)((float)this.field_145849_e - this.radius - 5.0f), (double)((float)this.field_145851_c + this.radius + 5.0f), (double)((float)this.field_145848_d + this.radius + 5.0f), (double)((float)this.field_145849_e + this.radius + 5.0f));
                List affectedEntities = this.field_145850_b.func_72872_a(IMob.class, affectedBB);
                for (Entity entity : affectedEntities) {
                    Vec3 closestPoint;
                    if (entity instanceof EntityWight || entity instanceof IBossBL || !((closestPoint = this.getClosestAABBCorner(entity.field_70121_D, centerX, centerY, centerZ)).func_72445_d(centerX, centerY, centerZ) < (double)(this.radius * this.radius))) continue;
                    double diffX = entity.field_70165_t - centerX;
                    double diffY = entity.field_70163_u - centerY;
                    double diffZ = entity.field_70161_v - centerZ;
                    entity.func_70091_d(diffX * (double)0.1f, 0.0, diffZ * (double)0.1f);
                    double len = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
                    double speed = ((double)this.radius - len) / (double)this.radius * 1.5 + 0.5;
                    entity.field_70159_w = (double)((float)(diffX / len)) * speed;
                    entity.field_70179_y = (double)((float)(diffZ / len)) * speed;
                    if (entity instanceof EntityLivingBase) {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 10, 6));
                    }
                    if (entity.field_70123_F) continue;
                    fuelCost += 2.8E-4f;
                }
                List affectedProjectiles = this.field_145850_b.func_72872_a(IProjectile.class, affectedBB);
                for (Entity entity : affectedProjectiles) {
                    Vec3 closestPoint = this.getClosestAABBCorner(entity.field_70121_D, centerX, centerY, centerZ);
                    if (!(closestPoint.func_72445_d(centerX, centerY, centerZ) < (double)(this.radius * this.radius))) continue;
                    double velocity = Math.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70181_x * entity.field_70181_x + entity.field_70179_y * entity.field_70179_y);
                    double diffX = entity.field_70165_t - centerX;
                    double diffY = entity.field_70163_u - centerY;
                    double diffZ = entity.field_70161_v - centerZ;
                    double len = Math.sqrt(diffX * diffX + diffY * diffY + diffZ * diffZ);
                    entity.func_70091_d(diffX * (double)0.1f, 0.0, diffZ * (double)0.1f);
                    entity.field_70159_w = (double)((float)(diffX / len)) * velocity;
                    entity.field_70181_x = (double)((float)(diffY / len)) * velocity;
                    entity.field_70179_y = (double)((float)(diffZ / len)) * velocity;
                    ((IProjectile)entity).func_70186_c(diffX / len, diffY / len, diffZ / len, 1.0f, 1.0f);
                    entity.field_70133_I = true;
                    if (entity.field_70123_F || entity.field_70123_F || entity.field_70122_E) continue;
                    fuelCost += 4.0E-4f;
                }
                fuelCost = Math.min(fuelCost, 0.00125f);
                this.fuel -= fuelCost;
            }
        } else {
            ++this.renderTicks;
        }
        if (this.prevRunning != this.running) {
            this.deployTicks = 0;
        }
        this.prevRunning = this.running;
        float desiredRadius = 4.5f * (float)(this.radiusState + 1);
        this.lastRadius = this.radius;
        if (this.running && this.radius < desiredRadius && this.deployTicks < 80) {
            ++this.deployTicks;
            this.radius = (float)this.easeInOut(this.deployTicks, this.radius, desiredRadius, 80.0f);
            if (this.radius > desiredRadius) {
                this.radius = desiredRadius;
            }
        } else if (!this.running && this.radius > 0.0f || this.radius > desiredRadius) {
            ++this.deployTicks;
            this.radius = (float)this.easeInOut(this.deployTicks, desiredRadius, -desiredRadius, 80.0f);
            if (this.radius < 0.0f) {
                this.radius = 0.0f;
            }
        }
    }

    private Vec3 getClosestAABBCorner(AxisAlignedBB bb, double centerX, double centerY, double centerZ) {
        Vec3 center = Vec3.func_72443_a((double)centerX, (double)centerY, (double)centerZ);
        Vec3 closest = null;
        for (int bcx = 0; bcx <= 1; ++bcx) {
            for (int bcy = 0; bcy <= 1; ++bcy) {
                for (int bcz = 0; bcz <= 1; ++bcz) {
                    double cx = bcx == 1 ? bb.field_72336_d : bb.field_72340_a;
                    double cy = bcy == 1 ? bb.field_72337_e : bb.field_72338_b;
                    double cz = bcz == 1 ? bb.field_72334_f : bb.field_72339_c;
                    Vec3 current = Vec3.func_72443_a((double)cx, (double)cy, (double)cz);
                    if (closest != null && !(current.func_72438_d(center) < closest.func_72438_d(center))) continue;
                    closest = current;
                }
            }
        }
        return closest;
    }

    private double easeInOut(float t, float b, float c, float d) {
        if ((t /= d / 2.0f) < 1.0f) {
            return c / 2.0f * t * t * t * t * t + b;
        }
        return c / 2.0f * ((t -= 2.0f) * t * t * t * t + 2.0f) + b;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        double radius = this.getRadius(0.0f);
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - radius), (double)((double)this.field_145848_d - radius), (double)((double)this.field_145849_e - radius), (double)((double)this.field_145851_c + 1.0 + radius), (double)((double)this.field_145848_d + 2.0 + radius), (double)((double)this.field_145849_e + 1.0 + radius));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuel = nbt.func_74760_g("fuel");
        this.hasShimmerstone = nbt.func_74767_n("hasShimmerstone");
        this.deployTicks = nbt.func_74762_e("deployTicks");
        this.radius = nbt.func_74760_g("radius");
        this.prevRunning = this.running = nbt.func_74767_n("running");
        this.radiusState = nbt.func_74762_e("radiusState");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("fuel", this.fuel);
        nbt.func_74757_a("hasShimmerstone", this.hasShimmerstone);
        nbt.func_74768_a("deployTicks", this.deployTicks);
        nbt.func_74776_a("radius", this.radius);
        nbt.func_74757_a("running", this.running);
        nbt.func_74768_a("radiusState", this.radiusState);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("hasShimmerstone", this.hasShimmerstone);
        nbt.func_74757_a("running", this.running);
        nbt.func_74768_a("deployTicks", this.deployTicks);
        nbt.func_74776_a("radius", this.radius);
        nbt.func_74768_a("radiusState", this.radiusState);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        this.hasShimmerstone = nbt.func_74767_n("hasShimmerstone");
        this.deployTicks = nbt.func_74762_e("deployTicks");
        this.radius = nbt.func_74760_g("radius");
        this.prevRunning = this.running = nbt.func_74767_n("running");
        this.radiusState = nbt.func_74762_e("radiusState");
    }
}

