/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.tileentities;

import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thebetweenlands.blocks.BLFluidRegistry;
import thebetweenlands.inventory.container.ContainerPurifier;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.recipes.purifier.PurifierRecipe;
import thebetweenlands.tileentities.TileEntityBasicInventory;

public class TileEntityPurifier
extends TileEntityBasicInventory
implements IFluidHandler {
    public final FluidTank waterTank = new FluidTank(16000);
    public int time = 0;
    private static final int MAX_TIME = 432;
    public boolean lightOn = false;
    private int prevStackSize = 0;
    private Item prevItem;
    private boolean client_isPurifying = false;

    public TileEntityPurifier() {
        super(3, "container.purifier");
        this.waterTank.setFluid(new FluidStack(BLFluidRegistry.swampWater, 0));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == BLFluidRegistry.swampWater) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] infos = new FluidTankInfo[]{new FluidTankInfo(this.waterTank.getFluid(), this.waterTank.getCapacity())};
        return infos;
    }

    public ItemStack fillTankWithBucket(ItemStack bucket) {
        int amountFilled;
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)bucket);
        if (fluid != null && (amountFilled = this.fill(ForgeDirection.UNKNOWN, fluid, false)) == fluid.amount) {
            this.fill(ForgeDirection.UNKNOWN, fluid, true);
            return FluidContainerRegistry.drainFluidContainer((ItemStack)bucket);
        }
        return bucket;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        this.lightOn = nbt.func_74767_n("state");
        this.time = nbt.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74757_a("state", this.lightOn);
        nbt.func_74768_a("progress", this.time);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("state", this.lightOn);
        nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        NBTTagCompound itemStackCompound = new NBTTagCompound();
        if (this.inventory[2] != null) {
            this.inventory[2].func_77955_b(itemStackCompound);
        }
        nbt.func_74782_a("outputItem", (NBTBase)itemStackCompound);
        nbt.func_74757_a("isPurifying", this.isPurifying());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.lightOn = packet.func_148857_g().func_74767_n("state");
        this.waterTank.readFromNBT(packet.func_148857_g().func_74775_l("waterTank"));
        NBTTagCompound itemStackCompound = packet.func_148857_g().func_74775_l("outputItem");
        this.inventory[2] = itemStackCompound.func_74765_d("id") != 0 ? ItemStack.func_77949_a((NBTTagCompound)itemStackCompound) : null;
        this.client_isPurifying = packet.func_148857_g().func_74767_n("isPurifying");
    }

    public int getPurifyingProgress() {
        return this.time / 36;
    }

    public boolean isPurifying() {
        return this.time > 0 || this.client_isPurifying;
    }

    public int getWaterAmount() {
        return this.waterTank.getFluidAmount();
    }

    public int getTanksFullValue() {
        return this.waterTank.getCapacity();
    }

    public int getScaledWaterAmount(int scale) {
        return this.waterTank.getFluid() != null ? (int)((float)this.waterTank.getFluid().amount / (float)this.waterTank.getCapacity() * (float)scale) : 0;
    }

    public void getGUIData(int id, int value) {
        switch (id) {
            case 0: {
                this.time = value;
                break;
            }
            case 1: {
                if (this.waterTank.getFluid() == null) {
                    this.waterTank.setFluid(new FluidStack(BLFluidRegistry.swampWater, value));
                    break;
                }
                this.waterTank.getFluid().amount = value;
            }
        }
    }

    public void sendGUIData(ContainerPurifier purifier, ICrafting craft) {
        craft.func_71112_a((Container)purifier, 0, this.time);
        craft.func_71112_a((Container)purifier, 1, this.waterTank.getFluid() != null ? this.waterTank.getFluid().amount : 0);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack output = PurifierRecipe.getRecipeOutput(this.inventory[1]);
        if (this.hasFuel() && !this.outputIsFull() && (output != null && this.getWaterAmount() > 0 && this.inventory[2] == null || output != null && this.getWaterAmount() > 0 && this.inventory[2] != null && this.inventory[2].func_77969_a(output))) {
            ++this.time;
            if (this.time % 108 == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "thebetweenlands:purifier", 1.0f, 1.0f);
            }
            if (!this.lightOn) {
                this.setIlluminated(true);
            }
            if (this.time >= 432) {
                boolean canRun;
                for (int i = 0; i < 2; ++i) {
                    if (this.inventory[i] == null || --this.inventory[i].field_77994_a > 0) continue;
                    this.inventory[i] = null;
                }
                this.extractFluids(new FluidStack(BLFluidRegistry.swampWater, 1000));
                if (this.inventory[2] == null) {
                    this.inventory[2] = output.func_77946_l();
                } else if (this.inventory[2].func_77969_a(output)) {
                    this.inventory[2].field_77994_a += output.field_77994_a;
                }
                this.time = 0;
                this.func_70296_d();
                boolean bl = canRun = output != null && this.getWaterAmount() > 0 && this.inventory[2] == null || output != null && this.getWaterAmount() > 0 && this.inventory[2] != null && this.inventory[2].func_77969_a(output);
                if (!canRun) {
                    this.setIlluminated(false);
                }
            }
        }
        if (this.time > 0) {
            this.func_70296_d();
        }
        if (this.func_70301_a(0) == null || this.func_70301_a(1) == null || this.outputIsFull()) {
            this.time = 0;
            this.func_70296_d();
            this.setIlluminated(false);
        }
        if (this.prevStackSize != (this.inventory[2] != null ? this.inventory[2].field_77994_a : 0)) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.prevItem != (this.inventory[2] != null ? this.inventory[2].func_77973_b() : null)) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.prevItem = this.inventory[2] != null ? this.inventory[2].func_77973_b() : null;
        this.prevStackSize = this.inventory[2] != null ? this.inventory[2].field_77994_a : 0;
    }

    private void extractFluids(FluidStack fluid) {
        if (fluid.isFluidEqual(this.waterTank.getFluid())) {
            this.waterTank.drain(fluid.amount, true);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean hasFuel() {
        return this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() == BLItemRegistry.itemsGeneric && this.func_70301_a(0).func_77960_j() == ItemGeneric.EnumItemGeneric.SULFUR.id && this.func_70301_a((int)0).field_77994_a >= 1;
    }

    private boolean outputIsFull() {
        return this.func_70301_a(2) != null && this.func_70301_a((int)2).field_77994_a >= this.func_70297_j_();
    }

    public void setIlluminated(boolean state) {
        this.lightOn = state;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, this.lightOn ? 1 : 0);
    }

    public boolean func_145842_c(int eventId, int eventData) {
        switch (eventId) {
            case 0: {
                this.lightOn = eventData == 1;
                this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 0) {
            return new int[]{2};
        }
        if (side == 1) {
            return new int[]{1};
        }
        return new int[]{0};
    }
}

