/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.tileentities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.utils.AnimationMathHelper;

public class TileEntityPossessedBlock
extends TileEntity {
    public int animationTicks;
    public int coolDown;
    public boolean active;
    AnimationMathHelper headShake = new AnimationMathHelper();
    public float moveProgress;

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.findEnemyToAttack();
            if (this.active) {
                this.activateBlock();
                if (this.animationTicks == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "thebetweenlands:possessedScream", 0.25f, 1.25f);
                }
                if (this.animationTicks <= 24) {
                    ++this.animationTicks;
                }
                if (this.animationTicks == 24) {
                    this.setActive(false);
                    this.coolDown = 200;
                }
            }
            if (!this.active) {
                if (this.animationTicks >= 1) {
                    --this.animationTicks;
                }
                if (this.coolDown >= 0) {
                    --this.coolDown;
                }
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.moveProgress = 1.0f + this.headShake.swing(4.0f, 1.0f, false);
        if (this.field_145850_b.field_72995_K && !this.active && this.animationTicks % 8 > 0) {
            this.spawnParticles();
        }
    }

    private void spawnParticles() {
        int meta = this.func_145832_p();
        float x = 0.0f;
        float z = 0.0f;
        if (meta == 4) {
            x = -1.0f;
        }
        if (meta == 5) {
            x = 1.0f;
        }
        if (meta == 2) {
            z = -1.0f;
        }
        if (meta == 3) {
            z = 1.0f;
        }
        float xx = (float)this.field_145851_c + 0.5f + x;
        float yy = (float)this.field_145848_d + 0.5f;
        float zz = (float)this.field_145849_e + 0.5f + z;
        float randomOffset = this.field_145850_b.field_73012_v.nextFloat() * 0.6f - 0.3f;
        BLParticle.SMOKE.spawn(this.field_145850_b, xx - randomOffset, yy + randomOffset, zz + randomOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
        BLParticle.SMOKE.spawn(this.field_145850_b, xx + randomOffset, yy - randomOffset, zz + randomOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
        BLParticle.SMOKE.spawn(this.field_145850_b, xx + randomOffset, yy + randomOffset, zz - randomOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
        BLParticle.SMOKE.spawn(this.field_145850_b, xx + randomOffset, yy - randomOffset, zz + randomOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    protected Entity findEnemyToAttack() {
        int meta = this.func_145832_p();
        float x = 0.0f;
        float z = 0.0f;
        if (meta == 4) {
            x = -1.25f;
        }
        if (meta == 5) {
            x = 1.25f;
        }
        if (meta == 2) {
            z = -1.25f;
        }
        if (meta == 3) {
            z = 1.25f;
        }
        List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + x), (double)this.field_145848_d, (double)((float)this.field_145849_e + z), (double)((double)this.field_145851_c + 1.0 + (double)x), (double)((double)this.field_145848_d + 1.0), (double)((double)this.field_145849_e + 1.0 + (double)z)));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityPlayer) || this.active || this.animationTicks != 0 || this.coolDown > 0) continue;
            this.setActive(true);
        }
        return null;
    }

    protected Entity activateBlock() {
        int meta = this.func_145832_p();
        float x = 0.0f;
        float z = 0.0f;
        if (meta == 4) {
            x = -1.25f;
        }
        if (meta == 5) {
            x = 1.25f;
        }
        if (meta == 2) {
            z = -1.25f;
        }
        if (meta == 3) {
            z = 1.25f;
        }
        List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + x), (double)this.field_145848_d, (double)((float)this.field_145849_e + z), (double)((double)this.field_145851_c + 1.0 + (double)x), (double)((double)this.field_145848_d + 1.0), (double)((double)this.field_145849_e + 1.0 + (double)z)));
        if (this.animationTicks == 1) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity == null || !(entity instanceof EntityPlayer)) continue;
                int Knockback = 4;
                entity.func_70024_g((double)(MathHelper.func_76126_a((float)(entity.field_70177_z * 3.141593f / 180.0f)) * (float)Knockback * 0.2f), 0.3, (double)(-MathHelper.func_76134_b((float)(entity.field_70177_z * 3.141593f / 180.0f)) * (float)Knockback * 0.2f));
                ((EntityLivingBase)entity).func_70097_a(DamageSource.field_76377_j, 2.0f);
            }
        }
        return null;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("animationTicks", this.animationTicks);
        nbt.func_74757_a("active", this.active);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.animationTicks = nbt.func_74762_e("animationTicks");
        this.active = nbt.func_74767_n("active");
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("animationTicks", this.animationTicks);
        nbt.func_74757_a("active", this.active);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.animationTicks = packet.func_148857_g().func_74762_e("animationTicks");
        this.active = packet.func_148857_g().func_74767_n("active");
    }
}

