/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.tileentities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thebetweenlands.blocks.BLFluidRegistry;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.mobs.EntityGasCloud;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.herblore.elixirs.ElixirRecipe;
import thebetweenlands.herblore.elixirs.ElixirRecipes;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.tileentities.TileEntityBasicInventory;
import thebetweenlands.utils.ColorUtils;

public class TileEntityInfuser
extends TileEntityBasicInventory
implements IFluidHandler {
    public static final int MAX_INGREDIENTS = 6;
    public final FluidTank waterTank = new FluidTank(3000);
    private int infusionTime = 0;
    private int stirProgress = 90;
    private int temp = 0;
    private int evaporation = 0;
    private int itemBob = 0;
    private boolean countUp = true;
    private boolean hasInfusion = false;
    private boolean hasCrystal = false;
    private float crystalVelocity = 0.0f;
    private float crystalRotation = 0.0f;
    private ElixirRecipe infusingRecipe = null;
    private boolean updateRecipe = false;
    private int currentInfusionState = 0;
    private int prevInfusionState = 0;
    private int infusionColorGradientTicks = 0;
    public float[] prevInfusionColor = new float[4];
    public float[] currentInfusionColor = new float[4];
    private float[] currentInfusionColorState2 = new float[4];

    public TileEntityInfuser() {
        super(8, "infuser");
        this.waterTank.setFluid(new FluidStack(BLFluidRegistry.swampWater, 0));
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (this.updateRecipe) {
            this.updateInfusingRecipe();
            this.updateRecipe = false;
        }
        boolean updateBlock = false;
        if (this.hasInfusion && this.infusingRecipe != null) {
            if (!this.field_145850_b.field_72995_K) {
                ++this.infusionTime;
            } else if (this.prevInfusionState != this.currentInfusionState) {
                if (this.currentInfusionState == 2) {
                    this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "thebetweenlands:infuserFinished", 1.0f, 1.0f, false);
                }
                this.prevInfusionColor = this.currentInfusionColor;
                this.currentInfusionColor = ElixirRecipe.getInfusionColor(this.infusingRecipe, this.infusionTime);
            } else {
                this.currentInfusionColor = ElixirRecipe.getInfusionColor(this.infusingRecipe, this.infusionTime);
            }
            this.prevInfusionState = this.currentInfusionState;
            if (!this.field_145850_b.field_72995_K) {
                if (this.infusionTime > this.infusingRecipe.idealInfusionTime + this.infusingRecipe.infusionTimeVariation) {
                    if (this.currentInfusionState != 3) {
                        updateBlock = true;
                    }
                    this.currentInfusionState = 3;
                } else if (this.infusionTime > this.infusingRecipe.idealInfusionTime - this.infusingRecipe.infusionTimeVariation && this.infusionTime < this.infusingRecipe.idealInfusionTime + this.infusingRecipe.infusionTimeVariation) {
                    if (this.currentInfusionState != 2) {
                        updateBlock = true;
                    }
                    this.currentInfusionState = 2;
                } else {
                    if (this.currentInfusionState != 1) {
                        updateBlock = true;
                    }
                    this.currentInfusionState = 1;
                }
            }
            if (this.infusionColorGradientTicks > 0) {
                ++this.infusionColorGradientTicks;
            }
            if (!this.field_145850_b.field_72995_K && this.currentInfusionState != this.prevInfusionState) {
                this.infusionColorGradientTicks = 1;
                updateBlock = true;
            }
            if (!this.field_145850_b.field_72995_K && this.infusionColorGradientTicks > 30) {
                this.infusionColorGradientTicks = 0;
                updateBlock = true;
            }
            if (this.field_145850_b.field_72995_K && this.infusionColorGradientTicks > 0 && this.field_145850_b.field_72995_K && this.currentInfusionState == 2) {
                for (int i = 0; i < 10; ++i) {
                    double x = (float)this.field_145851_c + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f;
                    double z = (float)this.field_145849_e + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f;
                    BLParticle.STEAM_PURIFIER.spawn(this.field_145850_b, x, (double)this.field_145848_d + 1.0 - (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f), z, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                }
            }
        } else {
            if (this.currentInfusionState != 0) {
                updateBlock = true;
            }
            this.currentInfusionState = 0;
            this.infusionTime = 0;
            this.currentInfusionColor = new float[]{0.2f, 0.6f, 0.4f, 1.0f};
            this.prevInfusionColor = this.currentInfusionColor;
        }
        if (!this.field_145850_b.field_72995_K && updateBlock) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.isValidCrystalInstalled()) {
                this.crystalVelocity -= Math.signum(this.crystalVelocity) * 0.05f;
                this.crystalRotation += this.crystalVelocity;
                if (this.crystalRotation >= 360.0f) {
                    this.crystalRotation -= 360.0f;
                } else if (this.crystalRotation <= 360.0f) {
                    this.crystalRotation += 360.0f;
                }
                if (Math.abs(this.crystalVelocity) <= 1.0f && this.func_145831_w().field_73012_v.nextInt(15) == 0) {
                    this.crystalVelocity = this.field_145850_b.field_73012_v.nextFloat() * 18.0f - 9.0f;
                }
            }
            if (this.countUp && this.itemBob <= 20) {
                ++this.itemBob;
                if (this.itemBob == 20) {
                    this.countUp = false;
                }
            }
            if (!this.countUp && this.itemBob >= 0) {
                --this.itemBob;
                if (this.itemBob == 0) {
                    this.countUp = true;
                }
            }
            return;
        }
        if (this.infusionTime % 20 == 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.stirProgress < 90) {
            ++this.stirProgress;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.stirProgress == 89) {
            if (this.temp == 100 && !this.hasInfusion && this.hasIngredients()) {
                this.hasInfusion = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.evaporation = 0;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == Blocks.field_150480_ab && this.temp < 100 && this.getWaterAmount() > 0 && this.field_145850_b.func_72820_D() % 12L == 0L) {
            ++this.temp;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != Blocks.field_150480_ab && this.temp > 0 && this.field_145850_b.func_72820_D() % 6L == 0L) {
            --this.temp;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.temp == 100) {
            ++this.evaporation;
            if (this.evaporation == 600 && this.getWaterAmount() >= 1000) {
                this.extractFluids(new FluidStack(BLFluidRegistry.swampWater, 1000));
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.temp < 100 && this.evaporation > 0) {
            --this.evaporation;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.isValidCrystalInstalled()) {
            if (this.temp >= 100 && this.evaporation >= 400 && this.stirProgress >= 90 && this.hasInfusion) {
                this.inventory[7].func_77964_b(this.inventory[7].func_77960_j() + 1);
                this.stirProgress = 0;
            }
            this.hasCrystal = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            this.hasCrystal = false;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getInfusingState() {
        return this.currentInfusionState;
    }

    public int getInfusionColorGradientTicks() {
        return this.infusionColorGradientTicks;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == BLFluidRegistry.swampWater) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] infos = new FluidTankInfo[]{new FluidTankInfo(this.waterTank.getFluid(), this.waterTank.getCapacity())};
        return infos;
    }

    public ItemStack fillTankWithBucket(ItemStack bucket) {
        int amountFilled;
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)bucket);
        if (fluid != null && (amountFilled = this.fill(ForgeDirection.UNKNOWN, fluid, false)) == fluid.amount) {
            this.fill(ForgeDirection.UNKNOWN, fluid, true);
            if (this.temp >= 3) {
                this.temp -= this.temp / 3;
                this.evaporation = 0;
            }
            return FluidContainerRegistry.drainFluidContainer((ItemStack)bucket);
        }
        return bucket;
    }

    public void extractFluids(FluidStack fluid) {
        if (fluid.isFluidEqual(this.waterTank.getFluid())) {
            this.waterTank.drain(fluid.amount, true);
        }
        if (this.getWaterAmount() == 0) {
            if (this.hasInfusion) {
                for (int i = 0; i <= 6; ++i) {
                    ItemStack stack = this.func_70301_a(i);
                    if (stack != null && stack.func_77973_b() == BLItemRegistry.aspectVial) {
                        ItemStack ret = null;
                        switch (stack.func_77960_j()) {
                            default: {
                                ret = new ItemStack((Item)BLItemRegistry.dentrothystVial, 1, 0);
                                break;
                            }
                            case 1: {
                                ret = new ItemStack((Item)BLItemRegistry.dentrothystVial, 1, 2);
                            }
                        }
                        EntityItem entity = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5, ret);
                        this.field_145850_b.func_72838_d((Entity)entity);
                    }
                    this.func_70299_a(i, null);
                }
                if (this.evaporation == 600) {
                    EntityGasCloud gasCloud = new EntityGasCloud(this.field_145850_b);
                    if (this.infusingRecipe != null) {
                        float[] color = ElixirRecipe.getInfusionColor(this.infusingRecipe, this.infusionTime);
                        gasCloud.setGasColor(ColorUtils.toHex(color[0], color[1], color[2], 0.66f));
                    }
                    gasCloud.func_70012_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    this.field_145850_b.func_72838_d((Entity)gasCloud);
                }
                this.infusingRecipe = null;
            }
            this.hasInfusion = false;
            this.temp = 0;
        }
        this.evaporation = 0;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getWaterAmount() {
        return this.waterTank.getFluidAmount();
    }

    public int getTanksFullValue() {
        return this.waterTank.getCapacity();
    }

    public int getScaledWaterAmount(int scale) {
        return this.waterTank.getFluid() != null ? (int)((float)this.waterTank.getFluid().amount / (float)this.waterTank.getCapacity() * (float)scale) : 0;
    }

    public boolean isValidCrystalInstalled() {
        return this.inventory[7] != null && this.inventory[7].func_77973_b() == BLItemRegistry.lifeCrystal && this.inventory[7].func_77960_j() < this.inventory[7].func_77958_k();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("stirProgress", this.stirProgress);
        nbt.func_74768_a("evaporation", this.evaporation);
        nbt.func_74768_a("temp", this.temp);
        nbt.func_74768_a("infusionTime", this.infusionTime);
        nbt.func_74757_a("hasInfusion", this.hasInfusion);
        nbt.func_74757_a("hasCrystal", this.hasCrystal);
        nbt.func_74768_a("infusionState", this.currentInfusionState);
        nbt.func_74768_a("infusionColorGradientTicks", this.infusionColorGradientTicks);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        this.stirProgress = nbt.func_74762_e("stirProgress");
        this.evaporation = nbt.func_74762_e("evaporation");
        this.temp = nbt.func_74762_e("temp");
        this.infusionTime = nbt.func_74762_e("infusionTime");
        this.hasInfusion = nbt.func_74767_n("hasInfusion");
        this.hasCrystal = nbt.func_74767_n("hasCrystal");
        this.currentInfusionState = nbt.func_74762_e("infusionState");
        this.infusionColorGradientTicks = nbt.func_74762_e("infusionColorGradientTicks");
        this.updateRecipe = true;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("stirProgress", this.stirProgress);
        nbt.func_74768_a("evaporation", this.evaporation);
        nbt.func_74768_a("temp", this.temp);
        nbt.func_74768_a("infusionTime", this.infusionTime);
        nbt.func_74757_a("hasInfusion", this.hasInfusion);
        nbt.func_74757_a("hasCrystal", this.hasCrystal);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            NBTTagCompound itemStackCompound = new NBTTagCompound();
            if (this.inventory[i] != null) {
                this.inventory[i].func_77955_b(itemStackCompound);
            }
            nbt.func_74782_a("slotItem" + i, (NBTBase)itemStackCompound);
        }
        nbt.func_74768_a("infusionState", this.currentInfusionState);
        nbt.func_74768_a("infusionColorGradientTicks", this.infusionColorGradientTicks);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.waterTank.readFromNBT(packet.func_148857_g().func_74775_l("waterTank"));
        this.stirProgress = packet.func_148857_g().func_74762_e("stirProgress");
        this.evaporation = packet.func_148857_g().func_74762_e("evaporation");
        this.temp = packet.func_148857_g().func_74762_e("temp");
        this.infusionTime = packet.func_148857_g().func_74762_e("infusionTime");
        this.hasInfusion = packet.func_148857_g().func_74767_n("hasInfusion");
        this.hasCrystal = packet.func_148857_g().func_74767_n("hasCrystal");
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            NBTTagCompound itemStackCompound = packet.func_148857_g().func_74775_l("slotItem" + i);
            this.inventory[i] = itemStackCompound != null && itemStackCompound.func_74765_d("id") != 0 ? ItemStack.func_77949_a((NBTTagCompound)itemStackCompound) : null;
        }
        this.currentInfusionState = packet.func_148857_g().func_74762_e("infusionState");
        this.infusionColorGradientTicks = packet.func_148857_g().func_74762_e("infusionColorGradientTicks");
        this.updateInfusingRecipe();
    }

    public boolean hasIngredients() {
        for (int i = 0; i <= 6; ++i) {
            if (this.inventory[i] == null) continue;
            return true;
        }
        return false;
    }

    public List<IAspectType> getInfusingAspects() {
        ArrayList<IAspectType> infusingAspects = new ArrayList<IAspectType>();
        for (int i = 0; i <= 6; ++i) {
            if (this.inventory[i] == null) continue;
            infusingAspects.addAll(AspectManager.get(this.field_145850_b).getDiscoveredAspectTypes(this.inventory[i], null));
        }
        return infusingAspects;
    }

    public boolean hasFullIngredients() {
        for (int i = 0; i <= 6; ++i) {
            if (this.inventory[i] != null) continue;
            return false;
        }
        return true;
    }

    public int getInfusionTime() {
        return this.infusionTime;
    }

    public float getCrystalRotation() {
        return this.crystalRotation;
    }

    public int getEvaporation() {
        return this.evaporation;
    }

    public boolean hasInfusion() {
        return this.hasInfusion;
    }

    public int getItemBob() {
        return this.itemBob;
    }

    public int getStirProgress() {
        return this.stirProgress;
    }

    public int getTemperature() {
        return this.temp;
    }

    public void setStirProgress(int progress) {
        this.stirProgress = progress;
    }

    public ElixirRecipe getInfusingRecipe() {
        return this.infusingRecipe;
    }

    public void updateInfusingRecipe() {
        if (this.field_145850_b != null) {
            this.infusingRecipe = ElixirRecipes.getFromAspects(this.getInfusingAspects());
        }
    }
}

