/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.tileentities;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import thebetweenlands.herblore.aspects.AspectRegistry;
import thebetweenlands.herblore.aspects.IAspectType;

public class TileEntityGeckoCage
extends TileEntity {
    private int ticks = 0;
    private int prevTicks = 0;
    private int recoverTicks = 0;
    private IAspectType aspectType = null;
    private int geckoUsages = 0;

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        this.prevTicks = this.ticks++;
        if (!this.field_145850_b.field_72995_K) {
            if (this.recoverTicks > 0) {
                --this.recoverTicks;
                if (this.recoverTicks == 0) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else {
                if (this.aspectType != null && this.geckoUsages > 0) {
                    --this.geckoUsages;
                    if (this.geckoUsages == 0) {
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
                if (this.aspectType != null) {
                    this.aspectType = null;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
    }

    public int getTicks() {
        return this.ticks;
    }

    public float getInterpolatedTicks(float delta) {
        return (float)this.prevTicks + (float)(this.ticks - this.prevTicks) * delta;
    }

    public IAspectType getAspectType() {
        return this.aspectType;
    }

    public void setAspectType(IAspectType type, int recoverTime) {
        this.aspectType = type;
        this.recoverTicks = recoverTime;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean hasGecko() {
        return this.geckoUsages > 0;
    }

    public void addGecko(int usages) {
        this.geckoUsages = usages;
        this.ticks = 0;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("recoverTicks", this.recoverTicks);
        nbt.func_74768_a("geckoUsages", this.geckoUsages);
        nbt.func_74778_a("aspectType", this.aspectType == null ? "" : this.aspectType.getName());
        nbt.func_74768_a("ticks", this.ticks);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.recoverTicks = nbt.func_74762_e("recoverTicks");
        this.geckoUsages = nbt.func_74762_e("geckoUsages");
        this.aspectType = AspectRegistry.getAspectTypeFromName(nbt.func_74779_i("aspectType"));
        this.ticks = nbt.func_74762_e("ticks");
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("geckoUsages", this.geckoUsages);
        nbt.func_74778_a("aspectType", this.aspectType == null ? "" : this.aspectType.getName());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        this.geckoUsages = nbt.func_74762_e("geckoUsages");
        this.aspectType = AspectRegistry.getAspectTypeFromName(nbt.func_74779_i("aspectType"));
    }
}

