/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.tileentities;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.network.base.SubscribePacket;
import thebetweenlands.network.packet.server.PacketDruidAltarProgress;
import thebetweenlands.recipes.misc.DruidAltarRecipe;
import thebetweenlands.tileentities.TileEntityBasicInventory;

public class TileEntityDruidAltar
extends TileEntityBasicInventory {
    @SideOnly(value=Side.CLIENT)
    public float rotation;
    @SideOnly(value=Side.CLIENT)
    public float prevRotation;
    @SideOnly(value=Side.CLIENT)
    public float renderYOffset;
    @SideOnly(value=Side.CLIENT)
    public float prevRenderYOffset;
    @SideOnly(value=Side.CLIENT)
    private static final float ROTATION_SPEED = 2.0f;
    @SideOnly(value=Side.CLIENT)
    public static final double FINAL_HEIGHT = 2.0;
    public int craftingProgress = 0;
    private boolean circleShouldRevert = true;
    private int[] damageValues = new int[]{0, 0, 0, 0};
    public static final int CRAFTING_TIME = 285;

    public TileEntityDruidAltar() {
        super(5, "druidAltar");
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.circleShouldRevert) {
            this.checkDruidCircleMeta(this.field_145850_b);
            this.circleShouldRevert = false;
        }
        if (this.field_145850_b.field_72995_K) {
            this.prevRotation = this.rotation;
            this.rotation += 2.0f;
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
            if (this.craftingProgress != 0) {
                ++this.craftingProgress;
            }
            this.prevRenderYOffset = this.renderYOffset;
            this.renderYOffset = (float)((double)this.craftingProgress / 285.0 * 2.0 + 1.0);
        } else if (this.craftingProgress != 0) {
            DruidAltarRecipe recipe = DruidAltarRecipe.getOutput(this.inventory[1], this.inventory[2], this.inventory[3], this.inventory[4]);
            if (this.craftingProgress % 20 == 0 || this.craftingProgress == 1) {
                this.sendCraftingProgressPacket();
            }
            ++this.craftingProgress;
            if ((recipe == null || this.inventory[0] != null) && this.craftingProgress != 0) {
                this.stopCraftingProcess();
            }
            if (this.craftingProgress >= 285 && recipe != null) {
                ItemStack stack = recipe.output;
                this.func_70299_a(1, null);
                this.func_70299_a(2, null);
                this.func_70299_a(3, null);
                this.func_70299_a(4, null);
                this.func_70299_a(0, stack);
                this.stopCraftingProcess();
                this.removeSpawner();
            }
        }
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    private void removeSpawner() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == BLBlockRegistry.druidSpawner) {
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, (Block)Blocks.field_150349_c);
        }
    }

    @Override
    public void func_70299_a(int slot, ItemStack is) {
        DruidAltarRecipe recipe;
        this.inventory[slot] = is;
        if (is != null && is.field_77994_a > this.func_70297_j_()) {
            is.field_77994_a = this.func_70297_j_();
        }
        if ((recipe = DruidAltarRecipe.getOutput(this.inventory[1], this.inventory[2], this.inventory[3], this.inventory[4])) != null && is != null && this.inventory[0] == null && !this.field_145850_b.field_72995_K && this.craftingProgress == 0) {
            this.startCraftingProcess();
        }
    }

    private void startCraftingProcess() {
        World world = this.func_145831_w();
        int dim = 0;
        if (world instanceof WorldServer) {
            dim = ((WorldServer)world).field_73011_w.field_76574_g;
        }
        this.craftingProgress = 1;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketDruidAltarProgress(this, -1)), new NetworkRegistry.TargetPoint(dim, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 64.0));
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketDruidAltarProgress(this, 1)), new NetworkRegistry.TargetPoint(dim, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 64.0));
        this.checkDruidCircleMeta(world);
    }

    private void stopCraftingProcess() {
        World world = this.func_145831_w();
        int dim = 0;
        if (world instanceof WorldServer) {
            dim = ((WorldServer)world).field_73011_w.field_76574_g;
        }
        this.craftingProgress = 0;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketDruidAltarProgress(this, -2)), new NetworkRegistry.TargetPoint(dim, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 64.0));
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketDruidAltarProgress(this, 0)), new NetworkRegistry.TargetPoint(dim, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 64.0));
        this.checkDruidCircleMeta(world);
    }

    public void sendCraftingProgressPacket() {
        World world = this.func_145831_w();
        int dim = 0;
        if (world instanceof WorldServer) {
            dim = ((WorldServer)world).field_73011_w.field_76574_g;
        }
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketDruidAltarProgress(this)), new NetworkRegistry.TargetPoint(dim, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 64.0));
    }

    @SubscribePacket
    public static void onProgressPacket(PacketDruidAltarProgress pkt) {
        TileEntity te = FMLClientHandler.instance().getWorldClient().func_147438_o(pkt.x, pkt.y, pkt.z);
        if (te instanceof TileEntityDruidAltar) {
            TileEntityDruidAltar tile = (TileEntityDruidAltar)te;
            if (pkt.progress >= 0) {
                tile.craftingProgress = pkt.progress;
            }
        }
    }

    private void checkDruidCircleMeta(World world) {
        int baseRadius = 6;
        for (int y = 0; y < 6; ++y) {
            for (int x = baseRadius * -1; x <= baseRadius; ++x) {
                for (int z = baseRadius * -1; z <= baseRadius; ++z) {
                    Block block;
                    double dSq = x * x + z * z;
                    if (Math.round(Math.sqrt(dSq)) != (long)baseRadius || (block = world.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z)) != BLBlockRegistry.druidStone1 && block != BLBlockRegistry.druidStone2 && block != BLBlockRegistry.druidStone3 && block != BLBlockRegistry.druidStone4 && block != BLBlockRegistry.druidStone5) continue;
                    int meta = world.func_72805_g(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
                    if (this.craftingProgress == 0 && meta >= 4 || this.circleShouldRevert && meta >= 4) {
                        world.func_72921_c(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, meta - 4, 3);
                        continue;
                    }
                    if (this.craftingProgress != 1 || meta >= 4) continue;
                    world.func_72921_c(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, meta + 4, 3);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        if (packet.func_148853_f() == 0) {
            this.func_145839_a(packet.func_148857_g());
        }
    }
}

