/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.tileentities;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityCompostBin
extends TileEntity {
    public static final int MAX_COMPOST_AMOUNT = 200;
    public static final int COMPOST_PER_ITEM = 25;
    public static final int MAX_ITEMS = 20;
    public static final float MAX_OPEN = 90.0f;
    public static final float MIN_OPEN = 0.0f;
    public static final float OPEN_SPEED = 10.0f;
    public static final float CLOSE_SPEED = 10.0f;
    public int compostedAmount;
    public int totalCompostAmount;
    public boolean open = false;
    public float lidAngle = 0.0f;
    private ItemStack[] inventory = new ItemStack[20];
    private int[] processes = new int[20];
    private int[] compostAmounts = new int[20];
    private int[] compostTimes = new int[20];

    public static int[] readIntArrayFixedSize(String id, int length, NBTTagCompound compound) {
        int[] array = compound.func_74759_k(id);
        return array.length != length ? new int[length] : array;
    }

    public void func_145845_h() {
        float f = this.lidAngle = this.open ? Math.min(this.lidAngle + 10.0f, 90.0f) : Math.max(this.lidAngle - 10.0f, 0.0f);
        if (!this.field_145850_b.field_72995_K) {
            int i;
            if (!this.open) {
                for (i = 0; i < this.inventory.length; ++i) {
                    if (this.inventory[i] == null) continue;
                    if (this.processes[i] >= this.compostTimes[i]) {
                        this.compostedAmount += this.compostAmounts[i];
                        this.inventory[i] = null;
                        this.processes[i] = 0;
                        this.compostTimes[i] = 0;
                        this.compostAmounts[i] = 0;
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.func_70296_d();
                        continue;
                    }
                    int n = i;
                    this.processes[n] = this.processes[n] + 1;
                }
            }
            for (i = 1; i < this.inventory.length; ++i) {
                if (this.inventory[i - 1] != null || this.inventory[i] == null) continue;
                this.inventory[i - 1] = this.inventory[i];
                this.inventory[i] = null;
                this.processes[i - 1] = this.processes[i];
                this.processes[i] = 0;
                this.compostAmounts[i - 1] = this.compostAmounts[i];
                this.compostAmounts[i] = 0;
                this.compostTimes[i - 1] = this.compostTimes[i];
                this.compostTimes[i] = 0;
            }
        }
    }

    public boolean removeCompost(int amount) {
        if (this.compostedAmount != 0) {
            if (this.compostedAmount >= amount) {
                this.compostedAmount -= amount;
                this.totalCompostAmount -= amount;
            } else {
                this.compostedAmount = 0;
                this.totalCompostAmount = 0;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public int addItemToBin(ItemStack stack, int compostAmount, int compostTime, boolean doSimulate) {
        if (this.getTotalCompostAmount() + compostAmount <= 200) {
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] != null) continue;
                if (!doSimulate) {
                    this.inventory[i] = stack.func_77946_l();
                    this.inventory[i].field_77994_a = 1;
                    this.compostAmounts[i] = compostAmount;
                    this.compostTimes[i] = compostTime;
                    this.processes[i] = 0;
                    this.totalCompostAmount += compostAmount;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.func_70296_d();
                }
                return 1;
            }
            return 0;
        }
        if (this.getTotalCompostAmount() < 200) {
            int newCompostAmount = 200 - this.totalCompostAmount;
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] != null) continue;
                if (!doSimulate) {
                    this.inventory[i] = stack.func_77946_l();
                    this.inventory[i].field_77994_a = 1;
                    this.compostAmounts[i] = newCompostAmount;
                    this.compostTimes[i] = compostTime;
                    this.processes[i] = 0;
                    this.totalCompostAmount += compostAmount;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.func_70296_d();
                }
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList inventoryTags = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.inventory.length];
        for (int i = 0; i < inventoryTags.func_74745_c(); ++i) {
            NBTTagCompound data = inventoryTags.func_150305_b(i);
            int j = data.func_74771_c("Slot") & 0xFF;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
        this.processes = TileEntityCompostBin.readIntArrayFixedSize("Processes", this.inventory.length, nbt);
        this.compostAmounts = TileEntityCompostBin.readIntArrayFixedSize("CompostAmounts", this.inventory.length, nbt);
        this.compostTimes = TileEntityCompostBin.readIntArrayFixedSize("CompostTimes", this.inventory.length, nbt);
        this.totalCompostAmount = nbt.func_74762_e("totalCompostAmount");
        this.compostedAmount = nbt.func_74762_e("compostedAmount");
        this.open = nbt.func_74767_n("open");
        this.lidAngle = nbt.func_74760_g("lidAngle");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList inventoryTags = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(data);
            inventoryTags.func_74742_a((NBTBase)data);
        }
        nbt.func_74783_a("Processes", this.processes);
        nbt.func_74783_a("CompostAmounts", this.compostAmounts);
        nbt.func_74783_a("CompostTimes", this.compostTimes);
        nbt.func_74768_a("totalCompostAmount", this.totalCompostAmount);
        nbt.func_74768_a("compostedAmount", this.compostedAmount);
        nbt.func_74782_a("Items", (NBTBase)inventoryTags);
        nbt.func_74757_a("open", this.open);
        nbt.func_74776_a("lidAngle", this.lidAngle);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean hasCompostableItems() {
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            return true;
        }
        return false;
    }

    public float getLidAngle(float lerp) {
        return this.open ? Math.min(this.lidAngle + 10.0f * lerp, 90.0f) : Math.max(this.lidAngle - 10.0f * lerp, 0.0f);
    }

    public int getTotalCompostAmount() {
        return this.totalCompostAmount;
    }

    public int getTotalCompostedAmount() {
        return this.compostedAmount;
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory[slot];
    }
}

