/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.tileentities;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import thebetweenlands.blocks.container.BlockBLDualFurnace;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;

public class TileEntityBLDualFurnace
extends TileEntity
implements ISidedInventory {
    private static final int[] slotsTop = new int[]{0, 4};
    private static final int[] slotsBottom = new int[]{2, 1, 6, 5};
    private static final int[] slotsSides = new int[]{1, 5, 3, 7};
    private ItemStack[] furnaceItemStacks = new ItemStack[8];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;
    public int furnaceBurnTime2;
    public int currentItemBurnTime2;
    public int furnaceCookTime2;
    private String customName;

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.furnaceItemStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.furnaceItemStacks[slot] != null) {
            if (this.furnaceItemStacks[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.furnaceItemStacks[slot];
                this.furnaceItemStacks[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.furnaceItemStacks[slot].func_77979_a(amount);
            if (this.furnaceItemStacks[slot].field_77994_a == 0) {
                this.furnaceItemStacks[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.furnaceItemStacks[slot] != null) {
            ItemStack itemstack = this.furnaceItemStacks[slot];
            this.furnaceItemStacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.furnaceItemStacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.dualFurnaceBL";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void getStackDisplayName(String name) {
        this.customName = name;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte slot = nbttagcompound1.func_74771_c("Slot");
            if (slot < 0 || slot >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[slot] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.furnaceBurnTime = nbt.func_74765_d("BurnTime");
        this.furnaceCookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityBLDualFurnace.getItemBurnTime(this.furnaceItemStacks[1]);
        this.furnaceBurnTime2 = nbt.func_74765_d("BurnTime2");
        this.furnaceCookTime2 = nbt.func_74765_d("CookTime2");
        this.currentItemBurnTime2 = TileEntityBLDualFurnace.getItemBurnTime(this.furnaceItemStacks[4]);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customName = nbt.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        nbt.func_74777_a("BurnTime2", (short)this.furnaceBurnTime2);
        nbt.func_74777_a("CookTime2", (short)this.furnaceCookTime2);
        NBTTagList nbttaglist = new NBTTagList();
        for (int slot = 0; slot < this.furnaceItemStacks.length; ++slot) {
            if (this.furnaceItemStacks[slot] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)slot);
            this.furnaceItemStacks[slot].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int count) {
        return this.furnaceCookTime * count / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int remainingTime) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * remainingTime / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled2(int count) {
        return this.furnaceCookTime2 * count / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled2(int remainingTime) {
        if (this.currentItemBurnTime2 == 0) {
            this.currentItemBurnTime2 = 200;
        }
        return this.furnaceBurnTime2 * remainingTime / this.currentItemBurnTime2;
    }

    public boolean isBurning2() {
        return this.furnaceBurnTime2 > 0;
    }

    public void func_145845_h() {
        boolean isBurning1 = this.furnaceBurnTime > 0;
        boolean isDirty1 = false;
        boolean isBurning2 = this.furnaceBurnTime2 > 0;
        boolean isDirty2 = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (this.furnaceBurnTime2 > 0) {
            --this.furnaceBurnTime2;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime != 0 || this.furnaceItemStacks[1] != null && this.furnaceItemStacks[0] != null) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityBLDualFurnace.getItemBurnTime(this.furnaceItemStacks[1]);
                    if (this.furnaceBurnTime > 0) {
                        isDirty1 = true;
                        if (this.furnaceItemStacks[1] != null) {
                            --this.furnaceItemStacks[1].field_77994_a;
                            if (this.furnaceItemStacks[1].field_77994_a == 0) {
                                this.furnaceItemStacks[1] = this.furnaceItemStacks[1].func_77973_b().getContainerItem(this.furnaceItemStacks[1]);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == 200) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                        isDirty1 = true;
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
            }
            if (this.furnaceBurnTime2 != 0 || this.furnaceItemStacks[5] != null && this.furnaceItemStacks[4] != null) {
                if (this.furnaceBurnTime2 == 0 && this.canSmelt2()) {
                    this.currentItemBurnTime2 = this.furnaceBurnTime2 = TileEntityBLDualFurnace.getItemBurnTime(this.furnaceItemStacks[5]);
                    if (this.furnaceBurnTime2 > 0) {
                        isDirty2 = true;
                        if (this.furnaceItemStacks[5] != null) {
                            --this.furnaceItemStacks[5].field_77994_a;
                            if (this.furnaceItemStacks[5].field_77994_a == 0) {
                                this.furnaceItemStacks[5] = this.furnaceItemStacks[5].func_77973_b().getContainerItem(this.furnaceItemStacks[5]);
                            }
                        }
                    }
                }
                if (this.isBurning2() && this.canSmelt2()) {
                    ++this.furnaceCookTime2;
                    if (this.furnaceCookTime2 == 200) {
                        this.furnaceCookTime2 = 0;
                        this.smeltItem2();
                        isDirty2 = true;
                    }
                } else {
                    this.furnaceCookTime2 = 0;
                }
            }
        }
        if (isBurning1 != this.furnaceBurnTime > 0 || isBurning2 != this.furnaceBurnTime2 > 0) {
            isDirty1 = true;
            isDirty2 = true;
            BlockBLDualFurnace.updateFurnaceBlockState(this.furnaceBurnTime > 0 || this.furnaceBurnTime2 > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (isDirty1 || isDirty2) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.furnaceItemStacks[2] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.furnaceItemStacks[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.furnaceItemStacks[2].func_77976_d();
    }

    private boolean canSmelt2() {
        if (this.furnaceItemStacks[4] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[4]);
        if (itemstack == null) {
            return false;
        }
        if (this.furnaceItemStacks[6] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[6].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.furnaceItemStacks[6].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.furnaceItemStacks[6].func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
            if (this.furnaceItemStacks[2] == null) {
                this.furnaceItemStacks[2] = itemstack.func_77946_l();
            } else if (this.furnaceItemStacks[2].func_77973_b() == itemstack.func_77973_b()) {
                this.furnaceItemStacks[2].field_77994_a += itemstack.field_77994_a;
            }
            if (BLItemRegistry.isIngotFromOre(this.furnaceItemStacks[0], this.furnaceItemStacks[2]) && this.furnaceItemStacks[3] != null) {
                boolean useFlux;
                boolean bl = useFlux = this.field_145850_b.field_73012_v.nextInt(3) == 0;
                if (useFlux && this.furnaceItemStacks[2].field_77994_a + 1 <= this.func_70297_j_() && this.furnaceItemStacks[2].field_77994_a + 1 <= this.furnaceItemStacks[2].func_77976_d()) {
                    ++this.furnaceItemStacks[2].field_77994_a;
                }
                --this.furnaceItemStacks[3].field_77994_a;
                if (this.furnaceItemStacks[3].field_77994_a <= 0) {
                    this.furnaceItemStacks[3] = null;
                }
            }
            --this.furnaceItemStacks[0].field_77994_a;
            if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    public void smeltItem2() {
        if (this.canSmelt2()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[4]);
            if (this.furnaceItemStacks[6] == null) {
                this.furnaceItemStacks[6] = itemstack.func_77946_l();
            } else if (this.furnaceItemStacks[6].func_77973_b() == itemstack.func_77973_b()) {
                this.furnaceItemStacks[6].field_77994_a += itemstack.field_77994_a;
            }
            if (BLItemRegistry.isIngotFromOre(this.furnaceItemStacks[4], this.furnaceItemStacks[6]) && this.furnaceItemStacks[7] != null) {
                boolean useFlux;
                boolean bl = useFlux = this.field_145850_b.field_73012_v.nextInt(3) == 0;
                if (useFlux && this.furnaceItemStacks[6].field_77994_a + 1 <= this.func_70297_j_() && this.furnaceItemStacks[6].field_77994_a + 1 <= this.furnaceItemStacks[6].func_77976_d()) {
                    ++this.furnaceItemStacks[6].field_77994_a;
                }
                --this.furnaceItemStacks[7].field_77994_a;
                if (this.furnaceItemStacks[7].field_77994_a <= 0) {
                    this.furnaceItemStacks[7] = null;
                }
            }
            --this.furnaceItemStacks[4].field_77994_a;
            if (this.furnaceItemStacks[4].field_77994_a <= 0) {
                this.furnaceItemStacks[4] = null;
            }
        }
    }

    public static int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item instanceof ItemGeneric && itemstack.func_77960_j() == ItemGeneric.EnumItemGeneric.SULFUR.id) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)itemstack);
    }

    public static boolean isItemFuel(ItemStack itemstack) {
        return TileEntityBLDualFurnace.getItemBurnTime(itemstack) > 0;
    }

    public static boolean isItemFlux(ItemStack itemstack) {
        return itemstack.func_77973_b() == BLItemRegistry.itemsGeneric && itemstack.func_77960_j() == ItemGeneric.EnumItemGeneric.LIMESTONE_FLUX.id;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 2 || slot == 6 ? false : (slot == 1 || slot == 5 ? TileEntityBLDualFurnace.isItemFuel(itemstack) : (slot == 3 || slot == 7 ? TileEntityBLDualFurnace.isItemFlux(itemstack) : true));
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slotsBottom : (side == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return side != 0 || slot != 1 && slot != 5 || itemstack.func_77973_b() == Items.field_151133_ar;
    }
}

